/*
 * Decompiled with CFR 0.152.
 */
package nintaco.files;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.zip.CRC32;
import nintaco.cartdb.Cart;
import nintaco.cartdb.CartDB;
import nintaco.files.CartFile;
import nintaco.files.FileUtil;
import nintaco.mappers.NametableMirroring;
import nintaco.mappers.nintendo.vs.VsGame;
import nintaco.tv.TVSystem;
import nintaco.util.BitUtil;
import nintaco.util.CollectionsUtil;
import nintaco.util.MathUtil;
import nintaco.util.StreamUtil;
import nintaco.util.StringUtil;

public class UnifFile
implements CartFile {
    private static final long serialVersionUID = 0L;
    public static final String HEADER_ID = "UNIF";
    private final byte[] fileContents;
    private byte[][] prgROMs = new byte[16][];
    private byte[][] chrROMs = new byte[16][];
    private int[] prgCRCs = new int[16];
    private int[] chrCRCs = new int[16];
    private int minimumVersion;
    private String mapper;
    private String board;
    private String name;
    private String writer;
    private String readMe;
    private String dumpAuthor;
    private int dumpDay;
    private int dumpMonth;
    private int dumpYear;
    private String dumpSoftware;
    private TVSystem tvSystem = TVSystem.NTSC;
    private boolean anyTVSystem;
    private int controller;
    private boolean nonVolatilePrgRamPresent;
    private boolean chrRamPresent;
    private int mirroring;
    private String fileName;
    private String entryFileName;
    private String archiveFileName;
    private String description;
    private int[] prgROM;
    private int[] chrROM;
    private int prgRomCRC;
    private int chrRomCRC;
    private int fileCRC;
    private int prgRomLength;
    private int chrRomLength;
    private Cart cart;

    public UnifFile(DataInputStream in, long fileSize, String entryFileName, String archiveFileName) throws Throwable {
        this(in, fileSize, entryFileName, archiveFileName, true);
    }

    public UnifFile(DataInputStream in, long fileSize, String entryFileName, String archiveFileName, boolean modifyHeader) throws Throwable {
        this.entryFileName = entryFileName;
        this.archiveFileName = archiveFileName;
        this.fileName = FileUtil.getFileName(entryFileName).toLowerCase(Locale.ENGLISH);
        this.fileContents = new byte[(int)fileSize];
        in.readFully(this.fileContents);
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.fileContents));){
            this.readHeader(dis);
            this.readChunks(dis);
        }
        this.flattenROMs();
        this.computeCRCs();
        this.checkCartDB(modifyHeader);
        this.createDescription();
        this.cleanUp();
    }

    @Override
    public int getFileType() {
        return 3;
    }

    @Override
    public int[] getFileContents() {
        return CollectionsUtil.toIntArray(this.fileContents);
    }

    private void readHeader(DataInputStream in) throws Throwable {
        if (!HEADER_ID.equals(StreamUtil.readString(in, HEADER_ID.length()))) {
            throw new IOException("Not Universal NES Image Format");
        }
        this.minimumVersion = StreamUtil.readInt32LE(in);
        in.readFully(new byte[24]);
    }

    private void readChunks(DataInputStream in) throws Throwable {
        block38: while (true) {
            byte[] type = new byte[4];
            try {
                in.readFully(type);
            }
            catch (EOFException e) {
                break;
            }
            int length = StreamUtil.readInt32LE(in);
            switch (new String(type, StandardCharsets.ISO_8859_1).toUpperCase(Locale.ENGLISH)) {
                case "MAPR": {
                    this.readMapper(in, length);
                    continue block38;
                }
                case "NAME": {
                    this.readName(in, length);
                    continue block38;
                }
                case "WRTR": {
                    this.readWriter(in, length);
                    continue block38;
                }
                case "READ": {
                    this.readReadMe(in, length);
                    continue block38;
                }
                case "DINF": {
                    this.readDumpingInformation(in);
                    continue block38;
                }
                case "TVCI": {
                    this.readTVCompatibilityInformation(in);
                    continue block38;
                }
                case "CTRL": {
                    this.readController(in);
                    continue block38;
                }
                case "BATR": {
                    this.readBatteryBackedRAM(in);
                    continue block38;
                }
                case "VROR": {
                    this.readVideoRomIsRam(in);
                    continue block38;
                }
                case "MIRR": {
                    this.readMirroring(in);
                    continue block38;
                }
            }
            int index = MathUtil.clamp(type[3] - 48, 0, 15);
            switch (new String(type, 0, 3, StandardCharsets.ISO_8859_1).toUpperCase(Locale.ENGLISH)) {
                case "PRG": {
                    this.readPrgROM(in, length, index);
                    break;
                }
                case "CHR": {
                    this.readChrROM(in, length, index);
                    break;
                }
                case "PCK": {
                    this.readPrgCRC(in, length, index);
                    break;
                }
                case "CCK": {
                    this.readChrCRC(in, length, index);
                }
            }
        }
    }

    private void createDescription() {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.archiveFileName != null) {
            StringUtil.appendLine(sb, "File name: %s <%s>", FileUtil.getFileName(this.archiveFileName), FileUtil.getFileName(this.entryFileName));
            StringUtil.appendLine(sb, "Directory: %s", FileUtil.getDirectoryPath(this.archiveFileName));
        } else {
            StringUtil.appendLine(sb, "File name: %s", FileUtil.getFileName(this.entryFileName));
            StringUtil.appendLine(sb, "Directory: %s", FileUtil.getDirectoryPath(this.entryFileName));
        }
        StringUtil.appendLine(sb, "File format: UNIF", new Object[0]);
        StringUtil.appendLine(sb, "File CRC: %08X%s", this.fileCRC, this.cart == null ? " (unknown)" : "");
        StringUtil.appendLine(sb, "Name: %s", StringUtil.makeEmpty(this.name));
        StringUtil.appendLine(sb, "Mapper: %s", StringUtil.makeEmpty(this.mapper));
        StringUtil.appendLine(sb, "Board: %s", StringUtil.makeEmpty(this.board));
        StringUtil.appendLine(sb, "Mirroring: %s", NametableMirroring.toString(this.mirroring));
        for (i = 0; i < this.prgROMs.length; ++i) {
            if (this.prgROMs[i] == null) continue;
            StringUtil.appendLine(sb, "PRG ROM %01X: length = %d, CRC = %08X", i, this.prgROMs[i].length, this.prgCRCs[i]);
        }
        for (i = 0; i < this.chrROMs.length; ++i) {
            if (this.chrROMs[i] == null) continue;
            StringUtil.appendLine(sb, "CHR ROM %01X: length = %d, CRC = %08X", i, this.chrROMs[i].length, this.chrCRCs[i]);
        }
        StringUtil.append(sb, "PRG ROM size: %d bytes", this.prgRomLength);
        if (this.prgRomLength != this.prgROM.length) {
            StringUtil.append(sb, ", %d bytes (adjusted)", this.prgROM.length);
        }
        StringUtil.appendLine(sb);
        StringUtil.appendLine(sb, "PRG ROM CRC: %08X", this.prgRomCRC);
        StringUtil.append(sb, "CHR ROM size: %d bytes", this.chrRomLength);
        if (this.chrRomLength != this.chrROM.length) {
            StringUtil.append(sb, ", %d bytes (adjusted)", this.chrROM.length);
        }
        StringUtil.appendLine(sb);
        StringUtil.appendLine(sb, "CHR ROM CRC: %08X", this.chrRomCRC);
        StringUtil.appendLine(sb, "CHR RAM: %s", StringUtil.toYesNo(this.chrRamPresent));
        StringUtil.appendLine(sb, "Non-Volatile PRG RAM: %s", StringUtil.toYesNo(this.nonVolatilePrgRamPresent));
        StringUtil.appendLine(sb, "TV System: %s", new Object[]{this.tvSystem});
        StringUtil.appendLine(sb, "Any TV System: %s", StringUtil.toYesNo(this.anyTVSystem));
        sb.append("Controllers: ");
        this.appendController(sb);
        StringUtil.appendLine(sb);
        StringUtil.appendLine(sb, "Minimum version: %d", this.minimumVersion);
        StringUtil.appendLine(sb, "Dump software: %s", StringUtil.makeEmpty(this.dumpSoftware));
        StringUtil.appendLine(sb, "Dump writer: %s", StringUtil.makeEmpty(this.writer));
        StringUtil.appendLine(sb, "Dump author: %s", StringUtil.makeEmpty(this.dumpAuthor));
        if (this.dumpYear != 0) {
            StringUtil.appendLine(sb, "Dump date: %04d-%02d-%02d", this.dumpYear, this.dumpMonth, this.dumpDay);
        } else {
            StringUtil.appendLine(sb, "Dump date:", new Object[0]);
        }
        StringUtil.appendLine(sb, "Read me: %s", StringUtil.makeEmpty(this.readMe));
        this.description = sb.toString();
    }

    private void readMapper(DataInputStream in, int length) throws Throwable {
        byte[] data = new byte[length];
        in.readFully(data);
        this.mapper = this.createString(data);
        if (this.mapper != null) {
            this.mapper = this.mapper.trim();
            if (this.mapper.length() > 4) {
                switch (this.mapper.substring(0, 4).toUpperCase(Locale.ENGLISH)) {
                    case "NES-": 
                    case "UNL-": 
                    case "HVC-": 
                    case "BTL-": 
                    case "BMC-": {
                        this.board = this.mapper.substring(4);
                        break;
                    }
                    default: {
                        this.board = this.mapper;
                    }
                }
            }
        }
    }

    private void readPrgROM(DataInputStream in, int length, int index) throws Throwable {
        this.prgROMs[index] = new byte[length];
        in.readFully(this.prgROMs[index]);
    }

    private void readChrROM(DataInputStream in, int length, int index) throws Throwable {
        this.chrROMs[index] = new byte[length];
        in.readFully(this.chrROMs[index]);
    }

    private void readPrgCRC(DataInputStream in, int length, int index) throws Throwable {
        this.prgCRCs[index] = StreamUtil.readInt32LE(in);
    }

    private void readChrCRC(DataInputStream in, int length, int index) throws Throwable {
        this.chrCRCs[index] = StreamUtil.readInt32LE(in);
    }

    private void readName(DataInputStream in, int length) throws Throwable {
        byte[] data = new byte[length];
        in.readFully(data);
        this.name = this.createString(data);
    }

    private void readWriter(DataInputStream in, int length) throws Throwable {
        byte[] data = new byte[length];
        in.readFully(data);
        this.writer = this.createString(data);
    }

    private void readReadMe(DataInputStream in, int length) throws Throwable {
        byte[] data = new byte[length];
        in.readFully(data);
        this.readMe = this.createString(data);
    }

    private void readDumpingInformation(DataInputStream in) throws Throwable {
        byte[] data = new byte[100];
        in.readFully(data);
        this.dumpAuthor = this.createString(data);
        this.dumpDay = in.readUnsignedByte();
        this.dumpMonth = in.readUnsignedByte();
        this.dumpYear = StreamUtil.readInt16LE(in);
        in.readFully(data);
        this.dumpSoftware = this.createString(data);
    }

    private void readTVCompatibilityInformation(DataInputStream in) throws Throwable {
        switch (in.readUnsignedByte()) {
            case 0: {
                this.anyTVSystem = false;
                this.tvSystem = TVSystem.NTSC;
                break;
            }
            case 1: {
                this.anyTVSystem = false;
                this.tvSystem = TVSystem.PAL;
                break;
            }
            default: {
                this.anyTVSystem = true;
                this.tvSystem = TVSystem.NTSC;
            }
        }
    }

    private void readController(DataInputStream in) throws Throwable {
        this.controller = in.readUnsignedByte();
    }

    private void readBatteryBackedRAM(DataInputStream in) throws Throwable {
        this.nonVolatilePrgRamPresent = in.readUnsignedByte() != 0;
    }

    private void readVideoRomIsRam(DataInputStream in) throws Throwable {
        this.chrRamPresent = in.readUnsignedByte() != 0;
    }

    private void readMirroring(DataInputStream in) throws Throwable {
        switch (in.readUnsignedByte()) {
            case 0: {
                this.mirroring = 1;
                break;
            }
            case 1: {
                this.mirroring = 0;
                break;
            }
            case 2: {
                this.mirroring = 2;
                break;
            }
            case 3: {
                this.mirroring = 3;
                break;
            }
            case 4: {
                this.mirroring = 4;
                break;
            }
            default: {
                this.mirroring = -1;
            }
        }
    }

    private String createString(byte[] data) {
        int length;
        if (data == null) {
            return null;
        }
        for (length = 0; length < data.length && data[length] != 0; ++length) {
        }
        return new String(data, 0, length, StandardCharsets.UTF_8);
    }

    private StringBuilder append(StringBuilder sb, boolean appendComma) {
        if (appendComma) {
            sb.append(", ");
        }
        return sb;
    }

    private void appendController(StringBuilder sb) {
        boolean appendComma = false;
        if ((this.controller & 1) != 0) {
            this.append(sb, appendComma).append("Gamepad");
            appendComma = true;
        }
        if ((this.controller & 2) != 0) {
            this.append(sb, appendComma).append("Zapper");
            appendComma = true;
        }
        if ((this.controller & 4) != 0) {
            this.append(sb, appendComma).append("R.O.B.");
            appendComma = true;
        }
        if ((this.controller & 8) != 0) {
            this.append(sb, appendComma).append("Arkanoid Vaus");
            appendComma = true;
        }
        if ((this.controller & 0x10) != 0) {
            this.append(sb, appendComma).append("Power Pad");
            appendComma = true;
        }
        if ((this.controller & 0x20) != 0) {
            this.append(sb, appendComma).append("Multitap");
            appendComma = true;
        }
    }

    private void flattenROMs() {
        this.prgRomLength = this.computeRomLength(this.prgROMs);
        this.prgROM = this.flattenROM(this.prgROMs, this.prgRomLength);
        this.chrRomLength = this.computeRomLength(this.chrROMs);
        this.chrROM = this.flattenROM(this.chrROMs, this.chrRomLength);
        if (this.chrRomLength == 0) {
            this.chrRamPresent = true;
        }
    }

    private int computeRomLength(byte[][] roms) {
        int romLength = 0;
        for (byte[] rom : roms) {
            if (rom == null) continue;
            romLength += rom.length;
        }
        return romLength;
    }

    private int[] flattenROM(byte[][] roms, int romLength) {
        if (romLength == 0) {
            return new int[0];
        }
        int[] flatROM = new int[BitUtil.ceilBase2(romLength)];
        int index = 0;
        for (byte[] rom : roms) {
            if (rom == null) continue;
            for (int j = 0; j < rom.length; ++j) {
                flatROM[index++] = rom[j] & 0xFF;
            }
        }
        return flatROM;
    }

    private void computeCRCs() {
        CRC32 crc = new CRC32();
        this.prgRomCRC = this.computeCRC(this.prgROM, crc);
        this.chrRomCRC = this.computeCRC(this.chrROM, crc);
        this.fileCRC = (int)crc.getValue();
    }

    private int computeCRC(int[] data, CRC32 crc) {
        CRC32 dataCRC = new CRC32();
        for (int i = 0; i < data.length; ++i) {
            dataCRC.update(data[i]);
            crc.update(data[i]);
        }
        return (int)dataCRC.getValue();
    }

    private void checkCartDB(boolean modifyHeader) {
        this.cart = CartDB.getCart(this.fileCRC);
        if (this.cart != null && CartDB.isEnabled() && modifyHeader) {
            if (this.cart.getMirroring() >= 0) {
                this.mirroring = this.cart.getMirroring();
            }
            this.tvSystem = this.cart.getTVSystem();
        }
    }

    private void cleanUp() {
        this.prgROMs = null;
        this.chrROMs = null;
        this.prgCRCs = null;
        this.chrCRCs = null;
    }

    @Override
    public String getEntryFileName() {
        return this.entryFileName;
    }

    @Override
    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public boolean isChrRamPresent() {
        return this.chrRamPresent;
    }

    @Override
    public boolean isNonVolatilePrgRamPresent() {
        return this.nonVolatilePrgRamPresent;
    }

    @Override
    public TVSystem getTvSystem() {
        return this.tvSystem;
    }

    @Override
    public int getMirroring() {
        return this.mirroring;
    }

    @Override
    public int[] getPrgROM() {
        return this.prgROM;
    }

    @Override
    public int[] getChrROM() {
        return this.chrROM;
    }

    @Override
    public int getFileCRC() {
        return this.fileCRC;
    }

    @Override
    public int getPrgRomLength() {
        return this.prgRomLength;
    }

    @Override
    public int getChrRomLength() {
        return this.chrRomLength;
    }

    public int getMinimumVersion() {
        return this.minimumVersion;
    }

    public String getMapper() {
        return this.mapper;
    }

    public String getBoard() {
        return this.board;
    }

    public String getName() {
        return this.name;
    }

    public String getWriter() {
        return this.writer;
    }

    public String getReadMe() {
        return this.readMe;
    }

    public String getDumpAuthor() {
        return this.dumpAuthor;
    }

    public int getDumpDay() {
        return this.dumpDay;
    }

    public int getDumpMonth() {
        return this.dumpMonth;
    }

    public int getDumpYear() {
        return this.dumpYear;
    }

    public String getDumpSoftware() {
        return this.dumpSoftware;
    }

    public boolean isAnyTVSystem() {
        return this.anyTVSystem;
    }

    public int getController() {
        return this.controller;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPrgRomCRC() {
        return this.prgRomCRC;
    }

    public int getChrRomCRC() {
        return this.chrRomCRC;
    }

    @Override
    public int getVsHardware() {
        return 0;
    }

    @Override
    public Cart getCart() {
        return this.cart;
    }

    @Override
    public VsGame getVsGame() {
        return null;
    }

    @Override
    public boolean isVsSystem() {
        return false;
    }

    @Override
    public boolean isVsUniSystem() {
        return false;
    }

    @Override
    public boolean isVsDualSystem() {
        return false;
    }

    @Override
    public int getMapperNumber() {
        return 0;
    }

    @Override
    public int getSubmapperNumber() {
        return 0;
    }

    @Override
    public boolean isTrainerPresent() {
        return false;
    }

    @Override
    public int getTrainerSize() {
        return 0;
    }

    @Override
    public int[] getTrainer() {
        return new int[0];
    }

    @Override
    public int getChrRamSize() {
        return 0;
    }

    @Override
    public int getConsole() {
        return 0;
    }

    @Override
    public int getExtendedConsole() {
        return 0;
    }

    public String toString() {
        return this.description;
    }

    public static interface ControllerMasks {
        public static final int Gamepad = 1;
        public static final int Zapper = 2;
        public static final int ROB = 4;
        public static final int Arkanoid = 8;
        public static final int PowerPad = 16;
        public static final int Multitap = 32;
    }
}

