/*
 * Decompiled with CFR 0.152.
 */
package nintaco.files.vs.goodnes;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import nintaco.files.ArchiveEntry;
import nintaco.files.FileUtil;
import nintaco.util.StringUtil;

public final class GoodNesFileUtil {
    private static final String HDR_PATH = "/nintaco/files/vs/hdr/";
    private static final String ENTRIES = "entries.txt";
    private static final String[] HEADER_FILES = new String[]{"balonfgt", "vsbball", "vsbball", "vsbball", "iceclmrd", "vsmahjng_pad", "vstennis", "wrecking"};
    private static final ArchiveEntry[][] archiveEntries;
    private static final Set<String>[] patterns;

    public static int identifyCandidate(String archiveFileName, String entryFileName) {
        if (StringUtil.isBlank(archiveFileName) || StringUtil.isBlank(entryFileName)) {
            return -1;
        }
        String _entryFileName = entryFileName.trim().toLowerCase(Locale.ENGLISH);
        int candidateID = -1;
        for (int i = patterns.length - 1; i >= 0; --i) {
            Set<String> pattern = patterns[i];
            if (!pattern.contains(_entryFileName)) continue;
            candidateID = i;
            break;
        }
        return candidateID;
    }

    public static int confirmCandidate(String archiveFileName, int candidateID, List<ArchiveEntry> allEntries) {
        HashSet<ArchiveEntry> set = new HashSet<ArchiveEntry>();
        for (int i = allEntries.size() - 1; i >= 0; --i) {
            ArchiveEntry entry = allEntries.get(i);
            set.add(new ArchiveEntry(entry.getName().trim().toLowerCase(Locale.ENGLISH), entry.getSize()));
        }
        ArchiveEntry[] entries = archiveEntries[candidateID];
        if (!set.contains(entries[0]) || !set.contains(entries[1])) {
            return -1;
        }
        return candidateID;
    }

    private static ArchiveEntry findArchiveEntry(List<ArchiveEntry> allEntries, String name) {
        for (int i = allEntries.size() - 1; i >= 0; --i) {
            ArchiveEntry e = allEntries.get(i);
            if (!e.getName().trim().equalsIgnoreCase(name)) continue;
            return e;
        }
        return null;
    }

    private static byte[] readArchiveEntry(String archiveFileName, List<ArchiveEntry> allEntries, String name) throws Throwable {
        return FileUtil.readArchiveEntry(archiveFileName, GoodNesFileUtil.findArchiveEntry(allEntries, name));
    }

    private static void readHeader(String fileName, byte[] data) throws Throwable {
        try (DataInputStream in = new DataInputStream(GoodNesFileUtil.class.getResourceAsStream(HDR_PATH + fileName + ".hdr"));){
            in.readFully(data, 0, 16);
        }
    }

    public static void getArchiveInputStream(String archiveFileName, List<ArchiveEntry> allEntries, int archiveID, FileUtil.InputStreamListener listener) throws Throwable {
        ArchiveEntry[] entries = archiveEntries[archiveID];
        byte[] entry0 = GoodNesFileUtil.readArchiveEntry(archiveFileName, allEntries, entries[0].getName());
        byte[] entry1 = GoodNesFileUtil.readArchiveEntry(archiveFileName, allEntries, entries[1].getName());
        byte[] data = new byte[98320];
        GoodNesFileUtil.readHeader(HEADER_FILES[archiveID], data);
        System.arraycopy(entry0, 16, data, 16, 32768);
        System.arraycopy(entry1, 16, data, 32784, 32768);
        if (archiveID == 6) {
            System.arraycopy(entry0, 32784, data, 65552, 16384);
            System.arraycopy(entry1, 32784, data, 81936, 16384);
        } else {
            System.arraycopy(entry1, 32784, data, 65552, archiveID == 5 ? 8192 : 16384);
        }
        listener.handleInputStream(new ByteArrayInputStream(data), data.length);
    }

    private GoodNesFileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ArchiveEntry[][] entries = null;
        try {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(GoodNesFileUtil.class.getResourceAsStream(ENTRIES)));){
                int archives = Integer.parseInt(br.readLine());
                entries = new ArchiveEntry[archives][];
                for (int i = 0; i < archives; ++i) {
                    int archiveLength = Integer.parseInt(br.readLine());
                    entries[i] = new ArchiveEntry[archiveLength];
                    ArchiveEntry[] es = entries[i];
                    for (int j = 0; j < archiveLength; ++j) {
                        es[j] = new ArchiveEntry(br.readLine(), Long.parseLong(br.readLine()));
                    }
                }
            }
            archiveEntries = entries;
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
                archiveEntries = entries;
            }
            catch (Throwable throwable) {
                archiveEntries = entries;
                patterns = new Set[archiveEntries.length];
                for (int i = patterns.length - 1; i >= 0; --i) {
                    GoodNesFileUtil.patterns[i] = new HashSet<String>();
                    HashSet<String> set = GoodNesFileUtil.patterns[i];
                    ArchiveEntry[] es = archiveEntries[i];
                    for (int j = es.length - 1; j >= 0; --j) {
                        set.add(es[j].getName());
                    }
                }
                throw throwable;
            }
            patterns = new Set[archiveEntries.length];
            for (int i = patterns.length - 1; i >= 0; --i) {
                GoodNesFileUtil.patterns[i] = new HashSet<String>();
                HashSet<String> set = GoodNesFileUtil.patterns[i];
                ArchiveEntry[] es = archiveEntries[i];
                for (int j = es.length - 1; j >= 0; --j) {
                    set.add(es[j].getName());
                }
            }
        }
        patterns = new Set[archiveEntries.length];
        for (int i = patterns.length - 1; i >= 0; --i) {
            GoodNesFileUtil.patterns[i] = new HashSet<String>();
            HashSet<String> set = GoodNesFileUtil.patterns[i];
            ArchiveEntry[] es = archiveEntries[i];
            for (int j = es.length - 1; j >= 0; --j) {
                set.add(es[j].getName());
            }
        }
    }
}

