/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import nintaco.files.FileUtil;
import nintaco.gui.archive.EntryElement;
import nintaco.gui.archive.SearchTask;
import nintaco.preferences.AppPrefs;
import nintaco.task.TaskScheduler;
import nintaco.util.GuiUtil;

public class AutocompleteFileChooser
extends JFileChooser {
    private static final KeyStroke ESCAPE_STROKE = KeyStroke.getKeyStroke(27, 0);
    private final PopupFactory popupFactory = PopupFactory.getSharedInstance();
    private final TaskScheduler scheduler = new TaskScheduler();
    private Window window;
    private Popup popup;
    private JTextField textField;
    private JList<EntryElement> list;
    private String searchText = "";
    private File oldDir;
    private final KeyEventDispatcher escDispatcher = e -> {
        if (e.getID() == 401 && e.getKeyCode() == 27) {
            if (this.popup != null) {
                this.hidePopup();
            } else {
                this.cancelSelection();
            }
        }
        return false;
    };

    public AutocompleteFileChooser(String title, String directory, FileFilter ... fileFilters) {
        this(title, directory == null ? null : new File(directory), fileFilters);
    }

    public AutocompleteFileChooser(String title, File directory, FileFilter ... fileFilters) {
        List<JTextField> textFields;
        List<JTable> tables;
        this.setDialogTitle(title);
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(false);
        if (fileFilters != null) {
            for (FileFilter filter : fileFilters) {
                this.addChoosableFileFilter(filter);
            }
        }
        if (directory != null && directory.exists() && FileUtil.isDirectory(directory.getPath())) {
            this.setCurrentDirectory(directory);
        }
        if (fileFilters != null && fileFilters.length > 0) {
            this.setFileFilter(fileFilters[0]);
        }
        GuiUtil.scaleFonts(this);
        try {
            Action details;
            ActionMap actionMap = this.getActionMap();
            if (actionMap != null && (details = actionMap.get("viewTypeDetails")) != null) {
                details.actionPerformed(null);
            }
        }
        catch (Throwable actionMap) {
            // empty catch block
        }
        Dimension size = AppPrefs.getInstance().getView().getFileChooserSize();
        if (size == null && (size = this.getPreferredSize()) != null) {
            size.width = (int)((double)size.width * 1.25);
            size.height = (int)((double)size.height * 1.5);
        }
        if (size != null) {
            this.setPreferredSize(size);
        }
        if (!(tables = GuiUtil.findComponents(JTable.class, this)).isEmpty()) {
            JViewport viewport;
            JTable table = tables.get(0);
            Container parent = table.getParent();
            if (parent instanceof JViewport && (parent = (viewport = (JViewport)parent).getParent()) instanceof JScrollPane) {
                ((JScrollPane)parent).setVerticalScrollBarPolicy(22);
            }
            table.addPropertyChangeListener("columnModel", new JFileChooserColumnWidthAdjuster(table));
            TableModel model = table.getModel();
            model.addTableModelListener(e -> {
                if (this.oldDir != null && e.getFirstRow() >= 0 && e.getLastRow() >= 0) {
                    EventQueue.invokeLater(() -> {
                        for (int row = model.getRowCount() - 1; row >= 0; --row) {
                            if (!this.oldDir.equals(model.getValueAt(row, 0))) continue;
                            GuiUtil.scrollToCenter(table, row);
                            ListSelectionModel selectionModel = table.getSelectionModel();
                            if (selectionModel == null) break;
                            table.requestFocusInWindow();
                            selectionModel.setSelectionInterval(row, row);
                            break;
                        }
                        this.oldDir = null;
                    });
                }
            });
        }
        if (!(textFields = GuiUtil.findComponents(JTextField.class, this)).isEmpty()) {
            this.textField = textFields.get(textFields.size() - 1);
            this.textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    AutocompleteFileChooser.this.hidePopup();
                }
            });
            this.textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 38: {
                            if (AutocompleteFileChooser.this.popup == null || AutocompleteFileChooser.this.list == null || AutocompleteFileChooser.this.list.getModel().getSize() <= 0) break;
                            if (AutocompleteFileChooser.this.list.getSelectedIndex() < 0) {
                                AutocompleteFileChooser.this.list.setSelectedIndex(AutocompleteFileChooser.this.list.getModel().getSize() - 1);
                            } else if (AutocompleteFileChooser.this.list.getSelectedIndex() == 0) {
                                AutocompleteFileChooser.this.list.clearSelection();
                            } else {
                                AutocompleteFileChooser.this.list.setSelectedIndex(AutocompleteFileChooser.this.list.getSelectedIndex() - 1);
                            }
                            EntryElement element = (EntryElement)AutocompleteFileChooser.this.list.getSelectedValue();
                            if (element == null) {
                                AutocompleteFileChooser.this.textField.setText(AutocompleteFileChooser.this.searchText);
                                break;
                            }
                            AutocompleteFileChooser.this.textField.setText(element.getEntry());
                            AutocompleteFileChooser.this.list.ensureIndexIsVisible(AutocompleteFileChooser.this.list.getSelectedIndex());
                            break;
                        }
                        case 40: {
                            if (AutocompleteFileChooser.this.popup == null || AutocompleteFileChooser.this.list == null || AutocompleteFileChooser.this.list.getModel().getSize() <= 0) break;
                            if (AutocompleteFileChooser.this.list.getSelectedIndex() < 0) {
                                AutocompleteFileChooser.this.list.setSelectedIndex(0);
                            } else if (AutocompleteFileChooser.this.list.getSelectedIndex() == AutocompleteFileChooser.this.list.getModel().getSize() - 1) {
                                AutocompleteFileChooser.this.list.clearSelection();
                            } else {
                                AutocompleteFileChooser.this.list.setSelectedIndex(AutocompleteFileChooser.this.list.getSelectedIndex() + 1);
                            }
                            EntryElement element = (EntryElement)AutocompleteFileChooser.this.list.getSelectedValue();
                            if (element == null) {
                                AutocompleteFileChooser.this.textField.setText(AutocompleteFileChooser.this.searchText);
                                break;
                            }
                            AutocompleteFileChooser.this.textField.setText(element.getEntry());
                            AutocompleteFileChooser.this.list.ensureIndexIsVisible(AutocompleteFileChooser.this.list.getSelectedIndex());
                        }
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 27: 
                        case 38: 
                        case 40: {
                            return;
                        }
                    }
                    AutocompleteFileChooser.this.scheduler.cancelAll();
                    AutocompleteFileChooser.this.searchText = AutocompleteFileChooser.this.textField.getText().trim();
                    if (AutocompleteFileChooser.this.searchText.isEmpty()) {
                        if (AutocompleteFileChooser.this.popup != null) {
                            AutocompleteFileChooser.this.popup.hide();
                            AutocompleteFileChooser.this.popup = null;
                        }
                        return;
                    }
                    AutocompleteFileChooser.this.scheduler.add(new AutocompleteSearchTask(AutocompleteFileChooser.this.popup, AutocompleteFileChooser.this.getCurrentDirectory(), AutocompleteFileChooser.this.getFileFilter(), AutocompleteFileChooser.this.searchText));
                    AutocompleteFileChooser.this.popup = null;
                }
            });
        }
        this.addPropertyChangeListener(e -> {
            File dir;
            if ("directoryChanged".equals(e.getPropertyName()) && (dir = (File)e.getOldValue()) != null && dir.getParentFile().equals(e.getNewValue())) {
                this.oldDir = dir;
            }
        });
    }

    private void hidePopup() {
        this.scheduler.cancelAll();
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    private void disposeScheduler() {
        this.scheduler.dispose();
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Object binding = null;
        InputMap inputMap = this.getInputMap(1);
        try {
            if (inputMap != null && inputMap.getParent() != null) {
                inputMap = inputMap.getParent();
                binding = inputMap.get(ESCAPE_STROKE);
                inputMap.remove(ESCAPE_STROKE);
            }
            keyboardFocusManager.addKeyEventDispatcher(this.escDispatcher);
            int n = super.showDialog(parent, approveButtonText);
            return n;
        }
        finally {
            this.disposeScheduler();
            keyboardFocusManager.removeKeyEventDispatcher(this.escDispatcher);
            if (inputMap != null && binding != null) {
                inputMap.put(ESCAPE_STROKE, binding);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Object binding = null;
        InputMap inputMap = this.getInputMap(1);
        try {
            if (inputMap != null && inputMap.getParent() != null) {
                inputMap = inputMap.getParent();
                binding = inputMap.get(ESCAPE_STROKE);
                inputMap.remove(ESCAPE_STROKE);
            }
            keyboardFocusManager.addKeyEventDispatcher(this.escDispatcher);
            int n = super.showSaveDialog(parent);
            return n;
        }
        finally {
            this.disposeScheduler();
            keyboardFocusManager.removeKeyEventDispatcher(this.escDispatcher);
            if (inputMap != null && binding != null) {
                inputMap.put(ESCAPE_STROKE, binding);
            }
        }
    }

    @Override
    public int showOpenDialog(Component parent) throws HeadlessException {
        try {
            int n = super.showOpenDialog(parent);
            return n;
        }
        finally {
            this.disposeScheduler();
        }
    }

    private static class JFileChooserColumnWidthAdjuster
    implements PropertyChangeListener {
        private final JTable table;

        public JFileChooserColumnWidthAdjuster(JTable table) {
            this.table = table;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            this.table.removePropertyChangeListener("columnModel", this);
            this.table.setColumnModel((TableColumnModel)e.getOldValue());
            this.table.addPropertyChangeListener("columnModel", this);
        }
    }

    private class AutocompleteSearchTask
    extends SearchTask {
        private final File directory;
        private final FileFilter fileFilter;
        private Popup popup;

        public AutocompleteSearchTask(Popup popup, File directory, FileFilter fileFilter, String searchStr) {
            super(new JList<EntryElement>(), new ArrayList<String>(), searchStr);
            this.directory = directory;
            this.fileFilter = fileFilter;
            this.popup = popup;
        }

        @Override
        public void loop() {
            if (this.directory != null) {
                File[] files = this.directory.listFiles();
                for (int i = files.length - 1; i >= 0; --i) {
                    File file = files[i];
                    if (this.fileFilter != null && !this.fileFilter.accept(file)) continue;
                    this.entries.add(file.getName());
                }
                Collections.sort(this.entries, String.CASE_INSENSITIVE_ORDER);
            }
            super.loop();
            if (this.canceled) {
                EventQueue.invokeLater(() -> {
                    if (this.popup != null) {
                        this.popup.hide();
                        this.popup = null;
                    }
                });
            }
        }

        @Override
        protected void updateModel(DefaultListModel<EntryElement> model) {
            if (this.canceled || AutocompleteFileChooser.this.popup != null) {
                if (this.popup != null) {
                    this.popup.hide();
                    this.popup = null;
                }
                return;
            }
            super.updateModel(model);
            if (model.getSize() == 0) {
                if (this.popup != null) {
                    this.popup.hide();
                    this.popup = null;
                }
                return;
            }
            this.list.clearSelection();
            Window window = SwingUtilities.getWindowAncestor(AutocompleteFileChooser.this);
            if (window != null && AutocompleteFileChooser.this.window == null) {
                AutocompleteFileChooser.this.window = window;
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                        AutocompleteFileChooser.this.hidePopup();
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                        AutocompleteFileChooser.this.hidePopup();
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                        AutocompleteFileChooser.this.hidePopup();
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        AutocompleteFileChooser.this.hidePopup();
                    }
                });
                window.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        AutocompleteFileChooser.this.hidePopup();
                    }

                    @Override
                    public void componentMoved(ComponentEvent e) {
                        AutocompleteFileChooser.this.hidePopup();
                    }

                    @Override
                    public void componentResized(ComponentEvent e) {
                        AutocompleteFileChooser.this.hidePopup();
                    }
                });
            }
            this.list.setVisibleRowCount(Math.min(15, model.getSize()));
            JScrollPane scrollPane = new JScrollPane(this.list);
            GuiUtil.scaleFonts(scrollPane);
            Rectangle workingArea = GuiUtil.getScreenWorkingArea(window);
            Dimension size = scrollPane.getPreferredSize();
            Point origin = AutocompleteFileChooser.this.textField.getLocationOnScreen();
            int y = origin.y + ((AutocompleteFileChooser)AutocompleteFileChooser.this).textField.getPreferredSize().height - 1;
            if (y + size.height > workingArea.y + workingArea.height) {
                y = origin.y - size.height + 1;
            }
            if (this.popup != null) {
                this.popup.hide();
                this.popup = null;
            }
            if (this.canceled) {
                return;
            }
            this.popup = AutocompleteFileChooser.this.popup = AutocompleteFileChooser.this.popupFactory.getPopup(AutocompleteFileChooser.this, scrollPane, origin.x, y);
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int index = AutocompleteSearchTask.this.list.locationToIndex(e.getPoint());
                    if (index < 0) {
                        AutocompleteSearchTask.this.list.clearSelection();
                        return;
                    }
                    AutocompleteSearchTask.this.list.setSelectedIndex(index);
                    EntryElement element = (EntryElement)AutocompleteSearchTask.this.list.getSelectedValue();
                    if (element != null) {
                        AutocompleteFileChooser.this.hidePopup();
                        AutocompleteFileChooser.this.textField.setText(element.getEntry());
                        AutocompleteFileChooser.this.textField.setSelectionStart(0);
                        AutocompleteFileChooser.this.textField.setSelectionEnd(element.getEntry().length());
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    AutocompleteSearchTask.this.list.clearSelection();
                }
            });
            this.list.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    int index = AutocompleteSearchTask.this.list.locationToIndex(e.getPoint());
                    if (index < 0) {
                        AutocompleteSearchTask.this.list.clearSelection();
                        return;
                    }
                    AutocompleteSearchTask.this.list.setSelectedIndex(index);
                }
            });
            AutocompleteFileChooser.this.list = this.list;
            this.popup.show();
        }
    }
}

