/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;

public class CustomFocusTraversalPolicy
extends FocusTraversalPolicy {
    private final List<Component> order = new ArrayList<Component>();

    public void add(Component component) {
        this.order.add(component);
    }

    private int getIndex(Component component) {
        int index = -1;
        while (component != null && index < 0) {
            index = this.order.indexOf(component);
            component = component.getParent();
        }
        return index;
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        int index = this.getIndex(component) + 1;
        if (index >= this.order.size()) {
            index = 0;
        }
        Component after = this.order.get(index);
        while (!(index >= this.order.size() || after.isEnabled() && after.isVisible())) {
            after = this.order.get(++index);
        }
        return after;
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        int index = this.getIndex(component) - 1;
        if (index < 0) {
            index = this.order.size() - 1;
        }
        Component before = this.order.get(index);
        while (!(index < 0 || before.isEnabled() && before.isVisible())) {
            before = this.order.get(--index);
        }
        return before;
    }

    @Override
    public Component getFirstComponent(Container container) {
        int index = 0;
        Component first = this.order.get(index);
        while (!(index >= this.order.size() || first.isEnabled() && first.isVisible())) {
            first = this.order.get(++index);
        }
        return first;
    }

    @Override
    public Component getLastComponent(Container container) {
        int index = this.order.size() - 1;
        Component last = this.order.get(index);
        while (!(index < 0 || last.isEnabled() && last.isVisible())) {
            last = this.order.get(--index);
        }
        return last;
    }

    @Override
    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }
}

