/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.io.File;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;
import nintaco.files.FileUtil;

public class FileExtensionFilter
extends FileFilter {
    private final String description;
    private final int index;
    private String[] extensions;

    public FileExtensionFilter(int index, String ... descriptionAndExtensions) {
        if (descriptionAndExtensions == null || descriptionAndExtensions.length == 0) {
            descriptionAndExtensions = new String[]{""};
        }
        this.index = index;
        this.description = descriptionAndExtensions[0];
        this.extensions = new String[descriptionAndExtensions.length - 1];
        for (int i = this.extensions.length - 1; i >= 0; --i) {
            this.extensions[i] = descriptionAndExtensions[i + 1].toLowerCase(Locale.ENGLISH);
        }
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (FileUtil.isDirectory(file) || this.extensions.length == 0) {
                return true;
            }
            String extension = FileUtil.getFileExtension(file).toLowerCase(Locale.ENGLISH);
            for (int i = this.extensions.length - 1; i >= 0; --i) {
                if (!this.extensions[i].equals(extension)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public int getIndex() {
        return this.index;
    }
}

