/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.UIManager;
import nintaco.util.GuiUtil;

public class InformationDialog
extends JDialog {
    private JLabel infoLabel;
    private JButton okButton;

    public InformationDialog(Window parent, String message, String title, IconType iconType) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        GuiUtil.scaleFonts(this);
        this.setMessage(message, title, iconType);
    }

    public void setMessage(String message, String title, IconType iconType) {
        String iconName;
        if (!message.toLowerCase().trim().startsWith("<html>")) {
            message = "<html>" + message + "</html>";
        }
        this.setTitle(title);
        this.infoLabel.setText(message);
        switch (iconType) {
            case ERROR: {
                iconName = "OptionPane.errorIcon";
                break;
            }
            case WARNING: {
                iconName = "OptionPane.warningIcon";
                break;
            }
            default: {
                iconName = "OptionPane.informationIcon";
            }
        }
        this.infoLabel.setIcon(UIManager.getIcon(iconName));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.infoLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setIconImage(null);
        this.setIconImages(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                InformationDialog.this.formWindowClosing(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setFocusPainted(false);
        this.okButton.setLabel("   OK   ");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InformationDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.infoLabel.setHorizontalAlignment(2);
        this.infoLabel.setText(" ");
        this.infoLabel.setIconTextGap(16);
        this.infoLabel.setMaximumSize(null);
        this.infoLabel.setMinimumSize(null);
        this.infoLabel.setPreferredSize(null);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.infoLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 162, Short.MAX_VALUE).addComponent(this.okButton))).addGap(15, 15, 15)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.infoLabel, -1, -1, Short.MAX_VALUE).addGap(15, 15, 15).addComponent(this.okButton).addGap(15, 15, 15)));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    public static enum IconType {
        INFORMATION,
        ERROR,
        WARNING;

    }
}

