/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import nintaco.util.GuiUtil;

public class InputDialog
extends JDialog {
    private boolean ok;
    private String input;
    private boolean textRequired;
    private InputValidator inputValidator;
    private DocumentListener documentListener;
    private JButton cancelButton;
    private JLabel iconLabel;
    private JPanel inputPanel;
    private JTextField inputTextField;
    private JButton okButton;
    private JLabel promptLabel;
    private JPanel spacerPanel;

    public InputDialog(Window parent, String message, String title) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initDocumentListener();
        this.getRootPane().setDefaultButton(this.okButton);
        GuiUtil.scaleFonts(this);
        this.setPrompt(message, title);
    }

    private void initDocumentListener() {
        this.documentListener = GuiUtil.createDocumentListener(this::enableComponents);
        this.inputTextField.getDocument().addDocumentListener(this.documentListener);
    }

    @Override
    public void setVisible(boolean visible) {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        super.setVisible(visible);
    }

    public void setInputValidator(InputValidator inputValidator) {
        this.inputValidator = inputValidator;
    }

    public void setMaxInputLength(int maxLength) {
        GuiUtil.limitTextFieldLength(this.inputTextField, maxLength);
        this.initDocumentListener();
    }

    public void setInput(String input) {
        if (input == null) {
            return;
        }
        this.inputTextField.getDocument().removeDocumentListener(this.documentListener);
        this.inputTextField.setText(input);
        this.inputTextField.getDocument().addDocumentListener(this.documentListener);
        this.inputTextField.selectAll();
        this.enableComponents();
        this.inputTextField.requestFocus();
    }

    private void enableComponents() {
        boolean enabled;
        String text = this.inputTextField.getText();
        boolean bl = enabled = !this.textRequired || !text.isEmpty();
        if (enabled && this.inputValidator != null) {
            enabled = this.inputValidator.validate(text);
        }
        this.okButton.setEnabled(enabled);
    }

    public void setTextRequired() {
        this.textRequired = true;
        this.enableComponents();
    }

    public final void setPrompt(String message, String title) {
        if (!message.toLowerCase().trim().startsWith("<html>")) {
            message = "<html>" + message + "</html>";
        }
        this.setTitle(title);
        this.promptLabel.setText(message);
        this.iconLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        this.inputTextField.requestFocus();
    }

    public void setOkButtonMnemonic(char mnemonic) {
        this.okButton.setMnemonic(mnemonic);
    }

    public void setOkButtonText(String text) {
        this.okButton.setText(text);
    }

    public void setCancelButtonMnemonic(char mnemonic) {
        this.cancelButton.setMnemonic(mnemonic);
    }

    public void setCancelButtonText(String text) {
        this.cancelButton.setText(text);
    }

    public String getInput() {
        return this.input;
    }

    public boolean isOk() {
        return this.ok;
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.inputPanel = new JPanel();
        this.inputTextField = new JTextField();
        this.promptLabel = new JLabel();
        this.iconLabel = new JLabel();
        this.spacerPanel = new JPanel();
        this.setDefaultCloseOperation(0);
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                InputDialog.this.formWindowClosing(evt);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.setLabel("   Cancel   ");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.inputTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputDialog.this.inputTextFieldActionPerformed(evt);
            }
        });
        this.promptLabel.setText(" ");
        GroupLayout inputPanelLayout = new GroupLayout(this.inputPanel);
        this.inputPanel.setLayout(inputPanelLayout);
        inputPanelLayout.setHorizontalGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, inputPanelLayout.createSequentialGroup().addGap(15, 15, 15).addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.inputTextField, -2, 0, Short.MAX_VALUE).addComponent(this.promptLabel, -1, -1, Short.MAX_VALUE)).addGap(1, 1, 1)));
        inputPanelLayout.setVerticalGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.promptLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputTextField, -2, -1, -2).addGap(15, 15, 15)));
        this.iconLabel.setText(" ");
        this.spacerPanel.setMaximumSize(null);
        GroupLayout spacerPanelLayout = new GroupLayout(this.spacerPanel);
        this.spacerPanel.setLayout(spacerPanelLayout);
        spacerPanelLayout.setHorizontalGroup(spacerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 50, Short.MAX_VALUE));
        spacerPanelLayout.setVerticalGroup(spacerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.spacerPanel, -2, -1, -2).addComponent(this.iconLabel, -2, 50, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inputPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addGap(15, 15, 15)));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.linkSize(0, this.iconLabel, this.spacerPanel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconLabel).addComponent(this.inputPanel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton))).addComponent(this.spacerPanel, -1, -1, Short.MAX_VALUE)).addGap(15, 15, 15)));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.ok = true;
        this.input = this.inputTextField.getText();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void inputTextFieldActionPerformed(ActionEvent evt) {
        if (this.okButton.isEnabled()) {
            this.okButton.doClick();
        }
    }

    @FunctionalInterface
    public static interface InputValidator {
        public boolean validate(String var1);
    }
}

