/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.api.local;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import nintaco.App;
import nintaco.api.local.JarClassLoader;
import nintaco.api.local.LocalAPI;
import nintaco.files.FileUtil;
import nintaco.gui.FileExtensionFilter;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.api.local.ProgramGamePrefs;
import nintaco.gui.api.local.TextAreaOutputStream;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.util.CollectionsUtil;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class ProgramFrame
extends JFrame {
    private static final PrintStream standardOutput = System.out;
    private static final PrintStream standardError = System.err;
    private final PrintStream textAreaPrintStream;
    private JarClassLoader classLoader;
    private String loadedJarFileName;
    public static final FileExtensionFilter[] FileExtensionFilters = new FileExtensionFilter[]{new FileExtensionFilter(0, "JAR files (*.jar)", "jar"), new FileExtensionFilter(1, "All files (*.*)")};
    private JLabel argumentsLabel;
    private JTextField argumentsTextField;
    private JButton clearOutputButton;
    private JButton findJarButton;
    private JButton hideWindowButton;
    private JPanel jarFilePanel;
    private JLabel jarNameLabel;
    private JTextField jarNameTextField;
    private JButton loadJarButton;
    private JComboBox mainClassComboBox;
    private JLabel mainClassLabel;
    private JPanel outputPanel;
    private JScrollPane outputScrollPane;
    private JTextArea outputTextArea;
    private JPanel runConfigurationPanel;
    private JToggleButton runToggleButton;
    private JLabel statusLabel;

    public ProgramFrame() {
        this.initComponents();
        this.clearRunConfiguration();
        GuiUtil.makeMonospaced(this.outputTextArea);
        this.outputTextArea.setCursor(new Cursor(2));
        this.textAreaPrintStream = new PrintStream(new TextAreaOutputStream(this.outputTextArea));
        GuiUtil.enableAutoscroll(this.outputTextArea);
        GuiUtil.addTextFieldEditListener(this.jarNameTextField, this::jarNameTextFieldEdited);
        this.loadFields();
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    private void closeFrame() {
        this.saveFields();
        this.setVisible(false);
    }

    public void destroy() {
        this.saveFields();
        this.dispose();
    }

    private void loadFields() {
        String jarDir;
        String jarName = "";
        jarName = GamePrefs.getInstance().getProgramGamePrefs().getJar();
        if (StringUtil.isBlank(jarName) && !StringUtil.isBlank(jarDir = AppPrefs.getInstance().getPaths().getJarDir())) {
            jarName = jarDir;
        }
        this.jarNameTextField.setText(jarName);
    }

    private void saveFields() {
        String jarName = this.jarNameTextField.getText().trim();
        AppPrefs.getInstance().getPaths().setJarDir(StringUtil.isBlank(jarName) ? null : FileUtil.getDirectoryPath(jarName));
        ProgramGamePrefs prefs = GamePrefs.getInstance().getProgramGamePrefs();
        prefs.setJar(jarName);
        prefs.setMainClass((String)this.mainClassComboBox.getSelectedItem());
        GamePrefs.save();
    }

    private void jarNameTextFieldEdited() {
        this.updateLoadJarButton();
        this.clearRunConfiguration();
    }

    private void updateLoadJarButton() {
        File file = new File(this.jarNameTextField.getText());
        this.loadJarButton.setEnabled(file.exists() && file.isFile());
    }

    private void loadJarFile(String fileName, PleaseWaitDialog pleaseWaitDialog) {
        this.loadedJarFileName = null;
        File file = new File(fileName);
        if (!file.isFile() || !file.exists()) {
            GuiUtil.displayError(this, "JAR file not found.");
            pleaseWaitDialog.dispose();
            return;
        }
        String[] mainClassNames = null;
        boolean error = false;
        try (JarClassLoader loader = new JarClassLoader(fileName);){
            mainClassNames = loader.getMainClassNames();
        }
        catch (Throwable t) {
            error = true;
        }
        pleaseWaitDialog.dispose();
        if (error) {
            GuiUtil.displayError(this, "Failed to load JAR file.");
        } else if (CollectionsUtil.isBlank(mainClassNames)) {
            GuiUtil.displayError(this, "The JAR file does not contain any main class files.");
        } else {
            this.loadedJarFileName = fileName;
            String[] names = mainClassNames;
            EventQueue.invokeLater(() -> this.setRunConfiguration(names));
        }
    }

    private void setJarFileEnabled(boolean enabled) {
        this.jarFilePanel.setEnabled(enabled);
        this.jarNameLabel.setEnabled(enabled);
        this.jarNameTextField.setEnabled(enabled);
        this.findJarButton.setEnabled(enabled);
        if (enabled) {
            this.updateLoadJarButton();
        } else {
            this.loadJarButton.setEnabled(false);
        }
    }

    private void setRunConfiguration(String[] mainClassNames) {
        this.mainClassComboBox.setModel(new DefaultComboBoxModel<String>(mainClassNames));
        String mainClass = GamePrefs.getInstance().getProgramGamePrefs().getMainClass();
        if (!StringUtil.isBlank(mainClass) && CollectionsUtil.contains(mainClassNames, mainClass)) {
            this.mainClassComboBox.setSelectedItem(mainClass);
        }
        this.runConfigurationPanel.setEnabled(true);
        this.mainClassLabel.setEnabled(true);
        this.mainClassComboBox.setEnabled(true);
        this.argumentsLabel.setEnabled(true);
        this.argumentsTextField.setEnabled(true);
        this.runToggleButton.setEnabled(true);
        this.argumentsTextField.requestFocusInWindow();
    }

    private void clearRunConfiguration() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("                                          ");
        this.mainClassComboBox.setModel(model);
        this.runConfigurationPanel.setEnabled(false);
        this.mainClassLabel.setEnabled(false);
        this.mainClassComboBox.setEnabled(false);
        this.argumentsLabel.setEnabled(false);
        this.argumentsTextField.setEnabled(false);
        this.runToggleButton.setEnabled(false);
    }

    private String[] parseArguments(String text) {
        ArrayList<String> args = new ArrayList<String>();
        boolean insideString = false;
        int length = text.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= length; ++i) {
            if (i == length) {
                if (sb.length() <= 0) continue;
                args.add(sb.toString());
                continue;
            }
            char c = text.charAt(i);
            if (insideString) {
                if (c == '\\') {
                    if (i + 1 == length) {
                        sb.append(c);
                        continue;
                    }
                    char c1 = text.charAt(++i);
                    switch (c1) {
                        case '\'': {
                            sb.append('\'');
                            break;
                        }
                        case '\"': {
                            sb.append('\"');
                            break;
                        }
                        case '\\': {
                            sb.append('\\');
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': {
                            char c2;
                            int value = c1 - 48;
                            if (i + 1 != length && (c2 = text.charAt(i + 1)) >= '0' && c2 <= '7') {
                                char c3;
                                value = value << 3 | c2 - 48;
                                if (++i + 1 != length && (c3 = text.charAt(i + 1)) >= '0' && c3 <= '7') {
                                    value = value << 3 | c3 - 48;
                                    ++i;
                                }
                            }
                            sb.append((char)value);
                            break;
                        }
                        case 'b': {
                            sb.append('\b');
                            break;
                        }
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 'r': {
                            sb.append('\r');
                            break;
                        }
                        case 'f': {
                            sb.append('\f');
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            break;
                        }
                        case 'u': {
                            if (i + 4 < length) {
                                try {
                                    sb.append(Character.toChars(Integer.parseInt(text.substring(i + 1, i + 5), 16)));
                                    i += 4;
                                }
                                catch (Throwable t) {
                                    sb.append(c);
                                    sb.append(c1);
                                }
                                break;
                            }
                            sb.append(c);
                            sb.append(c1);
                            break;
                        }
                        default: {
                            sb.append(c);
                            sb.append(c1);
                            break;
                        }
                    }
                    continue;
                }
                if (c == '\"') {
                    insideString = false;
                    if (sb.length() <= 0) continue;
                    args.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == '\"' && (i == 0 || Character.isWhitespace(text.charAt(i - 1)))) {
                insideString = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (sb.length() <= 0) continue;
                args.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        return CollectionsUtil.convertToArray(String.class, args, false);
    }

    private void runPressed(String jarFileName, String mainClassName, String[] arguments) {
        File file = new File(jarFileName);
        if (!file.isFile() || !file.exists()) {
            GuiUtil.displayError(this, "JAR file not found.");
            EventQueue.invokeLater(this::stopButtonPressed);
            return;
        }
        LocalAPI.setLocalAPI(new LocalAPI());
        System.setOut(this.textAreaPrintStream);
        System.setErr(this.textAreaPrintStream);
        try {
            this.classLoader = new JarClassLoader(file);
            this.classLoader.runMain(mainClassName, arguments);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void runButtonPressed() {
        String jarFileName = this.loadedJarFileName;
        String mainClassName = (String)this.mainClassComboBox.getSelectedItem();
        String arguments = this.argumentsTextField.getText();
        this.mainClassLabel.setEnabled(false);
        this.mainClassComboBox.setEnabled(false);
        this.argumentsLabel.setEnabled(false);
        this.argumentsTextField.setEnabled(false);
        this.hideWindowButton.setEnabled(true);
        this.runToggleButton.setMnemonic('S');
        this.runToggleButton.setText("Stop");
        GuiUtil.scrollToBottom(this.outputTextArea);
        this.setJarFileEnabled(false);
        this.setTitle("Program Controls");
        new Thread(() -> this.runPressed(jarFileName, mainClassName, this.parseArguments(arguments))).start();
    }

    private void stopPressed() {
        LocalAPI api = LocalAPI.getLocalAPI();
        if (api != null) {
            LocalAPI.setLocalAPI(null);
            api.dispose();
        }
        System.setOut(standardOutput);
        System.setErr(standardError);
        JarClassLoader loader = this.classLoader;
        if (loader != null) {
            try {
                loader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void stopButtonPressed() {
        this.runToggleButton.setMnemonic('R');
        this.runToggleButton.setText("Run");
        this.mainClassLabel.setEnabled(true);
        this.mainClassComboBox.setEnabled(true);
        this.argumentsLabel.setEnabled(true);
        this.argumentsTextField.setEnabled(true);
        this.hideWindowButton.setEnabled(false);
        this.setJarFileEnabled(true);
        this.setTitle("Run Program");
        new Thread(this::stopPressed).start();
    }

    private void initComponents() {
        this.jarFilePanel = new JPanel();
        this.jarNameLabel = new JLabel();
        this.jarNameTextField = new JTextField();
        this.loadJarButton = new JButton();
        this.findJarButton = new JButton();
        this.statusLabel = new JLabel();
        this.runConfigurationPanel = new JPanel();
        this.argumentsTextField = new JTextField();
        this.mainClassLabel = new JLabel();
        this.argumentsLabel = new JLabel();
        this.mainClassComboBox = new JComboBox();
        this.runToggleButton = new JToggleButton();
        this.outputPanel = new JPanel();
        this.clearOutputButton = new JButton();
        this.outputScrollPane = new JScrollPane();
        this.outputTextArea = new JTextArea();
        this.hideWindowButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Run Program");
        this.setMinimumSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProgramFrame.this.formWindowClosing(evt);
            }
        });
        this.jarFilePanel.setBorder(BorderFactory.createTitledBorder("JAR File"));
        this.jarNameLabel.setText("JAR name:");
        this.jarNameTextField.setMaximumSize(null);
        this.jarNameTextField.setMinimumSize(null);
        this.jarNameTextField.setPreferredSize(null);
        this.loadJarButton.setMnemonic('L');
        this.loadJarButton.setText("Load JAR");
        this.loadJarButton.setEnabled(false);
        this.loadJarButton.setFocusPainted(false);
        this.loadJarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramFrame.this.loadJarButtonActionPerformed(evt);
            }
        });
        this.findJarButton.setMnemonic('F');
        this.findJarButton.setText("Find JAR...");
        this.findJarButton.setFocusPainted(false);
        this.findJarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramFrame.this.findJarButtonActionPerformed(evt);
            }
        });
        GroupLayout jarFilePanelLayout = new GroupLayout(this.jarFilePanel);
        this.jarFilePanel.setLayout(jarFilePanelLayout);
        jarFilePanelLayout.setHorizontalGroup(jarFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jarFilePanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jarNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jarNameTextField, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.findJarButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadJarButton).addGap(5, 5, 5)));
        jarFilePanelLayout.setVerticalGroup(jarFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jarFilePanelLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(jarFilePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jarNameLabel).addComponent(this.findJarButton).addComponent(this.jarNameTextField, -2, -1, -2).addComponent(this.loadJarButton)).addGap(5, 5, 5)));
        this.statusLabel.setText(" ");
        this.statusLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.statusLabel.setMaximumSize(null);
        this.statusLabel.setMinimumSize(null);
        this.statusLabel.setPreferredSize(null);
        this.runConfigurationPanel.setBorder(BorderFactory.createTitledBorder("Run Configuration"));
        this.argumentsTextField.setMaximumSize(null);
        this.argumentsTextField.setMinimumSize(null);
        this.argumentsTextField.setPreferredSize(null);
        this.mainClassLabel.setText("Main class:");
        this.mainClassLabel.setMaximumSize(null);
        this.mainClassLabel.setMinimumSize(null);
        this.mainClassLabel.setPreferredSize(null);
        this.argumentsLabel.setText("Arguments:");
        this.argumentsLabel.setMaximumSize(null);
        this.argumentsLabel.setMinimumSize(null);
        this.argumentsLabel.setName("");
        this.argumentsLabel.setPreferredSize(null);
        this.mainClassComboBox.setFocusable(false);
        this.mainClassComboBox.setMaximumSize(null);
        this.mainClassComboBox.setMinimumSize(null);
        this.mainClassComboBox.setPreferredSize(null);
        this.runToggleButton.setMnemonic('R');
        this.runToggleButton.setText("Run");
        this.runToggleButton.setFocusPainted(false);
        this.runToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramFrame.this.runToggleButtonActionPerformed(evt);
            }
        });
        GroupLayout runConfigurationPanelLayout = new GroupLayout(this.runConfigurationPanel);
        this.runConfigurationPanel.setLayout(runConfigurationPanelLayout);
        runConfigurationPanelLayout.setHorizontalGroup(runConfigurationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(runConfigurationPanelLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(runConfigurationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainClassLabel, -2, -1, -2).addComponent(this.argumentsLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(runConfigurationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainClassComboBox, -2, -1, -2).addComponent(this.argumentsTextField, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runToggleButton).addGap(5, 5, 5)));
        runConfigurationPanelLayout.setVerticalGroup(runConfigurationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(runConfigurationPanelLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(runConfigurationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainClassLabel, -2, -1, -2).addComponent(this.mainClassComboBox, -2, -1, -2)).addGap(7, 7, 7).addGroup(runConfigurationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.argumentsLabel, -2, -1, -2).addComponent(this.argumentsTextField, -2, -1, -2).addComponent(this.runToggleButton)).addGap(5, 5, 5)));
        this.outputPanel.setBorder(BorderFactory.createTitledBorder("Output"));
        this.clearOutputButton.setMnemonic('C');
        this.clearOutputButton.setText("Clear Output");
        this.clearOutputButton.setFocusPainted(false);
        this.clearOutputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramFrame.this.clearOutputButtonActionPerformed(evt);
            }
        });
        this.outputScrollPane.setMaximumSize(null);
        this.outputScrollPane.setMinimumSize(null);
        this.outputScrollPane.setPreferredSize(null);
        this.outputTextArea.setEditable(false);
        this.outputTextArea.setColumns(80);
        this.outputTextArea.setRows(10);
        this.outputTextArea.setMaximumSize(null);
        this.outputTextArea.setMinimumSize(null);
        this.outputTextArea.setPreferredSize(null);
        this.outputTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ProgramFrame.this.outputTextAreaFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ProgramFrame.this.outputTextAreaFocusLost(evt);
            }
        });
        this.outputScrollPane.setViewportView(this.outputTextArea);
        this.hideWindowButton.setMnemonic('H');
        this.hideWindowButton.setText("Hide Window");
        this.hideWindowButton.setEnabled(false);
        this.hideWindowButton.setFocusPainted(false);
        this.hideWindowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramFrame.this.hideWindowButtonActionPerformed(evt);
            }
        });
        GroupLayout outputPanelLayout = new GroupLayout(this.outputPanel);
        this.outputPanel.setLayout(outputPanelLayout);
        outputPanelLayout.setHorizontalGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputPanelLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputScrollPane, -1, -1, Short.MAX_VALUE).addGroup(outputPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.clearOutputButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideWindowButton))).addGap(5, 5, 5)));
        outputPanelLayout.setVerticalGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.outputScrollPane, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearOutputButton).addComponent(this.hideWindowButton)).addGap(4, 4, 4)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jarFilePanel, -1, -1, Short.MAX_VALUE).addComponent(this.runConfigurationPanel, -1, -1, Short.MAX_VALUE).addComponent(this.outputPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jarFilePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runConfigurationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusLabel, -2, -1, -2)));
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.hideWindowButton.isEnabled()) {
            this.closeFrame();
        } else {
            App.destroyProgramFrame();
        }
    }

    private void findJarButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser;
        ProgramGamePrefs prefs = GamePrefs.getInstance().getProgramGamePrefs();
        String directory = null;
        String jarName = this.jarNameTextField.getText();
        if (!StringUtil.isBlank(jarName)) {
            directory = FileUtil.getDirectoryPath(jarName);
        }
        if (StringUtil.isBlank(directory)) {
            directory = FileUtil.getDirectoryPath(prefs.getJar());
        }
        if (StringUtil.isBlank(directory)) {
            directory = AppPrefs.getInstance().getPaths().getJarDir();
        }
        if (GuiUtil.showOpenDialog(this, chooser = GuiUtil.createFileChooser("Select JAR File", directory, (FileFilter[])FileExtensionFilters)) == 0) {
            String fileName = chooser.getSelectedFile().toString();
            this.jarNameTextField.setText(fileName);
            prefs.setJar(fileName);
            GamePrefs.save();
        }
    }

    private void clearOutputButtonActionPerformed(ActionEvent evt) {
        this.outputTextArea.setText("");
    }

    private void runToggleButtonActionPerformed(ActionEvent evt) {
        if (this.runToggleButton.isSelected()) {
            this.runButtonPressed();
        } else {
            this.stopButtonPressed();
        }
    }

    private void loadJarButtonActionPerformed(ActionEvent evt) {
        String fileName = this.jarNameTextField.getText();
        if (StringUtil.isBlank(fileName)) {
            GuiUtil.displayError(this, "Enter a JAR file name.");
            return;
        }
        PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
        pleaseWaitDialog.setMessage("Loading JAR file...");
        this.clearRunConfiguration();
        new Thread(() -> this.loadJarFile(fileName, pleaseWaitDialog)).start();
        pleaseWaitDialog.showAfterDelay();
    }

    private void hideWindowButtonActionPerformed(ActionEvent evt) {
        this.closeFrame();
    }

    private void outputTextAreaFocusGained(FocusEvent evt) {
        GuiUtil.showCursor(this.outputTextArea);
    }

    private void outputTextAreaFocusLost(FocusEvent evt) {
        GuiUtil.hideCursor(this.outputTextArea);
    }
}

