/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.exportmedia;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import nintaco.App;
import nintaco.MachineRunner;
import nintaco.apu.AudioProcessor;
import nintaco.apu.SystemAudioProcessor;
import nintaco.files.FileUtil;
import nintaco.gui.FileExtensionFilter;
import nintaco.gui.InformationDialog;
import nintaco.gui.ProgressDialog;
import nintaco.gui.exportmedia.ImageConverter;
import nintaco.gui.exportmedia.preferences.ExportMediaFilePrefs;
import nintaco.gui.exportmedia.preferences.FramesOption;
import nintaco.gui.exportmedia.preferences.MediaType;
import nintaco.gui.exportmedia.preferences.VideoType;
import nintaco.gui.historyeditor.tasks.FramePlayedListener;
import nintaco.gui.historyeditor.tasks.PlayMovieTask;
import nintaco.gui.historyeditor.tasks.TaskTerminatedListener;
import nintaco.gui.image.filters.VideoFilterDescriptor;
import nintaco.gui.image.preferences.Paths;
import nintaco.movie.GifSequenceWriter;
import nintaco.movie.Movie;
import nintaco.movie.VideoFile;
import nintaco.preferences.AppPrefs;
import nintaco.tv.TVSystem;
import nintaco.util.GuiUtil;
import nintaco.util.MathUtil;
import nintaco.util.StringUtil;

public class ExportMediaFileDialog
extends JDialog {
    private static final String ERROR_TITLE = "Export Media Error";
    private final String fileBase;
    private final Movie movie;
    private final int startFrameIndex;
    private final int endFrameIndex;
    private final BufferedImage image;
    private final int[] screen;
    private VideoFile videoFile;
    private ImageOutputStream imageOutputStream;
    private GifSequenceWriter gifSequenceWriter;
    private ImageConverter imageConverter;
    private TVSystem lastTVSystem;
    private volatile PlayMovieTask playMovieTask;
    private JButton browseButton;
    private JButton cancelButton;
    private JCheckBox cropBordersCheckBox;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JLabel filterLabel;
    private JComboBox<FramesOption> framesComboBox;
    private JLabel framesLabel;
    private JComboBox<MediaType> mediaComboBox;
    private JLabel mediaLabel;
    private JButton okButton;
    private JComboBox<String> paletteComboBox;
    private JLabel paletteLabel;
    private JCheckBox recordAudioCheckBox;
    private JComboBox<String> scaleComboBox;
    private JLabel scaleLabel;
    private JCheckBox smoothScalingCheckBox;
    private JCheckBox tvAspectCheckBox;
    private JComboBox<String> typeComboBox;
    private JLabel typeLabel;
    private JComboBox<VideoFilterDescriptor> videoFiltersComboBox;

    public ExportMediaFileDialog(Window parent, Movie movie, int startFrameIndex, int endFrameIndex, BufferedImage image, int[] screen) {
        super(parent);
        String base = FileUtil.getFileNameWithoutExtension(App.getEntryFileName());
        this.fileBase = StringUtil.isBlank(base) ? "media" : base;
        this.movie = movie;
        this.startFrameIndex = startFrameIndex;
        this.endFrameIndex = endFrameIndex;
        this.image = image;
        this.screen = screen;
        this.setModal(true);
        this.initComponents();
        this.initPaletteComboBox();
        GuiUtil.addTextFieldEditListener(this.fileTextField, this::fileTextFieldEdited);
        this.updateTypeComboBox();
        this.loadFields();
        this.runNsfCheck();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void runNsfCheck() {
        if (App.getNsfFile() != null) {
            this.mediaComboBox.setSelectedItem((Object)MediaType.Audio);
            this.mediaComboBox.setEnabled(false);
            this.mediaLabel.setEnabled(false);
        }
    }

    private void initPaletteComboBox() {
        ArrayList<String> names = new ArrayList<String>();
        AppPrefs.getInstance().getPalettes().getPaletteNames(names);
        names.add(0, "[current]");
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String name : names) {
            model.addElement(name);
        }
        this.paletteComboBox.setModel(model);
    }

    private void loadFields() {
        this.fileTextField.setText(AppPrefs.getInstance().getPaths().getMediaDir());
        ExportMediaFilePrefs prefs = AppPrefs.getInstance().getExportMediaFilePrefs();
        this.mediaComboBox.setSelectedItem((Object)prefs.getMediaType());
        this.typeComboBox.setSelectedIndex(prefs.getFileType());
        this.recordAudioCheckBox.setSelected(prefs.isRecordAudio());
        this.cropBordersCheckBox.setSelected(prefs.isCropBorders());
        this.framesComboBox.setSelectedItem((Object)prefs.getFramesOption());
        this.videoFiltersComboBox.setSelectedItem((Object)prefs.getVideoFilter());
        this.paletteComboBox.setSelectedItem(prefs.getPalette());
        this.scaleComboBox.setSelectedIndex(prefs.getScale() - 1);
        this.smoothScalingCheckBox.setSelected(prefs.isSmoothScaling());
        this.tvAspectCheckBox.setSelected(prefs.isUseTvAspectRatio());
    }

    private ExportMediaFilePrefs saveFields() {
        String dir = FileUtil.getDirectoryPath(this.fileTextField.getText().trim());
        if (dir != null) {
            Paths paths = AppPrefs.getInstance().getPaths();
            paths.setMediaDir(dir);
            paths.addRecentDirectory(dir);
        }
        ExportMediaFilePrefs prefs = AppPrefs.getInstance().getExportMediaFilePrefs();
        prefs.setFileName(this.fileTextField.getText().trim());
        prefs.setMediaType((MediaType)((Object)this.mediaComboBox.getSelectedItem()));
        prefs.setFileType(this.typeComboBox.getSelectedIndex());
        prefs.setRecordAudio(this.recordAudioCheckBox.isSelected());
        prefs.setCropBorders(this.cropBordersCheckBox.isSelected());
        prefs.setFramesOption((FramesOption)((Object)this.framesComboBox.getSelectedItem()));
        prefs.setVideoFilter((VideoFilterDescriptor)((Object)this.videoFiltersComboBox.getSelectedItem()));
        prefs.setPalette((String)this.paletteComboBox.getSelectedItem());
        prefs.setScale(this.scaleComboBox.getSelectedIndex() + 1);
        prefs.setSmoothScaling(this.smoothScalingCheckBox.isSelected());
        prefs.setUseTvAspectRatio(this.tvAspectCheckBox.isSelected());
        AppPrefs.save();
        return prefs;
    }

    private void fileTextFieldEdited() {
        this.okButton.setEnabled(!StringUtil.isBlank(this.fileTextField.getText()));
    }

    private String getExtension() {
        switch ((MediaType)((Object)this.mediaComboBox.getSelectedItem())) {
            case Video: {
                return VideoType.EXTENSIONS[this.typeComboBox.getSelectedIndex()];
            }
            case Audio: {
                return SystemAudioProcessor.getSupportedAudioFileTypes()[this.typeComboBox.getSelectedIndex()].getExtension();
            }
        }
        return null;
    }

    private void updateFileName() {
        String fileName = new File(this.fileTextField.getText().trim()).getPath();
        if (fileName.isEmpty()) {
            fileName = AppPrefs.getInstance().getPaths().getMediaDir();
        }
        boolean dir = false;
        String extension = null;
        switch ((MediaType)((Object)this.mediaComboBox.getSelectedItem())) {
            case Video: {
                extension = VideoType.EXTENSIONS[this.typeComboBox.getSelectedIndex()];
                break;
            }
            case Audio: {
                extension = SystemAudioProcessor.getSupportedAudioFileTypes()[this.typeComboBox.getSelectedIndex()].getExtension();
                break;
            }
            case Frames: {
                dir = true;
            }
        }
        File file = new File(fileName);
        if (FileUtil.isDirectory(fileName)) {
            if (!dir) {
                fileName = this.fileBase.equals(file.getName()) ? file.getPath() + "." + extension : FileUtil.appendSeparator(fileName) + this.fileBase + "." + extension;
            }
        } else if (dir) {
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                fileName = AppPrefs.getInstance().getPaths().getMediaDir();
                if (!this.fileBase.equals(new File(fileName).getName())) {
                    fileName = FileUtil.appendSeparator(fileName) + this.fileBase;
                }
            } else {
                fileName = this.fileBase.equals(parentFile.getName()) ? parentFile.getPath() : FileUtil.appendSeparator(parentFile.getPath()) + this.fileBase;
            }
        } else {
            fileName = FileUtil.removeExtension(fileName) + "." + extension;
        }
        this.fileTextField.setText(fileName);
    }

    private void closeDialog() {
        this.disposeImageConverter();
        this.dispose();
    }

    private FileExtensionFilter getFilterExtensionFilter() {
        String extension = this.getExtension();
        if (extension == null) {
            return null;
        }
        return new FileExtensionFilter(0, String.format("%1$s files (*.%1$s)", extension), extension);
    }

    private void updateTypeComboBox() {
        int selectedIndex = 0;
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        switch ((MediaType)((Object)this.mediaComboBox.getSelectedItem())) {
            case Video: {
                model.addElement("avi (TechSmith Screen Capture Codec)");
                model.addElement("mov (TechSmith Screen Capture Codec)");
                model.addElement("animated gif");
                break;
            }
            case Audio: {
                for (AudioFileFormat.Type type : SystemAudioProcessor.getSupportedAudioFileTypes()) {
                    String extension = type.getExtension();
                    if ("wav".equalsIgnoreCase(extension)) {
                        selectedIndex = model.getSize();
                    }
                    model.addElement(extension);
                }
                break;
            }
            case Frames: {
                for (String format : GuiUtil.getWritableImageFileFormats()) {
                    if ("png".equalsIgnoreCase(format)) {
                        selectedIndex = model.getSize();
                    }
                    model.addElement(format);
                }
                break;
            }
        }
        this.typeComboBox.setModel(model);
        this.typeComboBox.setSelectedIndex(selectedIndex);
    }

    private void exportMedia(ProgressDialog progressDialog) {
        PlayMovieTask task = this.playMovieTask;
        if (task != null) {
            task.run();
        }
        progressDialog.dispose();
    }

    private void cancelExport() {
        PlayMovieTask task = this.playMovieTask;
        if (task != null) {
            task.cancel();
        }
        this.disposeImageConverter();
    }

    private void writeImage(String format, String extension, int frameIndex, MachineRunner machineRunner, ExportMediaFilePrefs prefs, ProgressDialog progressDialog) {
        block5: {
            try {
                BufferedImage img;
                progressDialog.setMessage("Frame: " + frameIndex);
                progressDialog.setValue(frameIndex);
                TVSystem tvSystem = machineRunner.getMapper().getTVSystem();
                if (this.imageConverter == null || tvSystem != this.lastTVSystem) {
                    this.lastTVSystem = tvSystem;
                    this.disposeImageConverter();
                    this.imageConverter = new ImageConverter(prefs, tvSystem, true);
                    this.imageConverter.setImage(this.image);
                }
                if ((img = this.imageConverter.convert()) != null) {
                    ImageIO.write((RenderedImage)img, extension, new File(String.format(format, frameIndex)));
                }
                if (frameIndex == this.endFrameIndex) {
                    this.disposeImageConverter();
                    progressDialog.dispose();
                    EventQueue.invokeLater(this::displaySuccessMessage);
                }
            }
            catch (Throwable t) {
                this.disposeImageConverter();
                progressDialog.dispose();
                PlayMovieTask task = this.playMovieTask;
                if (task == null || task.isCanceled()) break block5;
                task.cancel();
                GuiUtil.displayError(ERROR_TITLE, this, "Failed to write frame image.");
            }
        }
    }

    private void writeAnimatedGifFrame(int frameIndex, MachineRunner machineRunner, ExportMediaFilePrefs prefs, ProgressDialog progressDialog) {
        try {
            BufferedImage img;
            progressDialog.setMessage("Frame: " + frameIndex);
            progressDialog.setValue(frameIndex);
            TVSystem tvSystem = machineRunner.getMapper().getTVSystem();
            if (this.imageConverter == null || tvSystem != this.lastTVSystem || this.imageOutputStream == null || this.gifSequenceWriter == null) {
                this.lastTVSystem = tvSystem;
                this.disposeImageConverter();
                this.imageConverter = new ImageConverter(prefs, tvSystem, true);
                this.imageConverter.setImage(this.image);
                this.disposeGifSequenceWriter();
                this.imageOutputStream = new FileImageOutputStream(new File(prefs.getFileName()));
                this.gifSequenceWriter = new GifSequenceWriter(this.imageOutputStream, this.image.getType(), tvSystem == TVSystem.PAL ? 40 : 30, true);
            }
            if ((frameIndex & 1) == 0 && (img = this.imageConverter.convert()) != null) {
                this.gifSequenceWriter.writeToSequence(img);
            }
        }
        catch (Throwable t) {
            this.closeAnimatedGif(progressDialog, t);
        }
    }

    private void disposeGifSequenceWriter() {
        try {
            this.gifSequenceWriter.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.imageOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void closeAnimatedGif(ProgressDialog progressDialog, Throwable t) {
        this.disposeGifSequenceWriter();
        progressDialog.dispose();
        PlayMovieTask task = this.playMovieTask;
        if (task != null && !task.isCanceled()) {
            task.cancel();
            if (t == null) {
                EventQueue.invokeLater(this::displaySuccessMessage);
            } else {
                GuiUtil.displayError(ERROR_TITLE, this, "Failed to write frame image.");
            }
        }
    }

    private void writeVideoFrame(int frameIndex, MachineRunner machineRunner, ExportMediaFilePrefs prefs, ProgressDialog progressDialog) {
        try {
            BufferedImage img;
            progressDialog.setMessage("Frame: " + frameIndex);
            progressDialog.setValue(frameIndex);
            TVSystem tvSystem = machineRunner.getMapper().getTVSystem();
            if (this.imageConverter == null || tvSystem != this.lastTVSystem || this.videoFile == null) {
                this.lastTVSystem = tvSystem;
                this.disposeImageConverter();
                this.imageConverter = new ImageConverter(prefs, tvSystem, true);
                this.imageConverter.setImage(this.image);
                this.disposeVideoFile();
                double framesPerSecond = tvSystem.getFramesPerSecond();
                this.videoFile = new VideoFile(prefs.getFileName(), prefs.getFileType() == 0, prefs.getFramesOption() != FramesOption.SaveAll ? framesPerSecond / 2.0 : framesPerSecond, this.imageConverter.getWidth(), this.imageConverter.getHeight(), prefs.isRecordAudio());
            }
            if ((img = this.imageConverter.convert()) != null) {
                this.videoFile.writeImage(img);
            }
        }
        catch (Throwable t) {
            this.closeVideoFile(progressDialog, t);
        }
    }

    private void disposeVideoFile() {
        try {
            this.videoFile.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void closeVideoFile(ProgressDialog progressDialog, Throwable t) {
        this.disposeVideoFile();
        progressDialog.dispose();
        PlayMovieTask task = this.playMovieTask;
        if (task != null && !task.isCanceled()) {
            task.cancel();
            if (t == null) {
                EventQueue.invokeLater(this::displaySuccessMessage);
            } else {
                GuiUtil.displayError(ERROR_TITLE, this, "Failed to write frame image.");
            }
        }
    }

    private void writeVideoAudioSample(int sample) {
        block3: {
            if (this.videoFile != null) {
                try {
                    this.videoFile.writeAudioSample(sample);
                }
                catch (Throwable t) {
                    this.disposeVideoFile();
                    PlayMovieTask task = this.playMovieTask;
                    if (task == null || task.isCanceled()) break block3;
                    task.cancel();
                    GuiUtil.displayError(ERROR_TITLE, this, "Failed to write audio sample.");
                }
            }
        }
    }

    private void displaySuccessMessage() {
        new InformationDialog((Window)this, "Export completed successfully.", "Media Export Finished", InformationDialog.IconType.INFORMATION).setVisible(true);
        this.closeDialog();
    }

    private void disposeImageConverter() {
        if (this.imageConverter != null) {
            this.imageConverter.dispose();
        }
    }

    private void initComponents() {
        this.mediaLabel = new JLabel();
        this.mediaComboBox = new JComboBox<MediaType>(MediaType.values());
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.browseButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.recordAudioCheckBox = new JCheckBox();
        this.filterLabel = new JLabel();
        this.videoFiltersComboBox = new JComboBox<VideoFilterDescriptor>(VideoFilterDescriptor.values());
        this.scaleLabel = new JLabel();
        this.scaleComboBox = new JComboBox();
        this.tvAspectCheckBox = new JCheckBox();
        this.cropBordersCheckBox = new JCheckBox();
        this.smoothScalingCheckBox = new JCheckBox();
        this.framesLabel = new JLabel();
        this.framesComboBox = new JComboBox<FramesOption>(FramesOption.values());
        this.paletteLabel = new JLabel();
        this.paletteComboBox = new JComboBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("Export Media");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExportMediaFileDialog.this.formWindowClosing(evt);
            }
        });
        this.mediaLabel.setText("Media:");
        this.mediaComboBox.setFocusable(false);
        this.mediaComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportMediaFileDialog.this.mediaComboBoxActionPerformed(evt);
            }
        });
        this.fileLabel.setText("File:");
        this.fileTextField.setColumns(60);
        this.fileTextField.setText(" ");
        this.browseButton.setText("Browse...");
        this.browseButton.setFocusPainted(false);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportMediaFileDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportMediaFileDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportMediaFileDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.typeLabel.setText("Type:");
        this.typeComboBox.setFocusable(false);
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportMediaFileDialog.this.typeComboBoxActionPerformed(evt);
            }
        });
        this.recordAudioCheckBox.setSelected(true);
        this.recordAudioCheckBox.setText("Record audio");
        this.recordAudioCheckBox.setFocusPainted(false);
        this.filterLabel.setText("Filter:");
        this.videoFiltersComboBox.setFocusable(false);
        this.videoFiltersComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportMediaFileDialog.this.videoFiltersComboBoxActionPerformed(evt);
            }
        });
        this.scaleLabel.setText("Scale:");
        this.scaleComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1x", "2x", "3x", "4x", "5x"}));
        this.scaleComboBox.setFocusable(false);
        this.tvAspectCheckBox.setText("TV aspect");
        this.cropBordersCheckBox.setSelected(true);
        this.cropBordersCheckBox.setText("Crop borders");
        this.cropBordersCheckBox.setFocusPainted(false);
        this.smoothScalingCheckBox.setText("Smooth scaling");
        this.framesLabel.setText("Frames:");
        this.framesComboBox.setFocusable(false);
        this.paletteLabel.setText("Palette:");
        this.paletteComboBox.setFocusable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileTextField, -1, 492, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.mediaLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mediaComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.framesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.framesComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.videoFiltersComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.paletteLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paletteComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.scaleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scaleComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.cropBordersCheckBox).addGap(18, 18, 18).addComponent(this.smoothScalingCheckBox).addGap(18, 18, 18).addComponent(this.tvAspectCheckBox).addGap(18, 18, 18).addComponent(this.recordAudioCheckBox))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mediaLabel).addComponent(this.mediaComboBox, -2, -1, -2).addComponent(this.typeLabel).addComponent(this.typeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.fileTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.framesLabel).addComponent(this.framesComboBox, -2, -1, -2).addComponent(this.filterLabel).addComponent(this.videoFiltersComboBox, -2, -1, -2).addComponent(this.scaleLabel).addComponent(this.scaleComboBox, -2, -1, -2).addComponent(this.paletteLabel).addComponent(this.paletteComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.recordAudioCheckBox).addComponent(this.cropBordersCheckBox).addComponent(this.smoothScalingCheckBox).addComponent(this.tvAspectCheckBox)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        ExportMediaFilePrefs prefs = this.saveFields();
        ProgressDialog progressDialog = new ProgressDialog((Window)this, this::cancelExport);
        if (FileUtil.isDirectory(prefs.getFileName())) {
            FileUtil.mkdir(prefs.getFileName());
        } else if (GuiUtil.confirmOverwrite(this, prefs.getFileName())) {
            String parent = new File(prefs.getFileName()).getParent();
            if (parent != null) {
                FileUtil.mkdir(parent);
            }
        } else {
            return;
        }
        this.disposeVideoFile();
        this.disposeGifSequenceWriter();
        this.disposeImageConverter();
        this.imageConverter = null;
        this.videoFile = null;
        this.imageOutputStream = null;
        this.gifSequenceWriter = null;
        this.lastTVSystem = null;
        FramePlayedListener taskListener = null;
        AudioProcessor audioProcessor = null;
        TaskTerminatedListener terminatedListener = null;
        progressDialog.setMinimum(this.startFrameIndex);
        progressDialog.setMaximum(this.endFrameIndex);
        progressDialog.setValue(this.startFrameIndex);
        switch (prefs.getMediaType()) {
            case Video: {
                progressDialog.setTitle("Exporting Video...");
                if (prefs.getFileType() == 2) {
                    try {
                        taskListener = (t, f, m) -> this.writeAnimatedGifFrame(f, m, prefs, progressDialog);
                        terminatedListener = t -> this.closeAnimatedGif(progressDialog, null);
                        break;
                    }
                    catch (Throwable t2) {
                        GuiUtil.displayError(ERROR_TITLE, this, "Failed to create animated GIF.");
                        return;
                    }
                }
                try {
                    taskListener = (t, f, m) -> this.writeVideoFrame(f, m, prefs, progressDialog);
                    terminatedListener = t -> this.closeVideoFile(progressDialog, null);
                    if (!prefs.isRecordAudio()) break;
                    audioProcessor = this::writeVideoAudioSample;
                    break;
                }
                catch (Throwable t3) {
                    GuiUtil.displayError(ERROR_TITLE, this, "Failed to create video file.");
                    return;
                }
            }
            case Audio: {
                progressDialog.setTitle("Exporting Audio...");
                try {
                    PipedInputStream pipedIn = new PipedInputStream();
                    PipedOutputStream pipedOut = new PipedOutputStream(pipedIn);
                    AudioInputStream in = new AudioInputStream(pipedIn, SystemAudioProcessor.AUDIO_FORMAT, -1L);
                    AudioFileFormat.Type fileType = SystemAudioProcessor.getSupportedAudioFileTypes()[prefs.getFileType()];
                    File file = new File(prefs.getFileName());
                    taskListener = (t, f, m) -> {
                        progressDialog.setMessage("Frame: " + f);
                        progressDialog.setValue(f);
                        if (f == this.endFrameIndex) {
                            progressDialog.dispose();
                            try {
                                in.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                pipedIn.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                pipedOut.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            EventQueue.invokeLater(this::displaySuccessMessage);
                        }
                    };
                    audioProcessor = s -> {
                        try {
                            pipedOut.write((byte)(s >> 8));
                            pipedOut.write((byte)s);
                        }
                        catch (Throwable t) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                pipedIn.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                pipedOut.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    };
                    new Thread(() -> {
                        try {
                            AudioSystem.write(in, fileType, file);
                        }
                        catch (Throwable t) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                pipedIn.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                pipedOut.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            progressDialog.dispose();
                            GuiUtil.displayError(ERROR_TITLE, this, "Failed to create audio file.");
                        }
                    }).start();
                    break;
                }
                catch (Throwable t4) {
                    GuiUtil.displayError(ERROR_TITLE, this, "Failed to create audio file.");
                    return;
                }
            }
            case Frames: {
                progressDialog.setTitle("Exporting Frames...");
                String extension = GuiUtil.getWritableImageFileFormats()[prefs.getFileType()];
                String format = FileUtil.appendSeparator(prefs.getFileName()) + this.fileBase + "-%0" + MathUtil.getDigits(this.endFrameIndex) + "d." + extension;
                taskListener = (t, f, m) -> this.writeImage(format, extension, f, m, prefs, progressDialog);
                break;
            }
        }
        this.playMovieTask = new PlayMovieTask(this.movie, this.startFrameIndex, this.endFrameIndex, false, taskListener, () -> this.screen, null, audioProcessor, terminatedListener);
        new Thread(() -> this.exportMedia(progressDialog)).start();
        progressDialog.setVisible(true);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void mediaComboBoxActionPerformed(ActionEvent evt) {
        this.updateTypeComboBox();
        this.updateFileName();
    }

    private void typeComboBoxActionPerformed(ActionEvent evt) {
        this.updateFileName();
        this.recordAudioCheckBox.setEnabled(this.mediaComboBox.getSelectedItem() == MediaType.Video && this.typeComboBox.getSelectedIndex() != 2);
        boolean enabled = this.mediaComboBox.getSelectedItem() != MediaType.Audio;
        this.cropBordersCheckBox.setEnabled(enabled);
        this.framesComboBox.setEnabled(enabled && this.typeComboBox.getSelectedIndex() != 2);
        this.framesLabel.setEnabled(this.framesComboBox.isEnabled());
        this.videoFiltersComboBox.setEnabled(enabled);
        this.filterLabel.setEnabled(this.videoFiltersComboBox.isEnabled());
        this.paletteComboBox.setEnabled(enabled);
        this.paletteLabel.setEnabled(this.paletteComboBox.isEnabled());
        this.scaleComboBox.setEnabled(enabled);
        this.scaleLabel.setEnabled(this.scaleComboBox.isEnabled());
        this.smoothScalingCheckBox.setEnabled(enabled);
        this.tvAspectCheckBox.setEnabled(enabled);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File file;
        String title;
        this.updateFileName();
        String path = this.fileTextField.getText().trim();
        String directory = null;
        String fileName = null;
        if (this.mediaComboBox.getSelectedItem() == MediaType.Frames) {
            directory = path;
            title = "Select Output Directory";
        } else {
            file = new File(path);
            directory = file.getParent();
            fileName = file.getName();
            title = "Save Media File";
        }
        file = GuiUtil.showSaveAsDialog(this, directory, fileName, this.getExtension(), this.getFilterExtensionFilter(), false, title);
        if (file != null) {
            this.fileTextField.setText(file.getPath());
        }
    }

    private void videoFiltersComboBoxActionPerformed(ActionEvent evt) {
        VideoFilterDescriptor filter = (VideoFilterDescriptor)((Object)this.videoFiltersComboBox.getSelectedItem());
        if (filter == VideoFilterDescriptor.Current) {
            this.scaleLabel.setEnabled(false);
            this.scaleComboBox.setEnabled(false);
            filter = App.getImageFrame().getImagePane().getVideoFilterDescriptor();
            if (filter == null) {
                filter = VideoFilterDescriptor.NoFilter;
            }
        } else {
            this.scaleLabel.setEnabled(true);
            this.scaleComboBox.setEnabled(true);
        }
        this.scaleComboBox.setSelectedIndex(filter == VideoFilterDescriptor.NoFilter ? 0 : filter.getScale() - 1);
        this.smoothScalingCheckBox.setSelected(filter.isSmoothScaling());
        this.tvAspectCheckBox.setSelected(filter.isUseTvAspectRatio());
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }
}

