/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.familybasic;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import nintaco.gui.familybasic.FamilyBasicPrefs;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;

public class FamilyBasicOptionsDialog
extends JDialog {
    private JButton cancelButton;
    private JLabel cpuCyclesPerSecondLabel;
    private JPanel dataRecorderPanel;
    private JSpinner longDelaySpinner;
    private JLabel longLabel;
    private JButton okButton;
    private JButton resetButton;
    private JLabel samplingPeriodLabel;
    private JSpinner samplingPeriodSpinner;
    private JSpinner shortDelaySpinner;
    private JLabel shortLabel;
    private JPanel typePastePanel;

    public FamilyBasicOptionsDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initSpinners();
        this.loadFields();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initSpinners() {
        this.shortDelaySpinner.setModel(new SpinnerNumberModel(1, 1, 999, 1));
        this.shortDelaySpinner.setEditor(new JSpinner.NumberEditor(this.shortDelaySpinner, "#"));
        this.longDelaySpinner.setModel(new SpinnerNumberModel(20, 20, 999, 1));
        this.longDelaySpinner.setEditor(new JSpinner.NumberEditor(this.longDelaySpinner, "#"));
        this.samplingPeriodSpinner.setModel(new SpinnerNumberModel(88, 1, 999, 1));
        this.samplingPeriodSpinner.setEditor(new JSpinner.NumberEditor(this.samplingPeriodSpinner, "#"));
        GuiUtil.addLoseFocusListener((Window)this, this.shortDelaySpinner);
        GuiUtil.addLoseFocusListener((Window)this, this.longDelaySpinner);
        GuiUtil.addLoseFocusListener((Window)this, this.samplingPeriodSpinner);
    }

    private void loadFields() {
        this.loadFields(AppPrefs.getInstance().getFamilyBasicPrefs());
    }

    private void loadFields(FamilyBasicPrefs prefs) {
        this.shortDelaySpinner.setValue(prefs.getTypePasteShortDelay());
        this.longDelaySpinner.setValue(prefs.getTypePasteLongDelay());
        this.samplingPeriodSpinner.setValue(prefs.getDataRecorderSamplingPeriod());
    }

    private void saveFields() {
        FamilyBasicPrefs prefs = AppPrefs.getInstance().getFamilyBasicPrefs();
        prefs.setTypePasteShortDelay((Integer)this.shortDelaySpinner.getValue());
        prefs.setTypePasteLongDelay((Integer)this.longDelaySpinner.getValue());
        prefs.setDataRecorderSamplingPeriod((Integer)this.samplingPeriodSpinner.getValue());
        AppPrefs.save();
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.typePastePanel = new JPanel();
        this.longDelaySpinner = new JSpinner();
        this.shortDelaySpinner = new JSpinner();
        this.shortLabel = new JLabel();
        this.longLabel = new JLabel();
        this.dataRecorderPanel = new JPanel();
        this.samplingPeriodLabel = new JLabel();
        this.samplingPeriodSpinner = new JSpinner();
        this.cpuCyclesPerSecondLabel = new JLabel();
        this.resetButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Family BASIC Options");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FamilyBasicOptionsDialog.this.formWindowClosing(evt);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamilyBasicOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamilyBasicOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.typePastePanel.setBorder(BorderFactory.createTitledBorder("Type Paste"));
        this.typePastePanel.setMaximumSize(null);
        this.longDelaySpinner.setMaximumSize(null);
        this.longDelaySpinner.setMinimumSize(null);
        this.longDelaySpinner.setPreferredSize(null);
        this.shortDelaySpinner.setMaximumSize(null);
        this.shortDelaySpinner.setMinimumSize(null);
        this.shortDelaySpinner.setPreferredSize(null);
        this.shortLabel.setText("Key press delay:");
        this.longLabel.setText("End of line delay:");
        GroupLayout typePastePanelLayout = new GroupLayout(this.typePastePanel);
        this.typePastePanel.setLayout(typePastePanelLayout);
        typePastePanelLayout.setHorizontalGroup(typePastePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(typePastePanelLayout.createSequentialGroup().addContainerGap().addGroup(typePastePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.shortLabel).addComponent(this.longLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(typePastePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.shortDelaySpinner, -2, -1, -2).addComponent(this.longDelaySpinner, -2, -1, -2)).addContainerGap()));
        typePastePanelLayout.setVerticalGroup(typePastePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(typePastePanelLayout.createSequentialGroup().addContainerGap().addGroup(typePastePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.shortLabel).addComponent(this.shortDelaySpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(typePastePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.longLabel).addComponent(this.longDelaySpinner, -2, -1, -2)).addContainerGap()));
        this.dataRecorderPanel.setBorder(BorderFactory.createTitledBorder("Data Recorder"));
        this.dataRecorderPanel.setMaximumSize(null);
        this.samplingPeriodLabel.setText("Sampling period:");
        this.cpuCyclesPerSecondLabel.setText("CPU cycles/sample");
        this.cpuCyclesPerSecondLabel.setMaximumSize(null);
        this.cpuCyclesPerSecondLabel.setMinimumSize(null);
        this.cpuCyclesPerSecondLabel.setPreferredSize(null);
        GroupLayout dataRecorderPanelLayout = new GroupLayout(this.dataRecorderPanel);
        this.dataRecorderPanel.setLayout(dataRecorderPanelLayout);
        dataRecorderPanelLayout.setHorizontalGroup(dataRecorderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataRecorderPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.samplingPeriodLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.samplingPeriodSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cpuCyclesPerSecondLabel, -2, -1, -2).addContainerGap()));
        dataRecorderPanelLayout.setVerticalGroup(dataRecorderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataRecorderPanelLayout.createSequentialGroup().addContainerGap().addGroup(dataRecorderPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.samplingPeriodLabel).addComponent(this.samplingPeriodSpinner, -2, -1, -2).addComponent(this.cpuCyclesPerSecondLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.resetButton.setMnemonic('R');
        this.resetButton.setText("Reset");
        this.resetButton.setFocusPainted(false);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamilyBasicOptionsDialog.this.resetButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.typePastePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataRecorderPanel, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.resetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton, this.resetButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.typePastePanel, -1, -1, Short.MAX_VALUE).addComponent(this.dataRecorderPanel, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.resetButton)).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.saveFields();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.loadFields(new FamilyBasicPrefs());
    }
}

