/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.hexeditor;

import java.util.ArrayList;
import java.util.List;
import nintaco.gui.hexeditor.Edit;

public abstract class DataSource {
    public static final int CpuMemory = 0;
    public static final int PpuMemory = 1;
    public static final int FileContents = 2;
    private final List<Edit> edits = new ArrayList<Edit>();
    final int[] cache;
    private int editIndex;
    private int startSelectedAddress;
    private int endSelectedAddress;
    private int scrollY;

    public DataSource(int size) {
        this(new int[size]);
    }

    public DataSource(int[] cache) {
        this.cache = cache;
    }

    public abstract int peek(int var1);

    public abstract void write(int var1, int var2);

    public abstract int getIndex();

    public void writeCache(int address, int value) {
        if (address >= 0 && address < this.cache.length) {
            this.cache[address] = value;
        }
    }

    public int readColored(int address) {
        return this.readCache(address) & 0xFF00 | this.peek(address) & 0xFF;
    }

    public int readCache(int address) {
        return address < 0 || address >= this.cache.length ? 0 : this.cache[address];
    }

    public void refreshCache() {
        for (int i = this.cache.length - 1; i >= 0; --i) {
            int peekValue = this.peek(i);
            int cacheValue = this.cache[i] & 0xFF;
            int cacheColor = this.cache[i] >> 8 & 0xFF;
            if (peekValue != cacheValue) {
                cacheColor = 0;
            }
            this.cache[i] = cacheColor << 8 | peekValue;
        }
    }

    public int[] getCache() {
        return this.cache;
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public int getSize() {
        return this.cache.length;
    }

    public void clearEdits() {
        this.edits.clear();
    }

    public void addEdit(Edit edit) {
        ++this.editIndex;
        while (this.editIndex <= this.edits.size()) {
            this.edits.remove(this.edits.size() - 1);
        }
        this.edits.add(edit);
    }

    public int getSelectedAddress() {
        int min;
        int start = this.startSelectedAddress;
        int end = this.endSelectedAddress;
        if (start < 0 || end < 0) {
            return 0;
        }
        int n = min = start < end ? start : end;
        if (min >= this.cache.length) {
            return this.cache.length - 1;
        }
        return min;
    }

    public int getStartSelectedAddress() {
        return this.startSelectedAddress;
    }

    public void setSelection(int address) {
        this.setSelection(address, address);
    }

    public void setSelection(int startAddress, int endAddress) {
        this.setStartSelectedAddress(startAddress);
        this.setEndSelectedAddress(endAddress);
    }

    public void setStartSelectedAddress(int startSelectedAddress) {
        if (startSelectedAddress < 0) {
            startSelectedAddress = 0;
        }
        this.startSelectedAddress = startSelectedAddress;
    }

    public int getEndSelectedAddress() {
        return this.endSelectedAddress;
    }

    public void setEndSelectedAddress(int endSelectedAddress) {
        if (endSelectedAddress < 0) {
            endSelectedAddress = 0;
        }
        this.endSelectedAddress = endSelectedAddress;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    public void setScrollY(int scrollY) {
        this.scrollY = scrollY;
    }

    public List<Edit> getEdits() {
        return this.edits;
    }

    public int getEditIndex() {
        return this.editIndex;
    }

    public void setEditIndex(int editIndex) {
        this.editIndex = editIndex;
    }
}

