/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.hexeditor;

import nintaco.gui.hexeditor.CharTable;
import nintaco.gui.hexeditor.DataSource;

public class DataSourceCharSequence
implements CharSequence {
    private final CharTable charTable;
    private final DataSource source;
    private final int startIndex;
    private final int length;

    public DataSourceCharSequence(DataSource source, CharTable charTable) {
        this(source, charTable, 0, source.getSize());
    }

    public DataSourceCharSequence(DataSource source, CharTable charTable, int startIndex, int endIndex) {
        this.source = source;
        this.charTable = charTable;
        this.startIndex = startIndex;
        this.length = endIndex - startIndex;
    }

    public DataSource getSource() {
        return this.source;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.charTable.getChar(this.source.peek(this.startIndex + index));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new DataSourceCharSequence(this.source, this.charTable, start, end);
    }
}

