/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.hexeditor;

import nintaco.files.FdsFile;
import nintaco.files.NesFile;
import nintaco.files.UnifFile;
import nintaco.gui.hexeditor.DataSource;
import nintaco.mappers.Mapper;

public class FileDataSource
extends DataSource {
    private final int prgRomAddress;
    private final int chrRomAddress;
    private final Mapper mapper;

    public FileDataSource(NesFile nesFile, Mapper mapper) {
        super(nesFile.getFileContents());
        this.mapper = mapper;
        this.prgRomAddress = nesFile.getHeaderSize() + nesFile.getTrainerSize();
        this.chrRomAddress = this.prgRomAddress + nesFile.getPrgRomSize();
    }

    public FileDataSource(FdsFile fdsFile) {
        super(fdsFile.getFileContents());
        this.mapper = null;
        this.prgRomAddress = -1;
        this.chrRomAddress = -1;
    }

    public FileDataSource(UnifFile unifFile) {
        super(unifFile.getFileContents());
        this.mapper = null;
        this.prgRomAddress = -1;
        this.chrRomAddress = -1;
    }

    @Override
    public int peek(int address) {
        return address >= 0 && address < this.cache.length ? this.cache[address] : 0;
    }

    @Override
    public void write(int address, int value) {
        if (address >= 0 && address < this.cache.length) {
            this.cache[address] = value;
            if (this.mapper != null) {
                if (address >= this.chrRomAddress) {
                    this.mapper.writeChrRom(address - this.chrRomAddress, value);
                } else if (address >= this.prgRomAddress) {
                    this.mapper.writePrgRom(address - this.prgRomAddress, value);
                }
            }
        }
    }

    @Override
    public void refreshCache() {
    }

    @Override
    public int getSize() {
        return this.cache.length;
    }

    @Override
    public int getIndex() {
        return 2;
    }
}

