/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.hexeditor;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import nintaco.App;
import nintaco.Machine;
import nintaco.MessageException;
import nintaco.files.CartFile;
import nintaco.files.FdsFile;
import nintaco.files.FileUtil;
import nintaco.gui.EditableComboBoxDialog;
import nintaco.gui.FileExtensionFilter;
import nintaco.gui.InformationDialog;
import nintaco.gui.MenuAdapter;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.StyleListener;
import nintaco.gui.hexeditor.CharTable;
import nintaco.gui.hexeditor.HexEditorColumnHeader;
import nintaco.gui.hexeditor.HexEditorView;
import nintaco.gui.hexeditor.preferences.Bookmark;
import nintaco.gui.hexeditor.preferences.HexEditorAppPrefs;
import nintaco.gui.hexeditor.preferences.HexEditorGamePrefs;
import nintaco.gui.image.ImageFrame;
import nintaco.gui.image.preferences.Paths;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.util.GuiUtil;

public class HexEditorFrame
extends JFrame
implements StyleListener {
    private final HexEditorView hexEditorView = new HexEditorView();
    private final HexEditorColumnHeader hexEditorColumnHeader = new HexEditorColumnHeader();
    private int fileIndex;
    private FileExtensionFilter fileFilter;
    private String entryFileName;
    private String fileExtension;
    private File lastSavedFile;
    private JMenuItem addAddressLabelMenuItem;
    private JMenuItem addBreakpointMenuItem;
    private JMenuItem addCheatMenuItem;
    private JMenu bookmarksMenu;
    private JPopupMenu.Separator bookmarksSeparator;
    private JMenuItem closeMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem copySpacedMenuItem;
    private JRadioButtonMenuItem cpuMemoryMenuItem;
    private JMenu debugMenu;
    private JMenuItem editAddressLabelMenuItem;
    private JMenuItem editBreakpointMenuItem;
    private JMenuItem editCheatsMenuItem;
    private JMenu editMenu;
    private JRadioButtonMenuItem fileContentsMenuItem;
    private JMenu fileMenu;
    private JMenuItem findMenuItem;
    private JMenuItem goToAddressMenuItem;
    private JMenuItem goToFileIndexMenuItem;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JMenuItem loadCharTableMenuItem;
    private JMenuBar menuBar;
    private JMenu navigateMenu;
    private JMenuItem pasteMenuItem;
    private JRadioButtonMenuItem ppuMemoryMenuItem;
    private JMenuItem redoMenuItem;
    private JMenuItem removeAllBookmarksMenuItem;
    private JMenuItem replaceMenuItem;
    private JMenuItem saveCPUMenuItem;
    private JMenuItem saveFileAsMenuItem;
    private JMenuItem saveFileMenuItem;
    private JMenuItem savePPUMenuItem;
    private JScrollPane scrollPane;
    private JMenuItem selectAllMenuItem;
    private JMenuItem toggleBookmarkMenuItem;
    private JMenuItem undoMenuItem;
    private JMenuItem unloadCharTableMenuItem;
    private ButtonGroup viewButtonGroup;

    public HexEditorFrame() {
        this.initComponents();
        GuiUtil.scaleFonts(this);
        this.hexEditorView.setHexEditorFrame(this);
        this.scrollPane.setViewportView(this.hexEditorView);
        this.scrollPane.setColumnHeaderView(this.hexEditorColumnHeader);
        this.navigateMenu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuSelected(MenuEvent e) {
                HexEditorFrame.this.updateNavigationMenu();
            }
        });
        this.initScrollPane();
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    private void initScrollPane() {
        FontMetrics metrics = this.hexEditorView.getFontMetrics(this.hexEditorView.getFont());
        this.scrollPane.setPreferredSize(new Dimension(2 + 76 * metrics.getWidths()[77] + (this.scrollPane.getVerticalScrollBar().getPreferredSize().width << 1), 2 + 40 * metrics.getHeight()));
    }

    @Override
    public void styleChanged() {
        this.hexEditorView.styleChanged();
        this.hexEditorColumnHeader.styleChanged();
        this.initScrollPane();
    }

    private void updateNavigationMenu() {
        this.setDataSource(this.hexEditorView.getDataSource().getIndex());
    }

    private void machineUpdated(boolean enabled) {
        this.saveFileMenuItem.setEnabled(enabled);
        this.saveFileAsMenuItem.setEnabled(enabled);
        this.saveCPUMenuItem.setEnabled(enabled);
        this.savePPUMenuItem.setEnabled(enabled);
        this.undoMenuItem.setEnabled(enabled);
        this.redoMenuItem.setEnabled(enabled);
        this.copyMenuItem.setEnabled(enabled);
        this.copySpacedMenuItem.setEnabled(enabled);
        this.pasteMenuItem.setEnabled(enabled);
        this.selectAllMenuItem.setEnabled(enabled);
        this.findMenuItem.setEnabled(enabled);
        this.replaceMenuItem.setEnabled(enabled);
        this.goToAddressMenuItem.setEnabled(enabled);
        this.toggleBookmarkMenuItem.setEnabled(enabled);
        this.removeAllBookmarksMenuItem.setEnabled(enabled);
        this.fileFilter = null;
        this.entryFileName = null;
        this.fileExtension = null;
        if (enabled) {
            CartFile cartFile = App.getCartFile();
            FdsFile fdsFile = App.getFdsFile();
            this.lastSavedFile = null;
            if (cartFile != null) {
                if (cartFile.getArchiveFileName() == null) {
                    this.lastSavedFile = new File(cartFile.getEntryFileName());
                }
                this.fileFilter = ImageFrame.FileExtensionFilters[1];
                this.entryFileName = FileUtil.getFileName(cartFile.getEntryFileName());
                this.fileExtension = "nintaco";
            } else if (fdsFile != null) {
                if (fdsFile.getArchiveFileName() == null) {
                    this.lastSavedFile = new File(fdsFile.getEntryFileName());
                }
                this.fileFilter = ImageFrame.FileExtensionFilters[2];
                this.entryFileName = FileUtil.getFileName(fdsFile.getEntryFileName());
                this.fileExtension = "fds";
            }
            this.saveFileAsMenuItem.setEnabled(this.lastSavedFile != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBookmarksMenu() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            List<Bookmark> bookmarks = GamePrefs.getInstance().getHexEditorGamePrefs().getBookmarks();
            this.bookmarksMenu.removeAll();
            this.bookmarksMenu.add(this.toggleBookmarkMenuItem);
            this.bookmarksMenu.add(this.removeAllBookmarksMenuItem);
            this.removeAllBookmarksMenuItem.setEnabled(!bookmarks.isEmpty());
            if (!bookmarks.isEmpty()) {
                this.bookmarksMenu.add(this.bookmarksSeparator);
            }
            for (int i = 0; i < bookmarks.size(); ++i) {
                Bookmark bookmark = bookmarks.get(i);
                JMenuItem menuItem = new JMenuItem(bookmark.getName());
                if (i < 10) {
                    menuItem.setAccelerator(KeyStroke.getKeyStroke(48 + i, 2));
                }
                menuItem.addActionListener(e -> this.hexEditorView.goToBookmark(bookmark));
                this.bookmarksMenu.add(menuItem);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void update() {
        this.hexEditorView.update();
    }

    public void destroy() {
        this.dispose();
    }

    private void closeFrame() {
        App.destroyHexEditorFrame();
    }

    public void setMachine(Machine machine) {
        this.hexEditorView.setMachine(machine);
        EventQueue.invokeLater(() -> {
            this.machineUpdated(machine != null);
            this.updateBookmarksMenu();
            this.hexEditorView.colorBookmarks();
        });
    }

    public void setDataSource(int index) {
        switch (index) {
            case 0: {
                this.cpuMemoryMenuItem.setSelected(true);
                break;
            }
            case 1: {
                this.ppuMemoryMenuItem.setSelected(true);
                break;
            }
            case 2: {
                this.fileContentsMenuItem.setSelected(true);
            }
        }
        this.hexEditorColumnHeader.setDataSource(index);
        this.hexEditorView.setDataSource(index);
        this.fileIndex = this.hexEditorView.getFileIndex();
        this.goToFileIndexMenuItem.setEnabled(this.fileIndex >= 0);
    }

    public void goToAddress(int dataSourceIndex, int address) {
        this.hexEditorView.goToAddress(dataSourceIndex, address);
        this.setDataSource(dataSourceIndex);
    }

    private void loadCharTable(PleaseWaitDialog pleaseWaitDialog, File file) {
        String errorMessage = null;
        try {
            this.hexEditorView.setCharTable(new CharTable(file));
        }
        catch (MessageException e) {
            errorMessage = e.getMessage();
        }
        catch (Throwable t) {
            errorMessage = "Error loading character table.";
        }
        pleaseWaitDialog.dispose();
        if (errorMessage != null) {
            GuiUtil.displayError(this, errorMessage);
        }
        App.setNoStepPause(false);
    }

    private void saveMemory(int dataSourceIndex) {
        File defaultFile;
        File file;
        String name;
        App.setNoStepPause(true);
        HexEditorGamePrefs prefs = GamePrefs.getInstance().getHexEditorGamePrefs();
        String string = name = dataSourceIndex == 0 ? prefs.getCpuMemoryFile() : prefs.getPpuMemoryFile();
        if (name == null) {
            name = FileUtil.appendSeparator(AppPrefs.getInstance().getPaths().getSaveEditedNesFileDir()) + FileUtil.getFileNameWithoutExtension(this.entryFileName) + (dataSourceIndex == 0 ? "-cpu.bin" : "-ppu.bin");
        }
        if ((file = GuiUtil.showSaveAsDialog(this, (defaultFile = new File(name)).getParent(), defaultFile.getName(), "bin", new FileNameExtensionFilter("Binary files (*.bin)", "bin"), true)) != null) {
            if (dataSourceIndex == 0) {
                prefs.setCpuMemoryFile(file.getPath());
            } else {
                prefs.setPpuMemoryFile(file.getPath());
            }
            GamePrefs.save();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            new Thread(() -> this.hexEditorView.saveFile(pleaseWaitDialog, file, dataSourceIndex)).start();
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    private void goToFileContents() {
        this.goToAddress(2, this.fileIndex);
    }

    public void goToFileContents(int address) {
        this.goToAddress(0, address);
        EventQueue.invokeLater(() -> {
            this.hexEditorView.goToAddress(2, this.fileIndex);
            this.setDataSource(2);
        });
    }

    public HexEditorView getHexEditorView() {
        return this.hexEditorView;
    }

    private void initComponents() {
        this.viewButtonGroup = new ButtonGroup();
        this.scrollPane = new JScrollPane();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.saveFileMenuItem = new JMenuItem();
        this.saveFileAsMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.saveCPUMenuItem = new JMenuItem();
        this.savePPUMenuItem = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.loadCharTableMenuItem = new JMenuItem();
        this.unloadCharTableMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.closeMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.undoMenuItem = new JMenuItem();
        this.redoMenuItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.copyMenuItem = new JMenuItem();
        this.copySpacedMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.selectAllMenuItem = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.findMenuItem = new JMenuItem();
        this.replaceMenuItem = new JMenuItem();
        this.navigateMenu = new JMenu();
        this.cpuMemoryMenuItem = new JRadioButtonMenuItem();
        this.ppuMemoryMenuItem = new JRadioButtonMenuItem();
        this.fileContentsMenuItem = new JRadioButtonMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.goToAddressMenuItem = new JMenuItem();
        this.goToFileIndexMenuItem = new JMenuItem();
        this.bookmarksMenu = new JMenu();
        this.toggleBookmarkMenuItem = new JMenuItem();
        this.removeAllBookmarksMenuItem = new JMenuItem();
        this.bookmarksSeparator = new JPopupMenu.Separator();
        this.debugMenu = new JMenu();
        this.addBreakpointMenuItem = new JMenuItem();
        this.editBreakpointMenuItem = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.addAddressLabelMenuItem = new JMenuItem();
        this.editAddressLabelMenuItem = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.addCheatMenuItem = new JMenuItem();
        this.editCheatsMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("Hex Editor");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                HexEditorFrame.this.formWindowClosing(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                HexEditorFrame.this.formKeyPressed(evt);
            }
        });
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.saveFileMenuItem.setMnemonic('S');
        this.saveFileMenuItem.setText("Save File");
        this.saveFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.saveFileMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveFileMenuItem);
        this.saveFileAsMenuItem.setMnemonic('A');
        this.saveFileAsMenuItem.setText("Save File As...");
        this.saveFileAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.saveFileAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveFileAsMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.saveCPUMenuItem.setMnemonic('M');
        this.saveCPUMenuItem.setText("Save CPU Memory...");
        this.saveCPUMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.saveCPUMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveCPUMenuItem);
        this.savePPUMenuItem.setMnemonic('P');
        this.savePPUMenuItem.setText("Save PPU Memory...");
        this.savePPUMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.savePPUMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.savePPUMenuItem);
        this.fileMenu.add(this.jSeparator3);
        this.loadCharTableMenuItem.setMnemonic('L');
        this.loadCharTableMenuItem.setText("Load Character Table...");
        this.loadCharTableMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.loadCharTableMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadCharTableMenuItem);
        this.unloadCharTableMenuItem.setMnemonic('U');
        this.unloadCharTableMenuItem.setText("Reset Character Table");
        this.unloadCharTableMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.unloadCharTableMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.unloadCharTableMenuItem);
        this.fileMenu.add(this.jSeparator2);
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.closeMenuItem.setMnemonic('C');
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.setToolTipText("");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.closeMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.closeMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setMnemonic('E');
        this.editMenu.setText("Edit");
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoMenuItem.setMnemonic('U');
        this.undoMenuItem.setText("Undo");
        this.undoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.undoMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.undoMenuItem);
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redoMenuItem.setMnemonic('R');
        this.redoMenuItem.setText("Redo");
        this.redoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.redoMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.redoMenuItem);
        this.editMenu.add(this.jSeparator4);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyMenuItem.setMnemonic('C');
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyMenuItem);
        this.copySpacedMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 3));
        this.copySpacedMenuItem.setMnemonic('S');
        this.copySpacedMenuItem.setText("Copy Spaced");
        this.copySpacedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.copySpacedMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copySpacedMenuItem);
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteMenuItem.setMnemonic('P');
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.pasteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.pasteMenuItem);
        this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.selectAllMenuItem.setMnemonic('A');
        this.selectAllMenuItem.setText("Select All");
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.selectAllMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.selectAllMenuItem);
        this.editMenu.add(this.jSeparator5);
        this.findMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.findMenuItem.setMnemonic('F');
        this.findMenuItem.setText("Find...");
        this.findMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.findMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.findMenuItem);
        this.replaceMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.replaceMenuItem.setMnemonic('e');
        this.replaceMenuItem.setText("Replace...");
        this.replaceMenuItem.setToolTipText("");
        this.replaceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.replaceMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.replaceMenuItem);
        this.menuBar.add(this.editMenu);
        this.navigateMenu.setMnemonic('N');
        this.navigateMenu.setText("Navigate");
        this.cpuMemoryMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        this.viewButtonGroup.add(this.cpuMemoryMenuItem);
        this.cpuMemoryMenuItem.setMnemonic('C');
        this.cpuMemoryMenuItem.setSelected(true);
        this.cpuMemoryMenuItem.setText("CPU Memory");
        this.cpuMemoryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.cpuMemoryMenuItemActionPerformed(evt);
            }
        });
        this.navigateMenu.add(this.cpuMemoryMenuItem);
        this.ppuMemoryMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        this.viewButtonGroup.add(this.ppuMemoryMenuItem);
        this.ppuMemoryMenuItem.setMnemonic('P');
        this.ppuMemoryMenuItem.setText("PPU Memory");
        this.ppuMemoryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.ppuMemoryMenuItemActionPerformed(evt);
            }
        });
        this.navigateMenu.add(this.ppuMemoryMenuItem);
        this.fileContentsMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.viewButtonGroup.add(this.fileContentsMenuItem);
        this.fileContentsMenuItem.setMnemonic('F');
        this.fileContentsMenuItem.setText("File Contents");
        this.fileContentsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.fileContentsMenuItemActionPerformed(evt);
            }
        });
        this.navigateMenu.add(this.fileContentsMenuItem);
        this.navigateMenu.add(this.jSeparator6);
        this.goToAddressMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.goToAddressMenuItem.setMnemonic('G');
        this.goToAddressMenuItem.setText("Go to Address...");
        this.goToAddressMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.goToAddressMenuItemActionPerformed(evt);
            }
        });
        this.navigateMenu.add(this.goToAddressMenuItem);
        this.goToFileIndexMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.goToFileIndexMenuItem.setMnemonic('I');
        this.goToFileIndexMenuItem.setText("Go to File Index");
        this.goToFileIndexMenuItem.setEnabled(false);
        this.goToFileIndexMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.goToFileIndexMenuItemActionPerformed(evt);
            }
        });
        this.navigateMenu.add(this.goToFileIndexMenuItem);
        this.menuBar.add(this.navigateMenu);
        this.bookmarksMenu.setMnemonic('B');
        this.bookmarksMenu.setText("Bookmarks");
        this.toggleBookmarkMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.toggleBookmarkMenuItem.setMnemonic('T');
        this.toggleBookmarkMenuItem.setText("Toggle Bookmark");
        this.toggleBookmarkMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.toggleBookmarkMenuItemActionPerformed(evt);
            }
        });
        this.bookmarksMenu.add(this.toggleBookmarkMenuItem);
        this.removeAllBookmarksMenuItem.setText("Remove All Bookmarks");
        this.removeAllBookmarksMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.removeAllBookmarksMenuItemActionPerformed(evt);
            }
        });
        this.bookmarksMenu.add(this.removeAllBookmarksMenuItem);
        this.bookmarksMenu.add(this.bookmarksSeparator);
        this.menuBar.add(this.bookmarksMenu);
        this.debugMenu.setMnemonic('D');
        this.debugMenu.setText("Debug");
        this.debugMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                HexEditorFrame.this.debugMenuMenuSelected(evt);
            }
        });
        this.addBreakpointMenuItem.setText("Add Breakpoint...");
        this.addBreakpointMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.addBreakpointMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.addBreakpointMenuItem);
        this.editBreakpointMenuItem.setText("Edit Breakpoints...");
        this.editBreakpointMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.editBreakpointMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.editBreakpointMenuItem);
        this.debugMenu.add(this.jSeparator7);
        this.addAddressLabelMenuItem.setText("Add Address Label...");
        this.addAddressLabelMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.addAddressLabelMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.addAddressLabelMenuItem);
        this.editAddressLabelMenuItem.setText("Edit Address Labels...");
        this.editAddressLabelMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.editAddressLabelMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.editAddressLabelMenuItem);
        this.debugMenu.add(this.jSeparator8);
        this.addCheatMenuItem.setText("Add Cheat...");
        this.addCheatMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.addCheatMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.addCheatMenuItem);
        this.editCheatsMenuItem.setText("Edit Cheats...");
        this.editCheatsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexEditorFrame.this.editCheatsMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.editCheatsMenuItem);
        this.menuBar.add(this.debugMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane));
    }

    private void formKeyPressed(KeyEvent evt) {
        this.hexEditorView.keyPressed(evt);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void closeMenuItemActionPerformed(ActionEvent evt) {
        this.closeFrame();
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.copy(false);
    }

    private void pasteMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.paste();
    }

    private void cpuMemoryMenuItemActionPerformed(ActionEvent evt) {
        this.setDataSource(0);
    }

    private void ppuMemoryMenuItemActionPerformed(ActionEvent evt) {
        this.setDataSource(1);
    }

    private void fileContentsMenuItemActionPerformed(ActionEvent evt) {
        this.setDataSource(2);
    }

    private void loadCharTableMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        JFileChooser chooser = GuiUtil.createFileChooser("Load Character Table", AppPrefs.getInstance().getPaths().getLoadCharacterTableDir(), new FileNameExtensionFilter("Character Table (*.tbl)", "tbl"));
        if (GuiUtil.showOpenDialog(this, chooser, (p, d) -> p.setLoadCharacterTableDir((String)d)) == 0) {
            File selectedFile = chooser.getSelectedFile();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            new Thread(() -> this.loadCharTable(pleaseWaitDialog, selectedFile)).start();
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    private void unloadCharTableMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.setCharTable(new CharTable());
    }

    private void undoMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.undo();
    }

    private void redoMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.redo();
    }

    private void selectAllMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.selectAll();
    }

    private void findMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.showSearchDialog(false);
    }

    private void replaceMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.showSearchDialog(true);
    }

    private void copySpacedMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.copy(true);
    }

    private void goToAddressMenuItemActionPerformed(ActionEvent evt) {
        block5: {
            int value;
            HexEditorAppPrefs prefs = AppPrefs.getInstance().getHexEditorPrefs();
            List<Integer> addresses = prefs.getRecentAddresses();
            ArrayList<String> items = new ArrayList<String>();
            String format = "%04X";
            for (int address : addresses) {
                if (address <= 65535) continue;
                format = "%06X";
                break;
            }
            for (int address : addresses) {
                items.add(String.format(format, address));
            }
            while (true) {
                String input;
                EditableComboBoxDialog dialog = new EditableComboBoxDialog((Window)this, "Address", "Go to Address", items);
                dialog.setOkButtonText("Go");
                dialog.setVisible(true);
                if (!dialog.isOk() || (input = dialog.getInput().trim()).isEmpty()) break block5;
                try {
                    value = Integer.parseInt(input, 16);
                }
                catch (Throwable t) {
                    InformationDialog errorDialog = new InformationDialog((Window)this, "Invalid hexidecimal address.", "Bad Address", InformationDialog.IconType.ERROR);
                    errorDialog.setVisible(true);
                    continue;
                }
                if (value >= 0 && value <= 0xFFFFFF) break;
                InformationDialog errorDialog = new InformationDialog((Window)this, "Address out of range.<br/>Expected: 000000&mdash;FFFFFF", "Bad Address", InformationDialog.IconType.ERROR);
                errorDialog.setVisible(true);
            }
            prefs.addRecentAddress(value);
            this.hexEditorView.goToAddress(value);
        }
    }

    private void toggleBookmarkMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.toggleBookmark();
    }

    private void removeAllBookmarksMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.removeAllBookmarks();
    }

    private void goToFileIndexMenuItemActionPerformed(ActionEvent evt) {
        this.goToFileContents();
    }

    private void saveFileAsMenuItemActionPerformed(ActionEvent evt) {
        if (this.entryFileName == null) {
            return;
        }
        App.setNoStepPause(true);
        Paths paths = AppPrefs.getInstance().getPaths();
        File file = GuiUtil.showSaveAsDialog(this, paths.getSaveEditedNesFileDir(), this.entryFileName, this.fileExtension, this.fileFilter, true);
        if (file != null) {
            paths.setSaveEditedNesFileDir(file.getParentFile().getPath());
            AppPrefs.save();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            this.entryFileName = file.getName();
            this.lastSavedFile = file;
            this.saveFileMenuItem.setEnabled(true);
            new Thread(() -> this.hexEditorView.saveFile(pleaseWaitDialog, file, 2)).start();
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    private void saveFileMenuItemActionPerformed(ActionEvent evt) {
        if (this.lastSavedFile == null) {
            this.saveFileAsMenuItemActionPerformed(evt);
            return;
        }
        if (this.entryFileName == null) {
            return;
        }
        App.setNoStepPause(true);
        PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
        new Thread(() -> this.hexEditorView.saveFile(pleaseWaitDialog, this.lastSavedFile, 2)).start();
        pleaseWaitDialog.showAfterDelay();
    }

    private void saveCPUMenuItemActionPerformed(ActionEvent evt) {
        this.saveMemory(0);
    }

    private void savePPUMenuItemActionPerformed(ActionEvent evt) {
        this.saveMemory(1);
    }

    private void addBreakpointMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.addBreakpoint();
    }

    private void editBreakpointMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.showBreakpointDialog();
    }

    private void addAddressLabelMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.addAddressLabel();
    }

    private void editAddressLabelMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.showAddressLabelsDialog();
    }

    private void addCheatMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.addCheat();
    }

    private void editCheatsMenuItemActionPerformed(ActionEvent evt) {
        this.hexEditorView.showCheatsDialog();
    }

    private void debugMenuMenuSelected(MenuEvent evt) {
        boolean enabled = this.hexEditorView.getMachine() != null && this.hexEditorView.getDataSource().getIndex() == 0;
        this.addBreakpointMenuItem.setEnabled(enabled);
        this.editBreakpointMenuItem.setEnabled(enabled);
        this.addAddressLabelMenuItem.setEnabled(enabled);
        this.editAddressLabelMenuItem.setEnabled(enabled);
        this.addCheatMenuItem.setEnabled(enabled);
        this.editCheatsMenuItem.setEnabled(enabled);
    }
}

