/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.hexeditor;

import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import nintaco.gui.hexeditor.CharTable;

public class SearchText
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final String value;
    private final boolean hex;

    public SearchText(String value, boolean hex) {
        this.value = value;
        this.hex = hex;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isHex() {
        return this.hex;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.value);
        hash = 59 * hash + (this.hex ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        SearchText other = (SearchText)obj;
        return this.value.equals(other.value) && this.hex == other.hex;
    }

    public String toString(boolean hexString, CharTable charTable) {
        if (hexString || this.hex) {
            return SearchText.toString(SearchText.parse(this.value, this.hex, charTable), hexString, charTable);
        }
        return this.value;
    }

    public int[] parseLower(CharTable charTable) {
        return SearchText.parse(this.value.toLowerCase(Locale.ENGLISH), this.hex, charTable);
    }

    public int[] parseUpper(CharTable charTable) {
        return SearchText.parse(this.value.toUpperCase(Locale.ENGLISH), this.hex, charTable);
    }

    public int[] parse(CharTable charTable) {
        return SearchText.parse(this.value, this.hex, charTable);
    }

    public static String toString(int[] value, boolean hex, CharTable charTable) {
        StringBuilder sb = new StringBuilder();
        if (hex) {
            for (int i = 0; i < value.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(String.format("%02X", value[i]));
            }
        } else {
            for (int i = 0; i < value.length; ++i) {
                sb.append(charTable.getChar(value[i]));
            }
        }
        return sb.toString();
    }

    public static int[] parse(String input, boolean hex, CharTable charTable) {
        int[] result;
        if (input == null) {
            return new int[0];
        }
        if (hex) {
            input = input.replaceAll("\\s+", "");
            result = new int[input.length() >> 1];
            for (int i = result.length - 1; i >= 0; --i) {
                int value = 0;
                try {
                    value = Integer.parseInt(input.substring(i << 1, (i << 1) + 2), 16);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                result[i] = value;
            }
        } else {
            result = new int[input.length()];
            for (int i = input.length() - 1; i >= 0; --i) {
                result[i] = charTable.getValue(input.charAt(i));
                if (result[i] >= 0) continue;
                result[i] = 0;
            }
        }
        return result;
    }
}

