/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import nintaco.gui.historyeditor.change.HistoryChange;

public class ChangeListModel
extends AbstractListModel<HistoryChange> {
    private final List<HistoryChange> changes = new ArrayList<HistoryChange>();
    private int changesIndex;

    public List<HistoryChange> getChanges() {
        return new ArrayList<HistoryChange>(this.changes);
    }

    public void setChanges(List<HistoryChange> changes, int changesIndex) {
        this.changesIndex = changesIndex;
        int priorLastIndex = this.changes.size() - 1;
        this.changes.clear();
        if (priorLastIndex >= 0) {
            this.fireIntervalRemoved(this, 0, priorLastIndex);
        }
        this.changes.addAll(changes);
        this.fireIntervalAdded(this, 0, this.changes.size() - 1);
    }

    public int getChangesIndex() {
        return this.changesIndex;
    }

    public void incrementChangesIndex() {
        this.setChangesIndex(this.changesIndex + 1);
    }

    public void decrementChangesIndex() {
        if (this.changesIndex > 0) {
            this.setChangesIndex(this.changesIndex - 1);
        }
    }

    public void setChangesIndex(int changesIndex) {
        int maxChangesIndex;
        int minChangesIndex;
        if (changesIndex > this.changesIndex) {
            minChangesIndex = this.changesIndex;
            maxChangesIndex = changesIndex;
        } else {
            minChangesIndex = changesIndex;
            maxChangesIndex = this.changesIndex;
        }
        this.changesIndex = changesIndex;
        this.fireContentsChanged(this, minChangesIndex, maxChangesIndex);
    }

    public void addChange(HistoryChange change) {
        int priorSize = this.changes.size();
        while (this.changes.size() > this.changesIndex) {
            this.changes.remove(this.changes.size() - 1);
        }
        if (priorSize > this.changes.size()) {
            this.fireIntervalRemoved(this, this.changes.size(), priorSize - 1);
        }
        this.changes.add(change);
        this.fireIntervalAdded(this, this.changes.size() - 1, this.changes.size() - 1);
        this.setChangesIndex(this.changes.size());
    }

    public void clear() {
        if (this.changes.isEmpty()) {
            return;
        }
        if (this.changes.size() > 1) {
            this.changesIndex = 1;
            HistoryChange change = this.changes.get(0);
            int lastIndex = this.changes.size() - 1;
            this.changes.clear();
            this.changes.add(change);
            this.fireContentsChanged(this, 0, lastIndex);
        }
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    @Override
    public int getSize() {
        return this.changes.size();
    }

    @Override
    public HistoryChange getElementAt(int index) {
        return this.changes.get(index);
    }
}

