/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import nintaco.gui.Int;
import nintaco.gui.IntPoint;
import nintaco.gui.historyeditor.BookmarksModel;
import nintaco.gui.historyeditor.ChangeListModel;
import nintaco.gui.historyeditor.change.ButtonsChange;
import nintaco.gui.historyeditor.change.DeleteChange;
import nintaco.gui.historyeditor.change.HistoryChange;
import nintaco.gui.historyeditor.change.InsertChange;
import nintaco.gui.historyeditor.change.Multichange;
import nintaco.gui.historyeditor.change.RunChange;
import nintaco.movie.Movie;
import nintaco.movie.MovieBlock;
import nintaco.util.BitUtil;
import nintaco.util.MathUtil;

public class HistoryTableModel
extends AbstractTableModel {
    public static final String SQUARE = "25A0";
    public static final String TRIANGLE = "25BA";
    public static final String BLUE = "66CCFF";
    public static final String TAN = "A58A57";
    public static final String PINK = "FC9D9F";
    public static final String COLOR_SYMBOL = "<font color='#%s'>&#x%s;</font>";
    public static final String[] HTMLS;
    public static final String[] BUTTON_NAMES;
    public static final int HOT_LENGTH = 16;
    public static final Color[] HOT_COLORS;
    private final int[] playerIndices = new int[4];
    private final int[] columnIndices = new int[32];
    private final ChangeListModel changeListModel;
    private final BookmarksModel bookmarksModel;
    private final Int key = new Int();
    private Movie movie;
    private Set<Int> bookmarks = new HashSet<Int>();
    private Map<IntPoint, Color> hotCells = new HashMap<IntPoint, Color>();
    private boolean[] viewPlayers;
    private int columnCount = 10;
    private int players = 1;
    private int headIndex;
    private int lastIndex = -1;
    private int tailIndex;

    public HistoryTableModel(ChangeListModel changeListModel, BookmarksModel bookmarksModel) {
        this.changeListModel = changeListModel;
        this.bookmarksModel = bookmarksModel;
        this.setViewPlayers(new boolean[]{true, true, false, false});
    }

    public BookmarksModel getBookmarksModel() {
        return this.bookmarksModel;
    }

    public ChangeListModel getChangeListModel() {
        return this.changeListModel;
    }

    public int undo() {
        if (this.changeListModel.getChangesIndex() > 1) {
            this.changeListModel.decrementChangesIndex();
            int rowIndex = this.changeListModel.getElementAt(this.changeListModel.getChangesIndex()).revert(this);
            this.updateHotCells();
            if (rowIndex >= 0 && rowIndex - 1 < this.tailIndex) {
                this.setTailIndex(rowIndex - 1);
            }
            return rowIndex;
        }
        return -1;
    }

    public int redo() {
        if (this.changeListModel.getChangesIndex() < this.changeListModel.getSize()) {
            int rowIndex = this.changeListModel.getElementAt(this.changeListModel.getChangesIndex()).apply(this);
            this.changeListModel.incrementChangesIndex();
            this.updateHotCells();
            if (rowIndex >= 0 && rowIndex - 1 < this.tailIndex) {
                this.setTailIndex(rowIndex - 1);
            }
            return rowIndex;
        }
        return -1;
    }

    public void insertButtons(int rowIndex, int rowCount) {
        this.insertButtons(rowIndex, new int[rowCount]);
    }

    public void insertButtons(int rowIndex, int[] buttons) {
        if (buttons == null || buttons.length == 0) {
            return;
        }
        this.addChange(rowIndex, new InsertChange(rowIndex, buttons), HistoryTableModel.createRange("Insert", rowIndex, rowIndex + buttons.length - 1), new Object[0]);
    }

    public void trimBottom(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        int rowCount = this.getRowCount() - rowIndex;
        this.addChange(rowIndex, new DeleteChange(rowIndex, rowCount), HistoryTableModel.createRange("Trim bottom", rowIndex, rowIndex + rowCount - 1), new Object[0]);
    }

    public DeleteChange deleteButtons(int[] rows) {
        DeleteChange trimTopChange = null;
        if (rows.length == 0) {
            return trimTopChange;
        }
        Arrays.sort(rows);
        ArrayList<DeleteChange> deleteChanges = new ArrayList<DeleteChange>();
        int lastRowIndex = rows.length - 1;
        int j = 0;
        for (int i = 0; i <= lastRowIndex; ++i) {
            if (i != lastRowIndex && rows[i] + 1 == rows[i + 1]) continue;
            DeleteChange change = new DeleteChange(rows[j], i - j + 1);
            if (change.getRowIndex() == 0) {
                trimTopChange = change;
            } else {
                deleteChanges.add(change);
            }
            j = i + 1;
        }
        if (!deleteChanges.isEmpty()) {
            Collections.reverse(deleteChanges);
            this.addChange(rows[0], new Multichange((HistoryChange[])deleteChanges.toArray(new DeleteChange[deleteChanges.size()])), HistoryTableModel.createRange("Delete", rows[0], rows[rows.length - 1]), new Object[0]);
        }
        return trimTopChange;
    }

    public void deleteRows(int rowIndex, int[] buttons) {
        if (buttons.length == 0) {
            return;
        }
        int rowCount = this.getRowCount();
        List<MovieBlock> blocks = this.movie.getMovieBlocks();
        int endIndex = rowCount - 1;
        int newFrameCount = rowCount - buttons.length;
        int newBlocksSize = Math.max(1, MathUtil.roundUpDivision(newFrameCount, 64));
        int index1 = rowIndex;
        int blocksIndex1 = index1 >> Movie.BLOCK_SHIFT;
        int[] buttons1 = blocks.get((int)blocksIndex1).buttons;
        index1 &= 0x3F;
        int i = 0;
        while (true) {
            buttons[i] = buttons1[index1];
            if (i == buttons.length - 1) break;
            if (++index1 == 64) {
                index1 = 0;
                buttons1 = blocks.get((int)(++blocksIndex1)).buttons;
            }
            ++i;
        }
        index1 = rowIndex;
        blocksIndex1 = index1 >> Movie.BLOCK_SHIFT;
        buttons1 = blocks.get((int)blocksIndex1).buttons;
        index1 &= 0x3F;
        int index2 = rowIndex + buttons.length;
        int row = index2;
        if (row <= endIndex) {
            int blocksIndex2 = index2 >> Movie.BLOCK_SHIFT;
            int[] buttons2 = blocks.get((int)blocksIndex2).buttons;
            index2 &= 0x3F;
            while (true) {
                buttons1[index1] = buttons2[index2];
                if (++row > endIndex) break;
                if (++index1 == 64) {
                    index1 = 0;
                    buttons1 = blocks.get((int)(++blocksIndex1)).buttons;
                }
                if (++index2 != 64) continue;
                index2 = 0;
                buttons2 = blocks.get((int)(++blocksIndex2)).buttons;
            }
        }
        this.movie.frameCount = newFrameCount;
        while (blocks.size() > newBlocksSize) {
            blocks.remove(blocks.size() - 1);
        }
        int i2 = this.movie.getFrameCount() - 1;
        int[] bs = this.getMovieBlock((int)i2).buttons;
        i2 = (i2 & 0x3F) + 1;
        while (i2 < 64) {
            bs[i2++] = 0;
        }
        this.fireTableRowsDeleted(rowIndex, rowIndex + buttons.length - 1);
        if (this.headIndex >= this.getRowCount()) {
            this.setHeadIndex(this.getRowCount() - 1);
        }
        if (this.lastIndex >= this.getRowCount()) {
            this.setLastIndex(this.getRowCount() - 1);
        }
        if (this.tailIndex >= this.getRowCount()) {
            this.setTailIndex(this.getRowCount() - 1);
        }
    }

    public void clear() {
        this.clear(null);
    }

    public void clear(byte[] saveState) {
        int lastRowIndex = this.getRowCount() - 1;
        this.headIndex = 0;
        this.lastIndex = -1;
        this.tailIndex = 0;
        this.bookmarks.clear();
        this.bookmarksModel.clear();
        this.changeListModel.clear();
        this.hotCells.clear();
        this.movie.clear(saveState);
        this.fireTableRowsDeleted(0, Math.max(0, lastRowIndex));
    }

    public void insertRows(int rowIndex, int[] buttons) {
        int index1;
        if (buttons.length == 0) {
            return;
        }
        int frameCount = this.getRowCount();
        List<MovieBlock> blocks = this.movie.getMovieBlocks();
        int newFrameCount = frameCount + buttons.length;
        int newBlocksSize = Math.max(1, MathUtil.roundUpDivision(newFrameCount, 64));
        while (blocks.size() < newBlocksSize) {
            blocks.add(new MovieBlock());
        }
        if (rowIndex < 0) {
            rowIndex = 0;
        } else if (rowIndex >= frameCount) {
            rowIndex = frameCount;
        }
        if (frameCount == 0 || rowIndex == frameCount) {
            int index12 = frameCount;
            int blocksIndex1 = index12 >> Movie.BLOCK_SHIFT;
            int[] buttons1 = blocks.get((int)blocksIndex1).buttons;
            index12 &= 0x3F;
            if (buttons.length > 0) {
                int i = 0;
                while (true) {
                    buttons1[index12] = buttons[i];
                    if (++i >= buttons.length) break;
                    if (++index12 < 64) continue;
                    index12 = 0;
                    buttons1 = blocks.get((int)(++blocksIndex1)).buttons;
                }
            }
            this.movie.frameCount = newFrameCount;
            this.fireTableRowsInserted(rowIndex, rowIndex + buttons.length - 1);
            return;
        }
        int index2 = newFrameCount - 1;
        int row = index1 = index2 - buttons.length;
        int blocksIndex1 = index1 >> Movie.BLOCK_SHIFT;
        int blocksIndex2 = index2 >> Movie.BLOCK_SHIFT;
        int[] buttons1 = blocks.get((int)blocksIndex1).buttons;
        int[] buttons2 = blocks.get((int)blocksIndex2).buttons;
        index1 &= 0x3F;
        index2 &= 0x3F;
        while (true) {
            buttons2[index2] = buttons1[index1];
            if (row == rowIndex) break;
            --row;
            if (--index1 < 0) {
                index1 = 63;
                buttons1 = blocks.get((int)(--blocksIndex1)).buttons;
            }
            if (--index2 >= 0) continue;
            index2 = 63;
            buttons2 = blocks.get((int)(--blocksIndex2)).buttons;
        }
        if (buttons.length > 0) {
            int i = 0;
            while (true) {
                buttons1[index1] = buttons[i];
                if (++i >= buttons.length) break;
                if (++index1 < 64) continue;
                index1 = 0;
                buttons1 = blocks.get((int)(++blocksIndex1)).buttons;
            }
        }
        this.movie.frameCount = newFrameCount;
        this.fireTableRowsInserted(rowIndex, rowIndex + buttons.length - 1);
    }

    public void pasteButtons(int rowIndex, Integer[] buttons, boolean merge) {
        if (buttons == null || buttons.length == 0) {
            return;
        }
        int rowCount = this.getRowCount();
        ArrayList<ButtonsChange> buttonsChanges = new ArrayList<ButtonsChange>();
        for (int i = buttons.length - 1; i >= 0; --i) {
            Integer bs = buttons[i];
            int row = rowIndex + i;
            if (bs == null || row >= rowCount) continue;
            int b = this.getButtons(row);
            buttonsChanges.add(new ButtonsChange(row, b, merge ? b | bs : bs));
        }
        this.addChange(rowIndex, new Multichange(buttonsChanges), HistoryTableModel.createRange("Paste", rowIndex, rowIndex + buttons.length - 1), new Object[0]);
    }

    public void clearButtons(int[] rowIndices) {
        if (rowIndices.length == 0) {
            return;
        }
        HistoryChange[] bcs = new ButtonsChange[rowIndices.length];
        int minRowIndex = Integer.MAX_VALUE;
        int maxRowIndex = Integer.MIN_VALUE;
        for (int i = rowIndices.length - 1; i >= 0; --i) {
            int rowIndex = rowIndices[i];
            minRowIndex = Math.min(rowIndex, minRowIndex);
            maxRowIndex = Math.max(rowIndex, maxRowIndex);
            bcs[i] = new ButtonsChange(rowIndex, this.getButtons(rowIndex), 0);
        }
        this.addChange(minRowIndex, new Multichange(bcs), HistoryTableModel.createRange("Clear", minRowIndex, maxRowIndex), new Object[0]);
    }

    public void toggleButton(int rowIndex, int columnIndex) {
        int[] buttons = this.getMovieBlock((int)rowIndex).buttons;
        int blockIndex = rowIndex & 0x3F;
        int col = columnIndex - 2;
        int bit = this.playerIndices[col >> 3] | col;
        int bs = buttons[blockIndex];
        this.addChange(rowIndex, new ButtonsChange(rowIndex, buttons[blockIndex], BitUtil.toggleBit(bs, bit)), "%s %s %d", BitUtil.getBitBool(bs, bit) ? "Reset" : "Set", BUTTON_NAMES[col & 7], rowIndex);
    }

    public void handleEndRecord(int[] priorButtons, int priorRowCount, int priorHeadIndex) {
        block5: {
            for (int i = priorButtons.length - 1; i >= 0; --i) {
                if (priorButtons[i] == this.getButtons(priorHeadIndex + i)) {
                    continue;
                }
                break block5;
            }
            priorButtons = null;
        }
        InsertChange insertChange = null;
        int rowCount = this.getRowCount();
        int rowsAdded = rowCount - priorRowCount;
        if (rowsAdded > 0) {
            int[] buttons = new int[rowsAdded];
            int lastPriorRowIndex = priorRowCount - 1;
            for (int i = buttons.length - 1; i >= 0; --i) {
                buttons[i] = this.getButtons(lastPriorRowIndex + i);
            }
            insertChange = new InsertChange(priorRowCount, buttons);
        }
        if (priorButtons != null || insertChange != null) {
            RunChange runChange = new RunChange(priorHeadIndex, this.getHeadIndex(), priorButtons, insertChange);
            this.changeListModel.addChange(runChange);
            this.updateHotCells();
        }
    }

    public void clearChanges() {
        this.changeListModel.clear();
        this.updateHotCells();
    }

    public void addChange(HistoryChange change) {
        this.changeListModel.addChange(change);
        change.apply(this);
        this.updateHotCells();
    }

    public void addChange(int rowIndex, HistoryChange change, String description, Object ... params) {
        change.setDescription(description, params);
        this.addChange(change);
        if (rowIndex - 1 < this.tailIndex) {
            this.setTailIndex(rowIndex - 1);
        }
    }

    private void updateHotCells() {
        Map<IntPoint, Color> oldHotCells = this.hotCells;
        this.hotCells = new HashMap<IntPoint, Color>();
        int changesIndex = this.changeListModel.getChangesIndex();
        int i = changesIndex - 16;
        int j = 0;
        if (i < 0) {
            j -= i;
            i = 0;
        }
        while (i < changesIndex) {
            this.hotCells = this.changeListModel.getElementAt(i).heat(this, this.columnIndices, this.hotCells, HOT_COLORS[j]);
            ++i;
            ++j;
        }
        for (IntPoint point : oldHotCells.keySet()) {
            this.fireTableCellUpdated(point.getY(), point.getX());
        }
    }

    private int getColumnIndex(int bit) {
        int player = bit >> 3;
        if (!this.viewPlayers[player]) {
            return -1;
        }
        int count = 0;
        for (int i = player - 1; i >= 0; --i) {
            if (!this.viewPlayers[i]) continue;
            ++count;
        }
        return 2 + (count << 3 | bit & 7);
    }

    public int getHeadIndex() {
        return this.headIndex;
    }

    public void setHeadIndex(int headIndex) {
        int oldHeadIndex = this.headIndex;
        this.headIndex = headIndex;
        this.fireTableRowsUpdated(oldHeadIndex, oldHeadIndex);
        this.fireTableRowsUpdated(headIndex, headIndex);
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public void setLastIndex(int lastIndex) {
        int oldLastIndex = this.lastIndex;
        this.lastIndex = lastIndex;
        this.fireTableRowsUpdated(oldLastIndex, oldLastIndex);
        this.fireTableRowsUpdated(lastIndex, lastIndex);
    }

    public int getTailIndex() {
        return this.tailIndex;
    }

    public void setTailIndex(int tailIndex) {
        this.tailIndex = tailIndex;
        this.fireTableRowsUpdated(tailIndex, this.getRowCount() - 1);
    }

    @Override
    public void fireTableCellUpdated(int row, int column) {
        if (row >= 0 && column >= 0 && row < this.getRowCount() && column < this.getColumnCount()) {
            super.fireTableCellUpdated(row, column);
        }
    }

    @Override
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        int lastRowIndex = this.getRowCount() - 1;
        if (lastRowIndex < 0) {
            return;
        }
        if ((firstRow = MathUtil.clamp(firstRow, 0, lastRowIndex)) <= (lastRow = MathUtil.clamp(lastRow, 0, lastRowIndex))) {
            super.fireTableRowsUpdated(firstRow, lastRow);
        }
    }

    public Set<Int> getBookmarks() {
        return this.bookmarks;
    }

    public void setBookmarks(Set<Int> bookmarks) {
        Set<Int> priorBookmarks = this.bookmarks;
        this.bookmarks = bookmarks;
        for (Int i : bookmarks) {
            this.fireTableCellUpdated(i.value, 0);
        }
        for (Int i : priorBookmarks) {
            this.fireTableCellUpdated(i.value, 0);
        }
    }

    public Movie getMovie() {
        return this.movie;
    }

    public void setMovie(Movie movie) {
        this.movie = movie;
        if (movie == null) {
            this.tailIndex = -1;
            this.headIndex = -1;
        } else {
            this.headIndex = this.tailIndex = movie.frameIndex;
        }
        this.fireTableDataChanged();
    }

    public int getPlayers() {
        return this.players;
    }

    public boolean[] getViewPlayers() {
        return this.viewPlayers;
    }

    public final void setViewPlayers(boolean[] viewPlayers) {
        int i;
        this.viewPlayers = viewPlayers;
        this.players = 0;
        int j = 0;
        for (i = 0; i < viewPlayers.length; ++i) {
            if (!viewPlayers[i]) continue;
            this.playerIndices[j++] = i << 3;
            ++this.players;
        }
        this.columnCount = 2 + (this.players << 3);
        for (i = this.columnIndices.length - 1; i >= 0; --i) {
            this.columnIndices[i] = this.getColumnIndex(i);
        }
        this.fireTableStructureChanged();
        this.updateHotCells();
    }

    public Map<IntPoint, Color> getHotCells() {
        return this.hotCells;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "";
        }
        if (columnIndex == 1) {
            return "Frame";
        }
        return BUTTON_NAMES[columnIndex - 2 & 7];
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    @Override
    public int getRowCount() {
        return this.movie != null ? this.movie.getFrameCount() : 0;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    private MovieBlock getMovieBlock(int rowIndex) {
        return this.movie.movieBlocks.get(rowIndex >= 0 ? rowIndex >> Movie.BLOCK_SHIFT : 0);
    }

    public Color getForegroundAt(int rowIndex, int columnIndex) {
        return Color.BLACK;
    }

    public int getButtons(int rowIndex) {
        return rowIndex < this.getRowCount() ? this.getMovieBlock((int)rowIndex).buttons[rowIndex & 0x3F] : 0;
    }

    public void setButtons(int rowIndex, int buttons) {
        if (rowIndex < this.getRowCount()) {
            this.getMovieBlock((int)rowIndex).buttons[rowIndex & 0x3F] = buttons;
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            this.key.setValue(rowIndex);
            return HTMLS[(this.bookmarks.contains(this.key) ? 4 : 0) | (rowIndex == this.lastIndex ? 2 : 0) | (rowIndex == this.headIndex ? 1 : 0)];
        }
        if (columnIndex == 1) {
            return String.format("% 7d", rowIndex);
        }
        if (this.movie == null) {
            return "";
        }
        int col = columnIndex - 2;
        int bit = col & 7;
        return BitUtil.getBitBool(this.getMovieBlock((int)rowIndex).buttons[rowIndex & 0x3F], this.playerIndices[col >> 3] | bit) ? BUTTON_NAMES[bit] : "";
    }

    public static String createRange(String name, int start, int end) {
        if ((start = Math.max(0, start)) == (end = Math.max(0, end))) {
            return String.format("%s %d", name, start);
        }
        return String.format("%s %d\u2013%d", name, start, end);
    }

    static {
        int i;
        HTMLS = new String[8];
        BUTTON_NAMES = new String[]{"A", "B", "S", "T", "U", "D", "L", "R"};
        HOT_COLORS = new Color[16];
        for (i = 0; i < 16; ++i) {
            double v = (double)(i + 1) / 16.0;
            v = Math.sqrt(v);
            HistoryTableModel.HOT_COLORS[i] = new Color((int)(255.0 * v), 0, 0);
        }
        for (i = 0; i < 8; ++i) {
            if (i == 0) {
                HistoryTableModel.HTMLS[i] = "";
                continue;
            }
            StringBuilder sb = new StringBuilder("<html>");
            if (BitUtil.getBitBool(i, 2)) {
                sb.append(String.format(COLOR_SYMBOL, PINK, SQUARE));
            }
            if (BitUtil.getBitBool(i, 1)) {
                sb.append(String.format(COLOR_SYMBOL, TAN, TRIANGLE));
            }
            if (BitUtil.getBitBool(i, 0)) {
                sb.append(String.format(COLOR_SYMBOL, BLUE, TRIANGLE));
            }
            sb.append("</html>");
            HistoryTableModel.HTMLS[i] = sb.toString();
        }
    }
}

