/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor.change;

import java.awt.Color;
import java.io.Serializable;
import java.util.Map;
import nintaco.gui.IntPoint;
import nintaco.gui.historyeditor.BookmarksModel;
import nintaco.gui.historyeditor.HistoryBookmark;
import nintaco.gui.historyeditor.HistoryTableModel;
import nintaco.gui.historyeditor.change.HistoryChange;

public class BookmarkDeletedChange
extends HistoryChange
implements Serializable {
    private static final long serialVersionUID = 0L;
    final HistoryBookmark bookmark;

    public BookmarkDeletedChange(HistoryBookmark bookmark) {
        this.bookmark = bookmark;
        this.setDescription("Bookmark deleted %d", bookmark.getFrame());
    }

    @Override
    public int apply(HistoryTableModel model) {
        BookmarksModel bookmarksModel = model.getBookmarksModel();
        bookmarksModel.delete(bookmarksModel.indexOf(this.bookmark));
        model.setBookmarks(bookmarksModel.getBookmarkedRows());
        return -1;
    }

    @Override
    public int revert(HistoryTableModel model) {
        BookmarksModel bookmarksModel = model.getBookmarksModel();
        bookmarksModel.add(this.bookmark);
        model.setBookmarks(bookmarksModel.getBookmarkedRows());
        return -1;
    }

    @Override
    public Map<IntPoint, Color> heat(HistoryTableModel model, int[] columnIndices, Map<IntPoint, Color> hotCells, Color color) {
        return hotCells;
    }
}

