/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor.change;

import java.awt.Color;
import java.io.Serializable;
import java.util.Map;
import nintaco.gui.IntPoint;
import nintaco.gui.historyeditor.BookmarksModel;
import nintaco.gui.historyeditor.HistoryBookmark;
import nintaco.gui.historyeditor.HistoryTableModel;
import nintaco.gui.historyeditor.change.HistoryChange;

public class BookmarkEditedChange
extends HistoryChange
implements Serializable {
    private static final long serialVersionUID = 0L;
    final HistoryBookmark priorBookmark;
    final HistoryBookmark newBookmark;

    public BookmarkEditedChange(HistoryBookmark priorBookmark, HistoryBookmark newBookmark) {
        this.priorBookmark = priorBookmark;
        this.newBookmark = newBookmark;
        this.setDescription("Bookmark edited %d", newBookmark.getFrame());
    }

    @Override
    public int apply(HistoryTableModel model) {
        BookmarksModel bookmarksModel = model.getBookmarksModel();
        if (!this.priorBookmark.getName().equalsIgnoreCase(this.newBookmark.getName())) {
            bookmarksModel.delete(bookmarksModel.indexOf(this.priorBookmark));
        }
        bookmarksModel.add(this.newBookmark);
        model.setBookmarks(bookmarksModel.getBookmarkedRows());
        return -1;
    }

    @Override
    public int revert(HistoryTableModel model) {
        BookmarksModel bookmarksModel = model.getBookmarksModel();
        if (!this.priorBookmark.getName().equalsIgnoreCase(this.newBookmark.getName())) {
            bookmarksModel.delete(bookmarksModel.indexOf(this.newBookmark));
        }
        bookmarksModel.add(this.priorBookmark);
        model.setBookmarks(bookmarksModel.getBookmarkedRows());
        return -1;
    }

    @Override
    public Map<IntPoint, Color> heat(HistoryTableModel model, int[] columnIndices, Map<IntPoint, Color> hotCells, Color color) {
        return hotCells;
    }
}

