/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor.change;

import java.awt.Color;
import java.io.Serializable;
import java.util.Map;
import nintaco.gui.IntPoint;
import nintaco.gui.historyeditor.HistoryTableModel;
import nintaco.gui.historyeditor.change.HistoryChange;

public class ButtonsChange
extends HistoryChange
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int rowIndex;
    private final int prior;
    private final int current;

    public ButtonsChange(int rowIndex, int prior, int current) {
        this.rowIndex = rowIndex;
        this.prior = prior;
        this.current = current;
    }

    @Override
    public int apply(HistoryTableModel model) {
        model.setButtons(this.rowIndex, this.current);
        return this.rowIndex;
    }

    @Override
    public int revert(HistoryTableModel model) {
        model.setButtons(this.rowIndex, this.prior);
        return this.rowIndex;
    }

    @Override
    public Map<IntPoint, Color> heat(HistoryTableModel model, int[] columnIndices, Map<IntPoint, Color> hotCells, Color color) {
        int diff = this.current ^ this.prior;
        for (int i = 0; i < 32; ++i) {
            int col = columnIndices[i];
            if (col >= 0 && (diff & 1) == 1) {
                hotCells.put(new IntPoint(col, this.rowIndex), color);
                model.fireTableCellUpdated(this.rowIndex, col);
            }
            diff >>= 1;
        }
        return hotCells;
    }
}

