/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor.change;

import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import nintaco.gui.IntPoint;
import nintaco.gui.historyeditor.HistoryTableModel;
import nintaco.gui.historyeditor.change.RangeChange;
import nintaco.movie.Movie;

public class InsertChange
extends RangeChange
implements Serializable {
    private static final long serialVersionUID = 0L;

    public InsertChange(int rowIndex, int[] buttons) {
        super(rowIndex, buttons);
    }

    @Override
    public int apply(HistoryTableModel model) {
        Movie movie = model.getMovie();
        if (movie != null) {
            movie.clearCachedFrames();
        }
        return this.insert(model);
    }

    @Override
    public int revert(HistoryTableModel model) {
        Movie movie = model.getMovie();
        if (movie != null) {
            movie.clearCachedFrames();
        }
        return this.delete(model);
    }

    @Override
    public Map<IntPoint, Color> heat(HistoryTableModel model, int[] columnIndices, Map<IntPoint, Color> hotCells, Color color) {
        HashMap<IntPoint, Color> hcs = new HashMap<IntPoint, Color>();
        for (Map.Entry<IntPoint, Color> entry : hotCells.entrySet()) {
            IntPoint p = entry.getKey();
            if (p.y >= this.rowIndex) {
                hcs.put(new IntPoint(p.x, p.y + this.buttons.length), entry.getValue());
                continue;
            }
            hcs.put(p, entry.getValue());
        }
        for (int i = this.buttons.length - 1; i >= 0; --i) {
            int row = this.rowIndex + i;
            int b = this.buttons[i];
            for (int j = 0; j < 32; ++j) {
                int col = columnIndices[j];
                if (col >= 0 && (b & 1) == 1) {
                    hcs.put(new IntPoint(col, row), color);
                    model.fireTableCellUpdated(row, col);
                }
                b >>= 1;
            }
        }
        return hcs;
    }
}

