/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor.tasks;

import java.awt.EventQueue;
import nintaco.App;
import nintaco.MachineRunner;
import nintaco.gui.historyeditor.HistoryEditorFrame;
import nintaco.gui.historyeditor.HistoryTableModel;
import nintaco.gui.historyeditor.tasks.SaveStateTask;
import nintaco.gui.image.SubMonitorFrame;
import nintaco.mappers.nintendo.vs.MainCPU;
import nintaco.movie.Movie;

public class DisposeTask
extends SaveStateTask {
    public DisposeTask(Movie movie, int tailIndex, int endFrameIndex, HistoryTableModel historyTableModel, HistoryEditorFrame historyEditorFrame) {
        super(movie, tailIndex, endFrameIndex, historyTableModel, historyEditorFrame, 64);
    }

    @Override
    protected void saveState(MachineRunner machineRunner) {
        SubMonitorFrame subMonitorFrame;
        EventQueue.invokeLater(this.historyEditorFrame::closeFrame);
        this.movie.truncate();
        machineRunner.setMovie(this.movie);
        machineRunner.getPPU().setScreenRenderer(App.getImageFrame().getImagePane());
        if (this.movie.isVsDualSystem() && (subMonitorFrame = App.getSubMonitorFrame()) != null) {
            ((MainCPU)machineRunner.getCPU()).getSubPPU().setScreenRenderer(subMonitorFrame.getImagePane());
        }
        machineRunner.getAPU().setAudioProcessor(App.getSystemAudioProcessor());
        App.setMachineRunner(machineRunner);
        App.updateFrames(machineRunner);
        new Thread(machineRunner).start();
    }

    @Override
    public void processSaveState(byte[] saveState) {
    }
}

