/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor.tasks;

import java.util.List;
import nintaco.App;
import nintaco.Breakpoint;
import nintaco.Machine;
import nintaco.MachineRunner;
import nintaco.apu.SystemAudioProcessor;
import nintaco.cheats.GameCheats;
import nintaco.disassembler.TraceLogger;
import nintaco.gui.IntList;
import nintaco.gui.historyeditor.HistoryEditorFrame;
import nintaco.gui.image.ImageFrame;
import nintaco.gui.image.ImagePane;
import nintaco.gui.image.SubMonitorFrame;
import nintaco.gui.rob.RobController;
import nintaco.input.InputUtil;
import nintaco.input.OtherInput;
import nintaco.mappers.nintendo.vs.MainCPU;
import nintaco.movie.Movie;
import nintaco.movie.MovieBlock;
import nintaco.movie.MovieFrame;
import nintaco.util.CollectionsUtil;
import nintaco.util.GuiUtil;
import nintaco.util.StreamUtil;
import nintaco.util.TimeUtil;

public class RecordTask
extends MachineRunner {
    private final HistoryEditorFrame historyEditorFrame;
    private final IntList priorButtons = new IntList();
    private int startFrameIndex;
    private int priorLastFrameIndex;
    private volatile int buttonsMask;
    private volatile boolean recordOther;
    private volatile boolean mergeButtons;
    private int renderIndex;

    public RecordTask(Movie movie, int startFrameIndex, HistoryEditorFrame historyEditorFrame) {
        super(null);
        this.movie = movie;
        this.startFrameIndex = Math.max(0, startFrameIndex);
        this.historyEditorFrame = historyEditorFrame;
        this.priorLastFrameIndex = movie.getFrameCount() - 1;
    }

    public void setRecordOptions(boolean[] recordPlayers, boolean recordOther, boolean mergeButtons) {
        int mask = 0;
        for (int i = recordPlayers.length - 1; i >= 0; --i) {
            mask <<= 8;
            mask |= recordPlayers[i] ? 255 : 0;
        }
        this.buttonsMask = mask;
        this.recordOther = recordOther;
        this.mergeButtons = mergeButtons;
    }

    @Override
    public long runFrame(MovieBlock movieBlock, int frameIndex, long next) {
        this.applyInputs(movieBlock, frameIndex);
        while (this.ppu.frameRendering) {
            TraceLogger logger;
            Breakpoint[] bs = this.breakpoints;
            if (bs != null) {
                for (int i = bs.length - 1; i >= 0; --i) {
                    Breakpoint breakpoint = bs[i];
                    if (!breakpoint.hit) continue;
                    breakpoint.hit = false;
                    this.setStepPause(true);
                }
            }
            if ((logger = this.traceLogger) != null) {
                logger.log(true, this.cpu, this.ppu, this.mapper);
            }
            if (this.pauseRequested) {
                next = this.handlePause(next);
            }
            this.cpu.executeInstruction();
            if (logger == null) continue;
            logger.log(false, this.cpu, this.ppu, this.mapper);
        }
        this.ppu.frameRendering = true;
        this.mapper.handleFrameRendered();
        App.handleFrameRendered(this);
        return next;
    }

    @Override
    public void loop() {
        try {
            this.setTerminated(false);
            this.runningThread = Thread.currentThread();
            if (this.running && this.movie != null && this.startFrameIndex >= 0) {
                App.fireStepPausedChanged(this.stepPause);
                while (this.running) {
                    if (this.forwardTime) {
                        this.play();
                        continue;
                    }
                    this.rewind();
                }
                this.cancel();
                App.setMachineRunner(null);
                App.updateFrames(null);
            }
        }
        finally {
            this.setTerminated(true);
        }
    }

    @Override
    public void play() {
        if (this.startFrameIndex < 0) {
            this.startFrameIndex = 0;
        }
        boolean vsDualSystem = this.movie.isVsDualSystem();
        this.renderIndex = this.movie.frameIndex = this.startFrameIndex & 0xFFFFFFC0;
        int blockIndex = this.movie.frameIndex >> Movie.BLOCK_SHIFT;
        this.movieBlock = this.movie.movieBlocks.get(blockIndex);
        if (this.movieBlock.saveState == null) {
            return;
        }
        try {
            this.setMachine((Machine)StreamUtil.readObject(this.movieBlock.saveState));
        }
        catch (Throwable t) {
            return;
        }
        InputUtil.setMachine(this.machine);
        this.mapper.restore(App.getCartFile());
        this.mapper.restore(App.getFdsFile());
        this.mapper.restore(App.getNsfFile());
        this.ppu.setScreenRenderer(this::recordRender);
        if (vsDualSystem) {
            ((MainCPU)this.cpu).getSubPPU().setScreenRenderer(this::recordRender2);
        }
        this.apu.setAudioProcessor(this::recordProcessOutputSample);
        ImageFrame imageFrame = App.getImageFrame();
        ImagePane imagePane = imageFrame.getImagePane();
        imagePane.setRewinding(false);
        SystemAudioProcessor systemAudioProcessor = App.getSystemAudioProcessor();
        RobController rob = this.ppu.getRob();
        if (rob != null) {
            App.updateRobFrame(rob);
        }
        App.setMachineRunner(this);
        App.updateFrames(this);
        App.getImageFrame().getImagePane().setTVSystem(this.mapper.getTVSystem());
        GameCheats.updateMachine();
        long next = System.nanoTime();
        while (true) {
            int buttonIndex;
            GuiUtil.suppressScreensaver();
            MovieFrame movieFrame = this.movie.movieFrames[0x7F & this.movie.frameIndex];
            movieFrame.frameIndex = this.movie.frameIndex;
            movieFrame.audioLength = 0;
            next = this.runFrame(this.movieBlock, this.movie.frameIndex & 0x3F, next);
            if (this.movie.frameIndex >= this.startFrameIndex) {
                SubMonitorFrame subMonitorFrame;
                this.historyEditorFrame.handleRecordedFrame(this, this.movie.frameIndex, this.movie.frameIndex > this.priorLastFrameIndex);
                imagePane.render(movieFrame.screen);
                if (vsDualSystem && (subMonitorFrame = App.getSubMonitorFrame()) != null) {
                    subMonitorFrame.getImagePane().render(movieFrame.screen2);
                }
                systemAudioProcessor.processOutputSamples(movieFrame.audioSamples, movieFrame.audioLength);
            }
            if (!this.running || !this.forwardTime) break;
            if (++this.movie.frameIndex >= this.movie.frameCount) {
                this.movie.frameCount = this.movie.frameIndex + 1;
            }
            if ((buttonIndex = this.movie.frameIndex & 0x3F) == 0) {
                blockIndex = this.movie.frameIndex >> Movie.BLOCK_SHIFT;
                while (blockIndex >= this.movie.movieBlocks.size()) {
                    this.movie.movieBlocks.add(new MovieBlock());
                }
                this.movieBlock = this.movie.movieBlocks.get(blockIndex);
                try {
                    this.movieBlock.saveState = StreamUtil.toByteArrayOutputStream(this.machine).toByteArray();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.movie.frameIndex < this.startFrameIndex) continue;
            next = TimeUtil.sleep(next, this.mapper);
            InputUtil.pollControllers(this.machine);
            if (this.movie.frameIndex <= this.priorLastFrameIndex) {
                this.priorButtons.add(this.movieBlock.buttons[buttonIndex]);
            }
            int buttons = this.buttonsMask & InputUtil.getButtons();
            if (this.mergeButtons) {
                int n = buttonIndex;
                this.movieBlock.buttons[n] = this.movieBlock.buttons[n] | buttons;
            } else {
                this.movieBlock.buttons[buttonIndex] = this.movieBlock.buttons[buttonIndex] & ~this.buttonsMask | buttons;
            }
            OtherInput[] otherInputs = InputUtil.getOtherInputs();
            if (!this.recordOther || otherInputs == null) continue;
            if (this.movieBlock.otherInputs == null) {
                this.movieBlock.otherInputs = new OtherInput[64][];
            }
            if (this.mergeButtons) {
                this.movieBlock.otherInputs[buttonIndex] = CollectionsUtil.concat(OtherInput.class, this.movieBlock.otherInputs[buttonIndex], otherInputs);
                continue;
            }
            this.movieBlock.otherInputs[buttonIndex] = otherInputs;
        }
        App.updateFrames(null);
        this.historyEditorFrame.handleEndRecord(this.priorButtons.toArray());
        this.priorButtons.clear();
        this.priorLastFrameIndex = this.movie.getFrameCount() - 1;
    }

    @Override
    protected void rewind() {
        SubMonitorFrame subMonitorFrame;
        this.rewindMovie = this.movie;
        if (this.rewindMovie == null || this.rewindMovie.getMovieBlocks().isEmpty()) {
            this.forwardTime = true;
            return;
        }
        boolean vsDualSystem = this.rewindMovie.isVsDualSystem();
        this.setMachine(null);
        SystemAudioProcessor systemAudioProcessor = App.getSystemAudioProcessor();
        SystemAudioProcessor.setMovie(null);
        ImagePane imagePane = App.getImageFrame().getImagePane();
        imagePane.setRewinding(true);
        int[] screen = imagePane.render();
        int[] screen2 = null;
        if (vsDualSystem && (subMonitorFrame = App.getSubMonitorFrame()) != null) {
            screen2 = subMonitorFrame.getImagePane().render();
        }
        int displayIndex = this.rewindMovie.frameIndex & 0x3F;
        int displayOffset = this.rewindMovie.frameIndex & 0x40;
        this.generatingOffset = displayOffset ^ 0x40;
        this.generatingIndex = 0;
        this.renderingIndex = 0;
        List<MovieBlock> movieBlocks = this.rewindMovie.getMovieBlocks();
        this.movieBlock = null;
        boolean reachedMovieStart = false;
        long next = System.nanoTime();
        while (this.running && !this.forwardTime) {
            SubMonitorFrame subMonitorFrame2;
            if (this.pauseRequested) {
                next = this.handlePause(next);
            }
            --this.rewindMovie.frameIndex;
            --displayIndex;
            ++this.generatingIndex;
            if (this.rewindMovie.frameIndex < 0) {
                reachedMovieStart = true;
                break;
            }
            if (displayIndex < 0) {
                int temp = this.generatingOffset;
                this.generatingOffset = displayOffset;
                displayOffset = temp;
                for (int i = 63; i >= 0; --i) {
                    this.rewindMovie.movieFrames[this.generatingOffset + i].audioLength = 0;
                }
                displayIndex = 63;
                this.movieBlock = null;
                this.setMachine(null);
                int movieBlocksIndex = (this.rewindMovie.frameIndex >> Movie.BLOCK_SHIFT) - 1;
                if (movieBlocksIndex >= 0) {
                    this.movieBlock = movieBlocks.get(movieBlocksIndex);
                    this.generatingIndex = 0;
                    this.renderingIndex = 0;
                    try {
                        this.setMachine((Machine)StreamUtil.readObject(this.movieBlock.saveState));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    InputUtil.setMachine(this.machine);
                    this.mapper.restore(App.getCartFile());
                    this.mapper.restore(App.getFdsFile());
                    this.mapper.restore(App.getNsfFile());
                    this.ppu.setScreenRenderer(this::rewindRender);
                    if (vsDualSystem) {
                        ((MainCPU)this.cpu).getSubPPU().setScreenRenderer(this::rewindRender2);
                    }
                    this.apu.setAudioProcessor(this::rewindProcessOutputSample);
                }
            }
            MovieFrame displayFrame = this.rewindMovie.movieFrames[displayOffset + displayIndex];
            System.arraycopy(displayFrame.screen, 0, screen, 0, screen.length);
            screen = imagePane.render();
            if (vsDualSystem && (subMonitorFrame2 = App.getSubMonitorFrame()) != null) {
                if (screen2 != null) {
                    System.arraycopy(displayFrame.screen2, 0, screen2, 0, screen2.length);
                }
                screen2 = subMonitorFrame2.getImagePane().render();
            }
            int[] audioSamples = displayFrame.audioSamples;
            for (int i = displayFrame.audioLength - 1; i >= 0; --i) {
                systemAudioProcessor.processOutputSample(audioSamples[i]);
            }
            this.rewindCaptureRobState(this.machine);
            App.updateRobFrame(displayFrame.robState);
            App.updateGlassesFrame(displayFrame.screen);
            InputUtil.rewindPollControls(this.machine);
            if (this.machine != null) {
                next = this.runFrame(this.movieBlock, this.generatingIndex, next);
            }
            this.historyEditorFrame.handleRewoundFrame(this, this.rewindMovie.frameIndex);
            next = TimeUtil.sleep(next, this.mapper);
        }
        if (this.machine != null) {
            while (++this.generatingIndex < 64) {
                next = this.runFrame(this.movieBlock, this.generatingIndex, next);
            }
        }
        while (this.running && reachedMovieStart && !this.forwardTime) {
            if (this.pauseRequested) {
                next = this.handlePause(next);
            }
            InputUtil.rewindPollControls(this.machine);
            next = TimeUtil.sleep(next, this.mapper);
        }
        this.startFrameIndex = this.movie.frameIndex;
        this.setMachine(null);
    }

    private void recordProcessOutputSample(int value) {
        this.movie.movieFrames[0x7F & this.movie.frameIndex].processOutputSample(value);
    }

    private int[] recordRender() {
        return this.movie.movieFrames[0x7F & this.renderIndex++].screen;
    }

    private int[] recordRender2() {
        return this.movie.movieFrames[0x7F & this.renderIndex - 1].screen2;
    }
}

