/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.image.filters;

import nintaco.gui.image.filters.VideoFilter;

public final class NesNtsc
extends VideoFilter {
    private static final float[] default_decoder = new float[]{0.956f, 0.621f, -0.272f, -0.647f, -1.105f, 1.702f};
    private static final float[] lo_levels = new float[]{-0.12f, 0.0f, 0.31f, 0.72f};
    private static final float[] hi_levels = new float[]{0.4f, 0.68f, 1.0f, 1.0f};
    private static final float[] phases = new float[]{-1.0f, -0.866025f, -0.5f, 0.0f, 0.5f, 0.866025f, 1.0f, 0.866025f, 0.5f, 0.0f, -0.5f, -0.866025f, -1.0f, -0.866025f, -0.5f, 0.0f, 0.5f, 0.866025f, 1.0f};
    private static boolean NES_NTSC_EMPHASIS = true;
    private static final int alignment_count = 3;
    private static final int burst_count = 3;
    private static final int rescale_in = 8;
    private static final int rescale_out = 7;
    private static final float artifacts_mid = 1.0f;
    private static final float fringing_mid = 1.0f;
    private static final int std_decoder_hue = -15;
    private static final boolean DISABLE_CORRECTION = false;
    private static final int default_palette_contrast = 0;
    private static final float PI = (float)Math.PI;
    private static final float LUMA_CUTOFF = 0.2f;
    private static final int gamma_size = 1;
    private static final int rgb_bits = 8;
    private static final float artifacts_max = 1.5f;
    private static final float fringing_max = 2.0f;
    private static final int ext_decoder_hue = 0;
    private static final int rgb_unit = 256;
    private static final float rgb_offset = 512.5f;
    private static final int nes_ntsc_min_in_width = 256;
    private static final int nes_ntsc_min_out_width = NesNtsc.NES_NTSC_OUT_WIDTH(256);
    private static final int nes_ntsc_640_in_width = 271;
    private static final int nes_ntsc_640_out_width = NesNtsc.NES_NTSC_OUT_WIDTH(271);
    private static final int nes_ntsc_640_overscan_left = 8;
    private static final int nes_ntsc_640_overscan_right = 7;
    private static final int nes_ntsc_full_in_width = 283;
    private static final int nes_ntsc_full_out_width = NesNtsc.NES_NTSC_OUT_WIDTH(283);
    private static final int nes_ntsc_full_overscan_left = 16;
    private static final int nes_ntsc_full_overscan_right = 11;
    private static final int nes_ntsc_palette_size = NES_NTSC_EMPHASIS ? 512 : 64;
    private static final float to_float = 0.003921569f;
    private static final float atten_mul = 0.79399f;
    private static final float atten_sub = 0.0782838f;
    private static final int[] tints = new int[]{0, 6, 10, 8, 2, 4, 0, 0};
    private static final int nes_ntsc_in_chunk = 3;
    private static final int nes_ntsc_out_chunk = 7;
    private static final int nes_ntsc_black = 15;
    private static final int nes_ntsc_burst_count = 3;
    private static final int nes_ntsc_entry_size = 128;
    private static final int nes_ntsc_burst_size = 42;
    private static final int burst_size = 42;
    private static final int kernel_half = 16;
    private static final int kernel_size = 33;
    private static final int nes_ntsc_rgb_builder = 0x200802;
    private static final int nes_ntsc_clamp_mask = 0x300C03;
    private static final int nes_ntsc_clamp_add = 539494914;
    private static final int rgb_kernel_size = 14;
    private static final int rgb_bias = 0x40100400;
    private static final pixel_info_t[] nes_ntsc_pixels = new pixel_info_t[]{new pixel_info_t(-4, -9, new float[]{1.0f, 1.0f, 0.6667f, 0.0f}), new pixel_info_t(-2, -7, new float[]{0.3333f, 1.0f, 1.0f, 0.3333f}), new pixel_info_t(0, -5, new float[]{0.0f, 0.6667f, 1.0f, 1.0f})};
    private final nes_ntsc_setup_t nes_ntsc_monochrome = new nes_ntsc_setup_t(0.0, -1.0, 0.0, 0.0, 0.2, 0.0, 0.2, -0.2, -0.2, -1.0, true, null, null, null, null);
    private final nes_ntsc_setup_t nes_ntsc_composite = new nes_ntsc_setup_t(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, true, null, null, null, null);
    private final nes_ntsc_setup_t nes_ntsc_svideo = new nes_ntsc_setup_t(0.0, 0.0, 0.0, 0.0, 0.2, 0.0, 0.2, -1.0, -1.0, 0.0, true, null, null, null, null);
    private final nes_ntsc_setup_t nes_ntsc_rgb = new nes_ntsc_setup_t(0.0, 0.0, 0.0, 0.0, 0.2, 0.0, 0.7, -1.0, -1.0, -1.0, true, null, null, null, null);
    private final int[] nes_ntsc_t;
    private int burstPhase;

    private static float TO_ANGLE_SIN(int color) {
        return phases[color];
    }

    private static float TO_ANGLE_COS(int color) {
        return phases[color + 3];
    }

    private static int NES_NTSC_CLAMP_(int io, int shift) {
        int sub = io >> 9 - shift & 0x300C03;
        int clamp = 539494914 - sub;
        io |= clamp;
        return io & (clamp -= sub);
    }

    private static boolean STD_HUE_CONDITION(nes_ntsc_setup_t setup) {
        return setup.base_palette == null && setup.palette == null;
    }

    private static int NES_NTSC_OUT_WIDTH(int in_width) {
        return ((in_width - 1) / 3 + 1) * 7;
    }

    private static int NES_NTSC_IN_WIDTH(int out_width) {
        return (out_width / 7 - 1) * 3 + 1;
    }

    private static int PACK_RGB(int r, int g, int b) {
        return r << 21 | g << 11 | b << 1;
    }

    private static void init_filters(init_t impl, nes_ntsc_setup_t setup) {
        int i;
        int i2;
        float[] kernels = new float[66];
        float rolloff = 1.0f + (float)setup.sharpness * 0.032f;
        float maxh = 32.0f;
        float pow_a_n = (float)Math.pow(rolloff, 32.0);
        float to_angle = (float)setup.resolution + 1.0f;
        to_angle = 0.019634955f * (to_angle * to_angle + 1.0f);
        kernels[49] = 32.0f;
        for (i2 = 0; i2 < 33; ++i2) {
            int x = i2 - 16;
            float angle = (float)x * to_angle;
            if (x == 0 && !(pow_a_n > 1.056f) && !(pow_a_n < 0.981f)) continue;
            float rolloff_cos_a = rolloff * (float)Math.cos(angle);
            float num = 1.0f - rolloff_cos_a - pow_a_n * (float)Math.cos(32.0f * angle) + pow_a_n * rolloff * (float)Math.cos(31.0f * angle);
            float den = 1.0f - rolloff_cos_a - rolloff_cos_a + rolloff * rolloff;
            float dsf = num / den;
            kernels[33 + i2] = dsf - 0.5f;
        }
        float sum = 0.0f;
        for (i2 = 0; i2 < 33; ++i2) {
            float x = 0.19634955f * (float)i2;
            float blackman = 0.42f - 0.5f * (float)Math.cos(x) + 0.08f * (float)Math.cos(x * 2.0f);
            int n = 33 + i2;
            float f = kernels[n] * blackman;
            kernels[n] = f;
            sum += f;
        }
        sum = 1.0f / sum;
        for (i2 = 0; i2 < 33; ++i2) {
            int x;
            int n = x = 33 + i2;
            kernels[n] = kernels[n] * sum;
        }
        float cutoff_factor = -0.03125f;
        float cutoff = (float)setup.bleed;
        if (cutoff < 0.0f) {
            cutoff *= cutoff;
            cutoff *= cutoff;
            cutoff *= cutoff;
            cutoff *= -46.153847f;
        }
        cutoff = -0.03125f - -0.0203125f * cutoff;
        for (i = -16; i <= 16; ++i) {
            kernels[16 + i] = (float)Math.exp((float)(i * i) * cutoff);
        }
        for (i = 0; i < 2; ++i) {
            int x;
            sum = 0.0f;
            for (x = i; x < 33; x += 2) {
                sum += kernels[x];
            }
            sum = 1.0f / sum;
            for (x = i; x < 33; x += 2) {
                int n = x;
                kernels[n] = kernels[n] * sum;
            }
        }
        float weight = 1.0f;
        float[] out = impl.kernel;
        int outIndex = 0;
        int n = 7;
        do {
            float remain = 0.0f;
            weight -= 0.125f;
            for (int i3 = 0; i3 < 66; ++i3) {
                float cur = kernels[i3];
                float m = cur * weight;
                out[outIndex++] = m + remain;
                remain = cur - m;
            }
        } while (--n != 0);
    }

    private static void init(init_t impl, nes_ntsc_setup_t setup) {
        impl.brightness = (float)setup.brightness * 128.0f + 512.5f;
        impl.contrast = (float)setup.contrast * 128.0f + 256.0f;
        impl.artifacts = (float)setup.artifacts;
        if (impl.artifacts > 0.0f) {
            impl.artifacts *= 0.5f;
        }
        impl.artifacts = impl.artifacts * 1.0f + 1.0f;
        impl.fringing = (float)setup.fringing;
        if (impl.fringing > 0.0f) {
            impl.fringing *= 1.0f;
        }
        impl.fringing = impl.fringing * 1.0f + 1.0f;
        NesNtsc.init_filters(impl, setup);
        float hue = (float)setup.hue * (float)Math.PI + 0.0f;
        float sat = (float)setup.saturation + 1.0f;
        float[] decoder = setup.decoder_matrix;
        if (decoder == null) {
            decoder = default_decoder;
            if (NesNtsc.STD_HUE_CONDITION(setup)) {
                hue += -0.2617994f;
            }
        }
        float s = (float)Math.sin(hue) * sat;
        float c = (float)Math.cos(hue) * sat;
        float[] out = impl.to_rgb;
        int outIndex = 0;
        int n = 3;
        do {
            float[] in = decoder;
            int inIndex = 0;
            int m = 3;
            do {
                float i = in[inIndex++];
                float q = in[inIndex++];
                out[outIndex++] = i * c - q * s;
                out[outIndex++] = i * s + q * c;
            } while (--m != 0);
            float t = s * -0.5f - c * 0.866025f;
            c = s * 0.866025f + c * -0.5f;
            s = t;
        } while (--n != 0);
    }

    private static void gen_kernel(init_t impl, float y, float i, float q, int[] out, int outIndex) {
        float[] to_rgb = impl.to_rgb;
        int to_rgbIndex = 0;
        int burst_remain = 3;
        y -= 512.5f;
        do {
            int pixelIndex = 0;
            int alignment_remain = 3;
            do {
                pixel_info_t pixel = nes_ntsc_pixels[pixelIndex++];
                float yy = y * impl.fringing * pixel.negate;
                float ic0 = (i + yy) * pixel.kernel[0];
                float qc1 = (q + yy) * pixel.kernel[1];
                float ic2 = (i - yy) * pixel.kernel[2];
                float qc3 = (q - yy) * pixel.kernel[3];
                float factor = impl.artifacts * pixel.negate;
                float ii = i * factor;
                float yc0 = (y + ii) * pixel.kernel[0];
                float yc2 = (y - ii) * pixel.kernel[2];
                float qq = q * factor;
                float yc1 = (y + qq) * pixel.kernel[1];
                float yc3 = (y - qq) * pixel.kernel[3];
                float[] k = impl.kernel;
                int kOffset = pixel.offset;
                for (int n = 14; n != 0; --n) {
                    float I = k[kOffset] * ic0 + k[kOffset + 2] * ic2;
                    float Q = k[kOffset + 1] * qc1 + k[kOffset + 3] * qc3;
                    float Y = k[kOffset + 33] * yc0 + k[kOffset + 33 + 1] * yc1 + k[kOffset + 33 + 2] * yc2 + k[kOffset + 33 + 3] * yc3 + 512.5f;
                    kOffset = kOffset < 396 ? (kOffset += 65) : (kOffset -= 398);
                    int r = (int)(Y + to_rgb[to_rgbIndex] * I + to_rgb[to_rgbIndex + 1] * Q);
                    int g = (int)(Y + to_rgb[to_rgbIndex + 2] * I + to_rgb[to_rgbIndex + 3] * Q);
                    int b = (int)(Y + to_rgb[to_rgbIndex + 4] * I + to_rgb[to_rgbIndex + 5] * Q);
                    out[outIndex++] = NesNtsc.PACK_RGB(r, g, b) - 0x40100400;
                }
            } while (--alignment_remain != 0);
            to_rgbIndex += 6;
            float t = i * -0.5f - q * -0.866025f;
            q = i * -0.866025f + q * -0.5f;
            i = t;
        } while (--burst_remain != 0);
    }

    private static void merge_kernel_fields(int[] io, int ioIndex) {
        for (int n = 42; n != 0; --n) {
            int p0 = io[ioIndex] + 0x40100400;
            int p1 = io[ioIndex + 42] + 0x40100400;
            int p2 = io[ioIndex + 84] + 0x40100400;
            io[ioIndex] = (p0 + p1 - ((p0 ^ p1) & 0x200802) >> 1) - 0x40100400;
            io[ioIndex + 42] = (p1 + p2 - ((p1 ^ p2) & 0x200802) >> 1) - 0x40100400;
            io[ioIndex + 84] = (p2 + p0 - ((p2 ^ p0) & 0x200802) >> 1) - 0x40100400;
            ++ioIndex;
        }
    }

    private static void correct_errors(int color, int[] out, int outIndex) {
        for (int n = 3; n != 0; --n) {
            for (int i = 0; i < 7; ++i) {
                int error = color - out[outIndex + i] - out[outIndex + (i + 12) % 14 + 14] - out[outIndex + (i + 10) % 14 + 28] - out[outIndex + i + 7] - out[outIndex + i + 19] - out[outIndex + i + 31];
                int fourth = error + 0x401004 >> 2;
                fourth &= 0x1FE7F9FE;
                int n2 = outIndex + i + 31;
                out[n2] = out[n2] + (fourth -= 0x10040100);
                int n3 = outIndex + i + 19;
                out[n3] = out[n3] + fourth;
                int n4 = outIndex + i + 7;
                out[n4] = out[n4] + fourth;
                int n5 = outIndex + i;
                out[n5] = out[n5] + (error - fourth * 3);
            }
            outIndex += 42;
        }
    }

    private void nes_ntsc_init(int[] ntsc, nes_ntsc_setup_t setup) {
        init_t impl = new init_t();
        if (setup == null) {
            setup = new nes_ntsc_setup_t(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, true, null, null, null, null);
        }
        NesNtsc.init(impl, setup);
        float gamma = (float)setup.gamma * -0.5f;
        if (NesNtsc.STD_HUE_CONDITION(setup)) {
            gamma += 0.1333f;
        }
        float gamma_factor = (float)Math.pow(Math.abs(gamma), 0.73f);
        if (gamma < 0.0f) {
            gamma_factor = -gamma_factor;
        }
        boolean merge_fields = setup.merge_fields;
        if (setup.artifacts <= -1.0 && setup.fringing <= -1.0) {
            merge_fields = true;
        }
        for (int entry = 0; entry < nes_ntsc_palette_size; ++entry) {
            int tint;
            float b;
            float g;
            float r;
            int inOffset;
            int[] in;
            int level = entry >> 4 & 3;
            float lo = lo_levels[level];
            float hi = hi_levels[level];
            int color = entry & 0xF;
            if (color == 0) {
                lo = hi;
            }
            if (color == 13) {
                hi = lo;
            }
            if (color > 13) {
                lo = 0.0f;
                hi = 0.0f;
            }
            float sat = (hi - lo) * 0.5f;
            float i = NesNtsc.TO_ANGLE_SIN(color) * sat;
            float q = NesNtsc.TO_ANGLE_COS(color) * sat;
            float y = (hi + lo) * 0.5f;
            if (setup.base_palette != null) {
                in = setup.base_palette;
                inOffset = (entry & 0x3F) * 3;
                r = 0.003921569f * (float)in[inOffset];
                g = 0.003921569f * (float)in[inOffset + 1];
                b = 0.003921569f * (float)in[inOffset + 2];
                y = r * 0.299f + g * 0.587f + b * 0.114f;
                i = r * 0.596f - g * 0.275f - b * 0.321f;
                q = r * 0.212f - g * 0.523f + b * 0.311f;
            }
            if (NES_NTSC_EMPHASIS && (tint = entry >> 6 & 7) != 0 && color <= 13) {
                if (tint == 7) {
                    y = y * 0.8972087f - 0.0884607f;
                } else {
                    int tint_color = tints[tint];
                    float _sat = hi * 0.10300499f + 0.0391419f;
                    y -= _sat * 0.5f;
                    if (tint >= 3 && tint != 4) {
                        y -= (_sat *= 0.6f);
                    }
                    i += NesNtsc.TO_ANGLE_SIN(tint_color) * _sat;
                    q += NesNtsc.TO_ANGLE_COS(tint_color) * _sat;
                }
            }
            if (setup.palette != null) {
                in = setup.palette;
                inOffset = entry * 3;
                r = 0.003921569f * (float)in[inOffset];
                g = 0.003921569f * (float)in[inOffset + 1];
                b = 0.003921569f * (float)in[inOffset + 2];
                y = r * 0.299f + g * 0.587f + b * 0.114f;
                i = r * 0.596f - g * 0.275f - b * 0.321f;
                q = r * 0.212f - g * 0.523f + b * 0.311f;
            }
            y *= (float)setup.contrast * 0.5f + 1.0f;
            float r2 = (y += (float)setup.brightness * 0.5f - 0.001953125f) + default_decoder[0] * i + default_decoder[1] * q;
            float g2 = y + default_decoder[2] * i + default_decoder[3] * q;
            float b2 = y + default_decoder[4] * i + default_decoder[5] * q;
            r2 = (r2 * gamma_factor - gamma_factor) * r2 + r2;
            g2 = (g2 * gamma_factor - gamma_factor) * g2 + g2;
            b2 = (b2 * gamma_factor - gamma_factor) * b2 + b2;
            y = r2 * 0.299f + g2 * 0.587f + b2 * 0.114f;
            i = r2 * 0.596f - g2 * 0.275f - b2 * 0.321f;
            q = r2 * 0.212f - g2 * 0.523f + b2 * 0.311f;
            y *= 256.0f;
            int r22 = (int)((y += 512.5f) + impl.to_rgb[0] * (i *= 256.0f) + impl.to_rgb[1] * (q *= 256.0f));
            int g22 = (int)(y + impl.to_rgb[2] * i + impl.to_rgb[3] * q);
            int b22 = (int)(y + impl.to_rgb[4] * i + impl.to_rgb[5] * q);
            int rgb = NesNtsc.PACK_RGB(r22, g22, b22 < 992 ? b22 : 992);
            if (setup.palette_out != null) {
                int offset = entry * 3;
                int clamped = NesNtsc.NES_NTSC_CLAMP_(rgb, 0);
                setup.palette_out[offset] = clamped >> 21 & 0xFF;
                setup.palette_out[offset + 1] = clamped >> 11 & 0xFF;
                setup.palette_out[offset + 2] = clamped >> 1 & 0xFF;
            }
            if (ntsc == null) continue;
            int kernelIndex = entry * 128;
            NesNtsc.gen_kernel(impl, y, i, q, ntsc, kernelIndex);
            if (merge_fields) {
                NesNtsc.merge_kernel_fields(ntsc, kernelIndex);
            }
            NesNtsc.correct_errors(rgb, ntsc, kernelIndex);
        }
    }

    private static int NES_NTSC_RGB_OUT(int raw) {
        int sub = raw >> 9 & 0x300C03;
        int clamp = 539494914 - sub;
        raw |= clamp;
        return (raw &= (clamp -= sub)) >> 5 & 0xFF0000 | raw >> 3 & 0xFF00 | raw >> 1 & 0xFF;
    }

    public static void nes_ntsc_blit(int[] ntsc, int[] input, int in_row_width, int burst_phase, int in_width, int in_height, int[] rgb_out, int out_pitch, int inputIndex, int outputIndex) {
        int chunk_count = (in_width - 1) / 3;
        while (in_height != 0) {
            int x0;
            int k0;
            int lineInIndex = inputIndex;
            int k = burst_phase * 42;
            int k1 = k0 = k + 1920;
            int k2 = k + (input[lineInIndex] & 0x1FF) * 128;
            int x1 = k0;
            int x2 = k0;
            int lineOutIndex = outputIndex;
            ++lineInIndex;
            for (int n = chunk_count; n != 0; --n) {
                x0 = k0;
                k0 = k + (input[lineInIndex] & 0x1FF) * 128;
                rgb_out[lineOutIndex] = NesNtsc.NES_NTSC_RGB_OUT(ntsc[k0] + ntsc[k1 + 19] + ntsc[k2 + 31] + ntsc[x0 + 7] + ntsc[x1 + 26] + ntsc[x2 + 38]);
                rgb_out[lineOutIndex + 1] = NesNtsc.NES_NTSC_RGB_OUT(ntsc[k0 + 1] + ntsc[k1 + 20] + ntsc[k2 + 32] + ntsc[x0 + 8] + ntsc[x1 + 27] + ntsc[x2 + 39]);
                x1 = k1;
                k1 = k + (input[lineInIndex + 1] & 0x1FF) * 128;
                rgb_out[lineOutIndex + 2] = NesNtsc.NES_NTSC_RGB_OUT(ntsc[k0 + 2] + ntsc[k1 + 14] + ntsc[k2 + 33] + ntsc[x0 + 9] + ntsc[x1 + 21] + ntsc[x2 + 40]);
                rgb_out[lineOutIndex + 3] = NesNtsc.NES_NTSC_RGB_OUT(ntsc[k0 + 3] + ntsc[k1 + 15] + ntsc[k2 + 34] + ntsc[x0 + 10] + ntsc[x1 + 22] + ntsc[x2 + 41]);
                x2 = k2;
                k2 = k + (input[lineInIndex + 2] & 0x1FF) * 128;
                rgb_out[lineOutIndex + 4] = NesNtsc.NES_NTSC_RGB_OUT(ntsc[k0 + 4] + ntsc[k1 + 16] + ntsc[k2 + 28] + ntsc[x0 + 11] + ntsc[x1 + 23] + ntsc[x2 + 35]);
                rgb_out[lineOutIndex + 5] = NesNtsc.NES_NTSC_RGB_OUT(ntsc[k0 + 5] + ntsc[k1 + 17] + ntsc[k2 + 29] + ntsc[x0 + 12] + ntsc[x1 + 24] + ntsc[x2 + 36]);
                rgb_out[lineOutIndex + 6] = NesNtsc.NES_NTSC_RGB_OUT(ntsc[k0 + 6] + ntsc[k1 + 18] + ntsc[k2 + 30] + ntsc[x0 + 13] + ntsc[x1 + 25] + ntsc[x2 + 37]);
                lineInIndex += 3;
                lineOutIndex += 7;
            }
            x0 = k0;
            k0 = k + 1920;
            rgb_out[lineOutIndex] = NesNtsc.NES_NTSC_RGB_OUT(ntsc[k0] + ntsc[k1 + 19] + ntsc[k2 + 31] + ntsc[x0 + 7] + ntsc[x1 + 26] + ntsc[x2 + 38]);
            rgb_out[lineOutIndex + 1] = NesNtsc.NES_NTSC_RGB_OUT(ntsc[k0 + 1] + ntsc[k1 + 20] + ntsc[k2 + 32] + ntsc[x0 + 8] + ntsc[x1 + 27] + ntsc[x2 + 39]);
            x1 = k1;
            k1 = k + 1920;
            rgb_out[lineOutIndex + 2] = NesNtsc.NES_NTSC_RGB_OUT(ntsc[k0 + 2] + ntsc[k1 + 14] + ntsc[k2 + 33] + ntsc[x0 + 9] + ntsc[x1 + 21] + ntsc[x2 + 40]);
            rgb_out[lineOutIndex + 3] = NesNtsc.NES_NTSC_RGB_OUT(ntsc[k0 + 3] + ntsc[k1 + 15] + ntsc[k2 + 34] + ntsc[x0 + 10] + ntsc[x1 + 22] + ntsc[x2 + 41]);
            x2 = k2;
            k2 = k + 1920;
            rgb_out[lineOutIndex + 4] = NesNtsc.NES_NTSC_RGB_OUT(ntsc[k0 + 4] + ntsc[k1 + 16] + ntsc[k2 + 28] + ntsc[x0 + 11] + ntsc[x1 + 23] + ntsc[x2 + 35]);
            rgb_out[lineOutIndex + 5] = NesNtsc.NES_NTSC_RGB_OUT(ntsc[k0 + 5] + ntsc[k1 + 17] + ntsc[k2 + 29] + ntsc[x0 + 12] + ntsc[x1 + 24] + ntsc[x2 + 36]);
            rgb_out[lineOutIndex + 6] = NesNtsc.NES_NTSC_RGB_OUT(ntsc[k0 + 6] + ntsc[k1 + 18] + ntsc[k2 + 30] + ntsc[x0 + 13] + ntsc[x1 + 25] + ntsc[x2 + 37]);
            burst_phase = (burst_phase + 1) % 3;
            inputIndex += in_row_width;
            outputIndex += out_pitch;
            --in_height;
        }
    }

    public NesNtsc(int[][] extendedPalettes) {
        super(NesNtsc.NES_NTSC_OUT_WIDTH(256), 240);
        this.nes_ntsc_t = new int[nes_ntsc_palette_size * 128];
        this.setExtendedPalettes(extendedPalettes);
    }

    public NesNtsc(NesNtsc ntscFilter) {
        super(ntscFilter.getImage(), ntscFilter.getImageData());
        this.nes_ntsc_t = ntscFilter.nes_ntsc_t;
    }

    @Override
    public void setExtendedPalettes(int[][] extendedPalettes) {
        int[] ntscExtenedPalette = extendedPalettes[0];
        int[] palette = new int[3 * ntscExtenedPalette.length];
        int j = 0;
        for (int i = 0; i < ntscExtenedPalette.length; ++i) {
            palette[j++] = ntscExtenedPalette[i] >> 16 & 0xFF;
            palette[j++] = ntscExtenedPalette[i] >> 8 & 0xFF;
            palette[j++] = ntscExtenedPalette[i] & 0xFF;
        }
        this.nes_ntsc_composite.palette = palette;
        this.nes_ntsc_init(this.nes_ntsc_t, this.nes_ntsc_composite);
    }

    @Override
    public void filter(int[] in, int yFirst, int yLast) {
        NesNtsc.nes_ntsc_blit(this.nes_ntsc_t, in, 256, this.burstPhase, 256, yLast - yFirst, this.out, 602, yFirst << 8, yFirst * 602);
        this.burstPhase ^= 1;
    }

    private static class pixel_info_t {
        int offset;
        float negate;
        final float[] kernel;

        public pixel_info_t(int ntsc, int scaled, float[] kernel) {
            this.offset = this.PIXEL_OFFSET_(ntsc - scaled / 7 * 8, (scaled + 70) % 7);
            this.negate = 1.0f - (float)(ntsc + 100 & 2);
            this.kernel = kernel;
        }

        private int PIXEL_OFFSET_(int ntsc, int scaled) {
            return 16 + ntsc + (scaled != 0 ? 1 : 0) + (7 - scaled) % 7 + 66 * scaled;
        }
    }

    private static class init_t {
        final float[] to_rgb = new float[18];
        final float[] to_float = new float[1];
        float contrast;
        float brightness;
        float artifacts;
        float fringing;
        final float[] kernel = new float[462];

        private init_t() {
        }
    }

    public static class nes_ntsc_setup_t {
        double hue;
        double saturation;
        double contrast;
        double brightness;
        double sharpness;
        double gamma;
        double resolution;
        double artifacts;
        double fringing;
        double bleed;
        boolean merge_fields;
        float[] decoder_matrix;
        int[] palette_out;
        int[] palette;
        int[] base_palette;

        public nes_ntsc_setup_t(double hue, double saturation, double contrast, double brightness, double sharpness, double gamma, double resolution, double artifacts, double fringing, double bleed, boolean merge_fields, float[] decoder_matrix, int[] palette_out, int[] palette, int[] base_palette) {
            this.hue = hue;
            this.saturation = saturation;
            this.contrast = contrast;
            this.brightness = brightness;
            this.sharpness = sharpness;
            this.gamma = gamma;
            this.resolution = resolution;
            this.artifacts = artifacts;
            this.fringing = fringing;
            this.bleed = bleed;
            this.merge_fields = merge_fields;
            this.decoder_matrix = decoder_matrix;
            this.palette_out = palette_out;
            this.palette = palette;
            this.base_palette = base_palette;
        }
    }
}

