/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.input.settings;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import nintaco.input.InputUtil;
import nintaco.input.Inputs;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;

public class InputSettingsDialog
extends JDialog {
    private JPanel autofirePanel;
    private JButton autofireResetButton;
    private JSlider autofireSlider;
    private JButton cancelButton;
    private JCheckBox crosshairsCheckBox;
    private JCheckBox disableKeyboardRewindTimeCheckBox;
    private JCheckBox exchangeGlassesCheckBox;
    private JCheckBox hideCursorCheckBox;
    private JCheckBox hideFullscreenMouseCheckBox;
    private JCheckBox hideInactiveMouseCheckBox;
    private JRadioButton highSpeed200RadioButton;
    private JRadioButton highSpeed300RadioButton;
    private JRadioButton highSpeed400RadioButton;
    private JRadioButton highSpeedMaxRadioButton;
    private JPanel highSpeedPanel;
    private JCheckBox impossibleInputCheckBox;
    private JButton okButton;
    private ButtonGroup speedUpButtonGroup;
    private JLabel zapperLightDetectionMarginLabel;
    private JSpinner zapperLightDetectionMarginSpinner;

    public InputSettingsDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initSpinner();
        this.initAutofireSlider();
        this.loadFields();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initSpinner() {
        this.zapperLightDetectionMarginSpinner.setModel(new SpinnerNumberModel(3, 0, 7, 1));
        this.zapperLightDetectionMarginSpinner.setEditor(new JSpinner.NumberEditor(this.zapperLightDetectionMarginSpinner, "#"));
        GuiUtil.addLoseFocusListener((Window)this, this.zapperLightDetectionMarginSpinner);
    }

    private void initAutofireSlider() {
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(7, new JLabel("Slow"));
        labelTable.put(4, new JLabel("Medium"));
        labelTable.put(1, new JLabel("Fast"));
        this.autofireSlider.setLabelTable(labelTable);
    }

    private void closeDialog() {
        this.dispose();
    }

    private void loadFields() {
        this.loadFields(AppPrefs.getInstance().getInputs());
    }

    private void loadFields(Inputs inputs) {
        this.autofireSlider.setValue(inputs.getAutofireRate());
        this.impossibleInputCheckBox.setSelected(inputs.isAllowImpossibleInput());
        this.crosshairsCheckBox.setSelected(inputs.isShowZapperCrosshairs());
        this.hideInactiveMouseCheckBox.setSelected(inputs.isHideInactiveMouse());
        this.hideFullscreenMouseCheckBox.setSelected(inputs.isHideFullscreenMouse());
        this.exchangeGlassesCheckBox.setSelected(inputs.isExchangeGlasses());
        this.disableKeyboardRewindTimeCheckBox.setSelected(inputs.isDisableKeyboardRewindTime());
        this.zapperLightDetectionMarginSpinner.setValue(inputs.getZapperLightDetectionMargin());
        switch (inputs.getHighSpeedRate()) {
            case 200: {
                this.highSpeed200RadioButton.setSelected(true);
                break;
            }
            case 300: {
                this.highSpeed300RadioButton.setSelected(true);
                break;
            }
            case 400: {
                this.highSpeed400RadioButton.setSelected(true);
                break;
            }
            default: {
                this.highSpeedMaxRadioButton.setSelected(true);
            }
        }
    }

    private void initComponents() {
        this.speedUpButtonGroup = new ButtonGroup();
        this.autofirePanel = new JPanel();
        this.autofireSlider = new JSlider();
        this.impossibleInputCheckBox = new JCheckBox();
        this.crosshairsCheckBox = new JCheckBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.hideCursorCheckBox = new JCheckBox();
        this.hideInactiveMouseCheckBox = new JCheckBox();
        this.hideFullscreenMouseCheckBox = new JCheckBox();
        this.autofireResetButton = new JButton();
        this.exchangeGlassesCheckBox = new JCheckBox();
        this.disableKeyboardRewindTimeCheckBox = new JCheckBox();
        this.highSpeedPanel = new JPanel();
        this.highSpeed200RadioButton = new JRadioButton();
        this.highSpeed300RadioButton = new JRadioButton();
        this.highSpeed400RadioButton = new JRadioButton();
        this.highSpeedMaxRadioButton = new JRadioButton();
        this.zapperLightDetectionMarginLabel = new JLabel();
        this.zapperLightDetectionMarginSpinner = new JSpinner();
        this.setDefaultCloseOperation(2);
        this.setTitle("Input Settings");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                InputSettingsDialog.this.formWindowClosing(evt);
            }
        });
        this.autofirePanel.setBorder(BorderFactory.createTitledBorder("Autofire Rate"));
        this.autofirePanel.setMaximumSize(null);
        this.autofireSlider.setMajorTickSpacing(1);
        this.autofireSlider.setMaximum(7);
        this.autofireSlider.setMinimum(1);
        this.autofireSlider.setMinorTickSpacing(1);
        this.autofireSlider.setPaintLabels(true);
        this.autofireSlider.setPaintTicks(true);
        this.autofireSlider.setSnapToTicks(true);
        this.autofireSlider.setValue(4);
        this.autofireSlider.setFocusable(false);
        this.autofireSlider.setInverted(true);
        GroupLayout autofirePanelLayout = new GroupLayout(this.autofirePanel);
        this.autofirePanel.setLayout(autofirePanelLayout);
        autofirePanelLayout.setHorizontalGroup(autofirePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(autofirePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.autofireSlider, -1, -1, Short.MAX_VALUE).addContainerGap()));
        autofirePanelLayout.setVerticalGroup(autofirePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(autofirePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.autofireSlider, -2, -1, -2).addContainerGap()));
        this.impossibleInputCheckBox.setText("Allow impossible Gamepad input (Left+Right and Up+Down)");
        this.impossibleInputCheckBox.setFocusPainted(false);
        this.crosshairsCheckBox.setText("Show crosshairs mouse cursor for Zapper");
        this.crosshairsCheckBox.setFocusPainted(false);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.hideCursorCheckBox.setText("Hide cursor for mouse controllers");
        this.hideCursorCheckBox.setFocusPainted(false);
        this.hideInactiveMouseCheckBox.setText("Hide mouse cursor when inactive");
        this.hideInactiveMouseCheckBox.setFocusPainted(false);
        this.hideInactiveMouseCheckBox.setPreferredSize(null);
        this.hideFullscreenMouseCheckBox.setText("Hide mouse cursor in fullscreen mode");
        this.hideFullscreenMouseCheckBox.setFocusPainted(false);
        this.hideFullscreenMouseCheckBox.setPreferredSize(null);
        this.autofireResetButton.setMnemonic('D');
        this.autofireResetButton.setText("Defaults");
        this.autofireResetButton.setFocusPainted(false);
        this.autofireResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputSettingsDialog.this.autofireResetButtonActionPerformed(evt);
            }
        });
        this.exchangeGlassesCheckBox.setText("Exchange left and right Famicom 3D Glasses");
        this.exchangeGlassesCheckBox.setFocusPainted(false);
        this.disableKeyboardRewindTimeCheckBox.setText("Disable Rewind Time and High-speed for Keyboard devices");
        this.disableKeyboardRewindTimeCheckBox.setFocusPainted(false);
        this.highSpeedPanel.setBorder(BorderFactory.createTitledBorder("High-speed Rate"));
        this.speedUpButtonGroup.add(this.highSpeed200RadioButton);
        this.highSpeed200RadioButton.setText("200%");
        this.highSpeed200RadioButton.setFocusPainted(false);
        this.highSpeed200RadioButton.setMaximumSize(null);
        this.highSpeed200RadioButton.setMinimumSize(null);
        this.highSpeed200RadioButton.setPreferredSize(null);
        this.speedUpButtonGroup.add(this.highSpeed300RadioButton);
        this.highSpeed300RadioButton.setText("300%");
        this.highSpeed300RadioButton.setFocusPainted(false);
        this.highSpeed300RadioButton.setMaximumSize(null);
        this.highSpeed300RadioButton.setMinimumSize(null);
        this.highSpeed300RadioButton.setPreferredSize(null);
        this.speedUpButtonGroup.add(this.highSpeed400RadioButton);
        this.highSpeed400RadioButton.setText("400%");
        this.highSpeed400RadioButton.setFocusPainted(false);
        this.highSpeed400RadioButton.setMaximumSize(null);
        this.highSpeed400RadioButton.setMinimumSize(null);
        this.highSpeed400RadioButton.setPreferredSize(null);
        this.speedUpButtonGroup.add(this.highSpeedMaxRadioButton);
        this.highSpeedMaxRadioButton.setText("Max");
        this.highSpeedMaxRadioButton.setFocusPainted(false);
        this.highSpeedMaxRadioButton.setMaximumSize(null);
        this.highSpeedMaxRadioButton.setMinimumSize(null);
        this.highSpeedMaxRadioButton.setPreferredSize(null);
        GroupLayout highSpeedPanelLayout = new GroupLayout(this.highSpeedPanel);
        this.highSpeedPanel.setLayout(highSpeedPanelLayout);
        highSpeedPanelLayout.setHorizontalGroup(highSpeedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(highSpeedPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.highSpeed200RadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highSpeed300RadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highSpeed400RadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highSpeedMaxRadioButton, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        highSpeedPanelLayout.setVerticalGroup(highSpeedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(highSpeedPanelLayout.createSequentialGroup().addContainerGap().addGroup(highSpeedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.highSpeed200RadioButton, -2, -1, -2).addComponent(this.highSpeed300RadioButton, -2, -1, -2).addComponent(this.highSpeed400RadioButton, -2, -1, -2).addComponent(this.highSpeedMaxRadioButton, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.zapperLightDetectionMarginLabel.setText("Zapper light detection margin:");
        this.zapperLightDetectionMarginLabel.setMaximumSize(null);
        this.zapperLightDetectionMarginLabel.setMinimumSize(null);
        this.zapperLightDetectionMarginLabel.setPreferredSize(null);
        this.zapperLightDetectionMarginSpinner.setMaximumSize(null);
        this.zapperLightDetectionMarginSpinner.setMinimumSize(null);
        this.zapperLightDetectionMarginSpinner.setPreferredSize(null);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autofirePanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.autofireResetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.highSpeedPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.disableKeyboardRewindTimeCheckBox).addComponent(this.exchangeGlassesCheckBox).addComponent(this.hideFullscreenMouseCheckBox, -2, -1, -2).addComponent(this.hideInactiveMouseCheckBox, -2, -1, -2).addComponent(this.hideCursorCheckBox).addComponent(this.crosshairsCheckBox).addComponent(this.impossibleInputCheckBox).addGroup(layout.createSequentialGroup().addComponent(this.zapperLightDetectionMarginLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.zapperLightDetectionMarginSpinner, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.autofireResetButton, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.autofirePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highSpeedPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.impossibleInputCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.crosshairsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideCursorCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideInactiveMouseCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideFullscreenMouseCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exchangeGlassesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disableKeyboardRewindTimeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.zapperLightDetectionMarginLabel, -2, -1, -2).addComponent(this.zapperLightDetectionMarginSpinner, -2, -1, -2)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.autofireResetButton)).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void autofireResetButtonActionPerformed(ActionEvent evt) {
        this.loadFields(new Inputs());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Inputs inputs = AppPrefs.getInstance().getInputs();
        inputs.setAutofireRate(this.autofireSlider.getValue());
        inputs.setAllowImpossibleInput(this.impossibleInputCheckBox.isSelected());
        inputs.setShowZapperCrosshairs(this.crosshairsCheckBox.isSelected());
        inputs.setHideInactiveMouse(this.hideInactiveMouseCheckBox.isSelected());
        inputs.setHideFullscreenMouse(this.hideFullscreenMouseCheckBox.isSelected());
        inputs.setExchangeGlasses(this.exchangeGlassesCheckBox.isSelected());
        inputs.setDisableKeyboardRewindTime(this.disableKeyboardRewindTimeCheckBox.isSelected());
        inputs.setZapperLightDetectionMargin((Integer)this.zapperLightDetectionMarginSpinner.getValue());
        if (this.highSpeed200RadioButton.isSelected()) {
            inputs.setHighSpeedRate(200);
        } else if (this.highSpeed300RadioButton.isSelected()) {
            inputs.setHighSpeedRate(300);
        } else if (this.highSpeed400RadioButton.isSelected()) {
            inputs.setHighSpeedRate(400);
        } else {
            inputs.setHighSpeedRate(0);
        }
        this.closeDialog();
        InputUtil.handleSettingsChange();
        inputs.apply();
        AppPrefs.save();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }
}

