/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.nametables;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentListener;
import nintaco.App;
import nintaco.Machine;
import nintaco.MachineRunner;
import nintaco.PPU;
import nintaco.gui.ImagePanel;
import nintaco.gui.MaxLengthDocument;
import nintaco.gui.hexeditor.HexEditorFrame;
import nintaco.gui.nametables.NametablesPrefs;
import nintaco.palettes.PaletteUtil;
import nintaco.preferences.AppPrefs;
import nintaco.tv.TVSystem;
import nintaco.util.GuiUtil;
import nintaco.util.MathUtil;

public class NametablesFrame
extends JFrame {
    private final int[] screen = new int[245760];
    private final int[][] colors = new int[4][4];
    private final int[][][] attributes = new int[32][32][];
    private final DocumentListener scanlineListener = GuiUtil.createDocumentListener(this::scanlineUpdated);
    private volatile Machine machine;
    private volatile PPU ppu;
    private volatile int updateScanline;
    private volatile int framesPerUpdate;
    private volatile int frames;
    private volatile int scrollType;
    private volatile int scrollXValue;
    private volatile int scrollYValue;
    private volatile int scanlineValue;
    private volatile int mouseBoxX = -1;
    private volatile int mouseBoxY = -1;
    private volatile int selectionStartAddress = -1;
    private volatile int selectionEndAddress = -1;
    private volatile boolean updateOnSprite0Hit;
    private volatile boolean showTileGrid;
    private volatile boolean showAttributeGrid;
    private volatile boolean dragging;
    private int mouseX;
    private int mouseY;
    private int lastAddress = -1;
    private int lastTile = -1;
    private int sprite0Hits;
    private JLabel addressLabel;
    private JLabel addressNameLabel;
    private JButton closeButton;
    private JButton copyButton;
    private JButton copySpacedButton;
    private JButton defaultsButton;
    private JComboBox framesPerUpdateComboBox;
    private JLabel framesPerUpdateLabel;
    private JPanel nametablesPanel;
    private JButton resizeButton;
    private JLabel scanlineLabel;
    private JTextField scanlineTextField;
    private JComboBox scrollComboBox;
    private JLabel scrollLabel;
    private JButton searchButton;
    private JLabel selectionLabel;
    private JLabel selectionNameLabel;
    private JCheckBox showAttributeGridCheckBox;
    private JCheckBox showTileGridCheckBox;
    private JCheckBox sprite0CheckBox;
    private JLabel tileLabel;
    private JLabel tileNameLabel;

    public NametablesFrame(MachineRunner machineRunner) {
        this.initComponents();
        this.scanlineTextField.setDocument(new MaxLengthDocument(3, this.scanlineListener));
        this.loadFields();
        this.setMachineRunner(machineRunner);
        this.nametablesPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                NametablesFrame.this.mouseUpdated(e.getX(), e.getY(), false);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                NametablesFrame.this.mouseUpdated(e.getX(), e.getY(), true);
            }
        });
        this.nametablesPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NametablesFrame.this.mouseUpdated(e.getX(), e.getY(), false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                NametablesFrame.this.mouseUpdated(e.getX(), e.getY(), true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                NametablesFrame.this.mouseUpdated(e.getX(), e.getY(), false);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                NametablesFrame.this.mouseUpdated(e.getX(), e.getY(), false);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                NametablesFrame.this.mouseOutOfBounds();
            }
        });
        GuiUtil.makeMonospaced(this.addressLabel);
        GuiUtil.makeMonospaced(this.tileLabel);
        GuiUtil.makeMonospaced(this.selectionLabel);
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
        this.resizeButton.requestFocus();
    }

    private void mouseUpdated(int x, int y, boolean dragged) {
        PPU p;
        this.mouseX = x;
        this.mouseY = y;
        if (x < 0 || y < 0 || x >= 512 || y >= 480) {
            this.mouseOutOfBounds();
            return;
        }
        int address = (x >>= 3) < 32 ? (y < 30 ? 0x2000 | y << 5 | x : 0x2800 | y - 30 << 5 | x) : (y < 30 ? 0x2400 | y << 5 | x - 32 : 0x2C00 | (y >>= 3) - 30 << 5 | x - 32);
        if (this.lastAddress != address || dragged && !this.dragging) {
            if (dragged) {
                if (!this.dragging) {
                    this.dragging = true;
                    this.selectionStartAddress = this.selectionEndAddress = address;
                } else {
                    this.selectionEndAddress = MathUtil.clamp(address, this.selectionStartAddress & 0xFC00, this.selectionStartAddress & 0xFC00 | 0x3BF);
                }
            } else {
                this.dragging = false;
            }
            this.addressLabel.setText(String.format("$%04X", address));
            this.lastAddress = address;
            this.mouseBoxX = x << 3;
            this.mouseBoxY = y << 3;
            this.render();
        }
        if ((p = this.ppu) != null) {
            int tile = p.getBackgroundPatternTableAddress() >> 4 | p.peekVRAM(address);
            if (this.lastTile != tile) {
                this.tileLabel.setText(String.format("$%03X", tile));
                this.lastTile = tile;
            }
        } else if (this.lastTile != -1) {
            this.tileLabel.setText("-   ");
            this.lastTile = -1;
        }
        if (this.selectionStartAddress >= 0 && this.selectionEndAddress >= 0) {
            int start = this.selectionStartAddress;
            int end = this.selectionEndAddress;
            if (start > end) {
                int t = start;
                start = end;
                end = t;
            }
            this.selectionLabel.setText(String.format("$%04X-$%04X", start, end));
        } else {
            this.selectionLabel.setText("-");
        }
    }

    private void mouseOutOfBounds() {
        this.mouseX = -1;
        this.mouseY = -1;
        if (this.mouseBoxX >= 0 || this.mouseBoxY >= 0) {
            this.mouseBoxX = -1;
            this.mouseBoxY = -1;
            this.render();
        }
        if (this.lastAddress != -1) {
            this.addressLabel.setText("-    ");
            this.lastAddress = -1;
        }
        if (this.lastTile != -1) {
            this.tileLabel.setText("-   ");
            this.lastTile = -1;
        }
    }

    private void setScanlineTextFieldText(String text) {
        this.scanlineTextField.getDocument().removeDocumentListener(this.scanlineListener);
        this.scanlineTextField.setText(text);
        this.scanlineTextField.getDocument().addDocumentListener(this.scanlineListener);
    }

    private void scanlineUpdated() {
        this.updateScanline = 0;
        try {
            int value = Integer.parseInt(this.scanlineTextField.getText().trim());
            Machine m = this.machine;
            if (value >= -1 && value < (m == null ? TVSystem.PAL.getScanlineCount() : m.getMapper().getTVSystem().getScanlineCount()) - 1) {
                this.updateScanline = value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void destroy() {
        this.saveFields();
        this.dispose();
    }

    private void closeFrame() {
        App.destroyNametablesFrame();
    }

    private void loadFields() {
        this.loadFields(AppPrefs.getInstance().getNametablesPrefs());
    }

    private void loadFields(NametablesPrefs prefs) {
        this.updateScanline = prefs.getUpdateScanline();
        this.framesPerUpdate = prefs.getFramesPerUpdate();
        this.scrollType = prefs.getScrollType();
        this.updateOnSprite0Hit = prefs.isUpdateOnSprite0Hit();
        this.showTileGrid = prefs.isShowTileGrid();
        this.showAttributeGrid = prefs.isShowAttributeGrid();
        this.setScanlineTextFieldText(Integer.toString(this.updateScanline));
        this.scrollComboBox.setSelectedIndex(this.scrollType);
        this.framesPerUpdateComboBox.setSelectedItem(Integer.toString(this.framesPerUpdate));
        this.sprite0CheckBox.setSelected(this.updateOnSprite0Hit);
        this.showTileGridCheckBox.setSelected(this.showTileGrid);
        this.showAttributeGridCheckBox.setSelected(this.showAttributeGrid);
        this.updateScanlineComponents();
    }

    private void saveFields() {
        NametablesPrefs prefs = AppPrefs.getInstance().getNametablesPrefs();
        prefs.setUpdateScanline(this.updateScanline);
        prefs.setScrollType(this.scrollType);
        prefs.setFramesPerUpdate(this.framesPerUpdate);
        prefs.setUpdateOnSprite0Hit(this.updateOnSprite0Hit);
        prefs.setShowTileGrid(this.showTileGrid);
        prefs.setShowAttributeGrid(this.showAttributeGrid);
        AppPrefs.save();
    }

    private void updateScanlineComponents() {
        boolean enabled = !this.sprite0CheckBox.isSelected();
        this.scanlineLabel.setEnabled(enabled);
        this.scanlineTextField.setEnabled(enabled);
    }

    public final void setMachineRunner(MachineRunner machineRunner) {
        this.machine = machineRunner != null ? machineRunner.getMachine() : null;
        if (this.machine == null) {
            this.ppu = null;
            ((ImagePanel)this.nametablesPanel).clearScreen();
        } else {
            this.ppu = this.machine.getPPU();
            if (machineRunner.isPaused()) {
                this.update(this.machine, this.ppu, this.updateScanline);
            }
        }
    }

    public synchronized void update(int scanline) {
        PPU p = this.ppu;
        Machine m = this.machine;
        if (m == null || p == null) {
            return;
        }
        if (this.updateOnSprite0Hit) {
            if (!p.isSprite0Hit()) {
                this.sprite0Hits = 0;
                return;
            }
            if (++this.sprite0Hits != 2) {
                return;
            }
        } else if (scanline != this.updateScanline) {
            return;
        }
        if (--this.frames > 0) {
            return;
        }
        this.frames = this.framesPerUpdate;
        this.update(m, p, scanline);
    }

    private void update(Machine m, PPU p, int scanline) {
        int[] palette = PaletteUtil.getExtendedPalette(m);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.colors[i][j] = palette[p.getPaletteRamValue(i << 2 | j)];
            }
        }
        int backgroundPatternTableAddress = p.getBackgroundPatternTableAddress();
        this.drawNametable(p, 8192, backgroundPatternTableAddress, this.screen, 0, 0);
        this.drawNametable(p, 9216, backgroundPatternTableAddress, this.screen, 256, 0);
        this.drawNametable(p, 10240, backgroundPatternTableAddress, this.screen, 0, 240);
        this.drawNametable(p, 11264, backgroundPatternTableAddress, this.screen, 256, 240);
        this.scrollXValue = p.getScrollX();
        this.scrollYValue = p.getScrollY();
        this.scanlineValue = scanline;
        this.render();
    }

    private synchronized void render() {
        int x;
        int i;
        int x2;
        int offset;
        int y;
        ImagePanel imagePanel = (ImagePanel)this.nametablesPanel;
        int[] scr = imagePanel.getScreen();
        System.arraycopy(this.screen, 0, scr, 0, scr.length);
        if (this.showTileGrid) {
            for (y = 0; y < 480; y += 2) {
                offset = y << 9;
                for (x2 = 7; x2 < 512; x2 += 8) {
                    scr[offset | x2] = 7417656;
                }
            }
            for (y = 7; y < 480; y += 8) {
                offset = y << 9;
                for (x2 = 0; x2 < 512; x2 += 2) {
                    scr[offset | x2] = 7417656;
                }
            }
        }
        if (this.showAttributeGrid) {
            for (y = 1; y < 480; y += 2) {
                offset = y << 9;
                for (x2 = 15; x2 < 512; x2 += 16) {
                    scr[offset | x2] = 3693744;
                }
            }
            for (y = 15; y < 480; y += 16) {
                offset = y << 9;
                for (x2 = 1; x2 < 512; x2 += 2) {
                    scr[offset | x2] = 3693744;
                }
            }
        }
        switch (this.scrollType) {
            case 1: 
            case 2: {
                int scrollX = this.scrollXValue;
                int scrollY = this.scrollYValue;
                if (this.scrollType == 2) {
                    scrollY -= this.scanlineValue + 1;
                }
                if (scrollY >= 480) {
                    scrollY -= 480;
                } else if (scrollY < 0) {
                    scrollY += 480;
                }
                int row = scrollY << 9;
                for (i = 0; i < 512; ++i) {
                    int n = row | i;
                    scr[n] = scr[n] ^ 0xFFFFFF;
                }
                for (i = 0; i < 480; ++i) {
                    int n = i << 9 | scrollX;
                    scr[n] = scr[n] ^ 0xFFFFFF;
                }
                break;
            }
            case 3: {
                int x0 = this.scrollXValue;
                int y0 = this.scrollYValue - this.scanlineValue - 1;
                if (y0 >= 480) {
                    y0 -= 480;
                } else if (y0 < 0) {
                    y0 += 480;
                }
                int x1 = x0 + 255 & 0x1FF;
                int y1 = y0 + 239;
                if (y1 >= 480) {
                    y1 -= 480;
                } else if (y1 < 0) {
                    y1 += 480;
                }
                int row0 = y0 << 9;
                int row1 = y1 << 9;
                int x22 = x1 + 1 & 0x1FF;
                int i2 = x0;
                while (i2 != x22) {
                    int n = row0 | i2;
                    scr[n] = scr[n] ^ 0xFFFFFF;
                    int n2 = row1 | i2;
                    scr[n2] = scr[n2] ^ 0xFFFFFF;
                    i2 = i2 + 1 & 0x1FF;
                }
                if (++y0 == 480) {
                    y0 = 0;
                }
                while (y0 != y1) {
                    int i9 = y0 << 9;
                    int n = i9 | x0;
                    scr[n] = scr[n] ^ 0xFFFFFF;
                    int n3 = i9 | x1;
                    scr[n3] = scr[n3] ^ 0xFFFFFF;
                    if (++y0 != 480) continue;
                    y0 = 0;
                }
                break;
            }
        }
        int start = this.selectionStartAddress;
        int end = this.selectionEndAddress;
        if (end < start) {
            int t = start;
            start = end;
            end = t;
        }
        if (start >= 0 && end >= 0) {
            int offset2 = ((start & 0x800) == 0 ? 0 : 122880) + ((start & 0x400) >> 2);
            for (i = start; i <= end; ++i) {
                int j;
                int o7;
                int j2;
                x = i & 0x1F;
                int o = offset2 + ((i & 0x3E0) << 7) + ((i & 0x1F) << 3);
                int y0 = 0;
                int y7 = 7;
                if (i - 32 < start) {
                    y0 = 1;
                    for (j2 = 7; j2 >= 0; --j2) {
                        int n = o + j2;
                        scr[n] = scr[n] ^ 0xFFFFFF;
                    }
                } else if (x > 0 && i - 33 < start) {
                    int n = o;
                    scr[n] = scr[n] ^ 0xFFFFFF;
                }
                if (i + 32 > end) {
                    y7 = 6;
                    o7 = o | 0xE00;
                    for (j = 7; j >= 0; --j) {
                        int n = o7 + j;
                        scr[n] = scr[n] ^ 0xFFFFFF;
                    }
                } else if (x < 31 && i + 33 > end) {
                    int n = o + 3591;
                    scr[n] = scr[n] ^ 0xFFFFFF;
                }
                if (x == 0 || i == start) {
                    for (j2 = y7; j2 >= y0; --j2) {
                        int n = o + (j2 << 9);
                        scr[n] = scr[n] ^ 0xFFFFFF;
                    }
                }
                if (x != 31 && i != end) continue;
                o7 = o | 7;
                for (j = y7; j >= y0; --j) {
                    int n = o7 + (j << 9);
                    scr[n] = scr[n] ^ 0xFFFFFF;
                }
            }
        }
        if (this.mouseBoxX >= 0 && this.mouseBoxY >= 0 && !this.dragging) {
            for (int y2 = 0; y2 < 8; ++y2) {
                int offset3;
                int n = offset3 = (this.mouseBoxY | y2) << 9 | this.mouseBoxX;
                scr[n] = scr[n] ^ 0xFFFFFF;
                int n4 = offset3 + 7;
                scr[n4] = scr[n4] ^ 0xFFFFFF;
            }
            int offset0 = this.mouseBoxY << 9 | this.mouseBoxX;
            int offset7 = (this.mouseBoxY | 7) << 9 | this.mouseBoxX;
            for (x = 1; x < 7; ++x) {
                int n = offset0 | x;
                scr[n] = scr[n] ^ 0xFFFFFF;
                int n5 = offset7 | x;
                scr[n5] = scr[n5] ^ 0xFFFFFF;
            }
        }
        imagePanel.render();
    }

    private void drawNametable(PPU ppu, int address, int backgroundPatternTableAddress, int[] screen, int screenX, int screenY) {
        int tileX;
        int tileY;
        int attributeAddress = address | 0x3C0;
        for (tileY = 0; tileY < 32; tileY += 4) {
            tileX = 0;
            while (tileX < 32) {
                int attribute = ppu.peekVRAM(attributeAddress);
                for (int y = 0; y < 4; y += 2) {
                    int yOffset = tileY | y;
                    for (int x = 0; x < 4; x += 2) {
                        int xOffset = tileX | x;
                        int[] cols = this.colors[attribute & 3];
                        attribute >>= 2;
                        for (int i = 0; i < 2; ++i) {
                            for (int j = 0; j < 2; ++j) {
                                this.attributes[yOffset | i][xOffset | j] = cols;
                            }
                        }
                    }
                }
                tileX += 4;
                ++attributeAddress;
            }
        }
        for (tileY = 0; tileY < 30; ++tileY) {
            int yOffset = screenY + (tileY << 3);
            tileX = 0;
            while (tileX < 32) {
                int xOffset = screenX + (tileX << 3);
                int[] cols = this.attributes[tileY][tileX];
                int address0 = backgroundPatternTableAddress | ppu.peekVRAM(address) << 4;
                int address1 = address0 + 8;
                for (int y = 0; y < 8; ++y) {
                    int yOff = yOffset + y << 9;
                    int b0 = ppu.peekVRAM(address0 + y);
                    int b1 = ppu.peekVRAM(address1 + y);
                    for (int x = 0; x < 8; ++x) {
                        int shift = 7 - x;
                        screen[yOff + xOffset + x] = cols[(b1 >> shift & 1) << 1 | b0 >> shift & 1];
                    }
                }
                ++tileX;
                ++address;
            }
        }
    }

    private String createCopyString(boolean spaced) {
        PPU p = this.ppu;
        int start = this.selectionStartAddress;
        int end = this.selectionEndAddress;
        if (p == null || start < 0 || end < 0) {
            return null;
        }
        if (end < start) {
            int t = start;
            start = end;
            end = t;
        }
        StringBuilder sb = new StringBuilder();
        for (int address = start; address <= end; ++address) {
            if (spaced && sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(String.format("%02X", p.peekVRAM(address)));
        }
        return sb.toString();
    }

    private void initComponents() {
        this.nametablesPanel = new ImagePanel(512, 480);
        this.resizeButton = new JButton();
        this.scanlineLabel = new JLabel();
        this.scanlineTextField = new JTextField();
        this.framesPerUpdateLabel = new JLabel();
        this.framesPerUpdateComboBox = new JComboBox();
        this.addressNameLabel = new JLabel();
        this.addressLabel = new JLabel();
        this.tileNameLabel = new JLabel();
        this.tileLabel = new JLabel();
        this.scrollLabel = new JLabel();
        this.scrollComboBox = new JComboBox();
        this.sprite0CheckBox = new JCheckBox();
        this.closeButton = new JButton();
        this.showTileGridCheckBox = new JCheckBox();
        this.showAttributeGridCheckBox = new JCheckBox();
        this.selectionNameLabel = new JLabel();
        this.selectionLabel = new JLabel();
        this.copyButton = new JButton();
        this.searchButton = new JButton();
        this.copySpacedButton = new JButton();
        this.defaultsButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Nametables");
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NametablesFrame.this.formWindowClosing(evt);
            }
        });
        this.nametablesPanel.setMaximumSize(null);
        GroupLayout nametablesPanelLayout = new GroupLayout(this.nametablesPanel);
        this.nametablesPanel.setLayout(nametablesPanelLayout);
        nametablesPanelLayout.setHorizontalGroup(nametablesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        nametablesPanelLayout.setVerticalGroup(nametablesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.resizeButton.setMnemonic('R');
        this.resizeButton.setText("Resize");
        this.resizeButton.setFocusPainted(false);
        this.resizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NametablesFrame.this.resizeButtonActionPerformed(evt);
            }
        });
        this.scanlineLabel.setText("Update on scanline:");
        this.scanlineLabel.setMaximumSize(null);
        this.scanlineLabel.setMinimumSize(null);
        this.scanlineLabel.setPreferredSize(null);
        this.scanlineTextField.setColumns(4);
        this.scanlineTextField.setText("0");
        this.scanlineTextField.setMaximumSize(null);
        this.scanlineTextField.setMinimumSize(null);
        this.scanlineTextField.setPreferredSize(null);
        this.scanlineTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NametablesFrame.this.scanlineTextFieldActionPerformed(evt);
            }
        });
        this.framesPerUpdateLabel.setText("Frames per update:");
        this.framesPerUpdateLabel.setMaximumSize(null);
        this.framesPerUpdateLabel.setMinimumSize(null);
        this.framesPerUpdateLabel.setPreferredSize(null);
        this.framesPerUpdateComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "5", "15", "30", "60"}));
        this.framesPerUpdateComboBox.setFocusable(false);
        this.framesPerUpdateComboBox.setMaximumSize(null);
        this.framesPerUpdateComboBox.setMinimumSize(null);
        this.framesPerUpdateComboBox.setPreferredSize(null);
        this.framesPerUpdateComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NametablesFrame.this.framesPerUpdateComboBoxActionPerformed(evt);
            }
        });
        this.addressNameLabel.setText("Address:");
        this.addressNameLabel.setMaximumSize(null);
        this.addressNameLabel.setMinimumSize(null);
        this.addressNameLabel.setPreferredSize(null);
        this.addressLabel.setText("-    ");
        this.addressLabel.setMaximumSize(null);
        this.addressLabel.setMinimumSize(null);
        this.addressLabel.setPreferredSize(null);
        this.tileNameLabel.setText("Tile:");
        this.tileNameLabel.setMaximumSize(null);
        this.tileNameLabel.setMinimumSize(null);
        this.tileNameLabel.setPreferredSize(null);
        this.tileLabel.setText("-   ");
        this.tileLabel.setMaximumSize(null);
        this.tileLabel.setMinimumSize(null);
        this.tileLabel.setPreferredSize(null);
        this.scrollLabel.setText("Scroll:");
        this.scrollLabel.setMaximumSize(null);
        this.scrollLabel.setMinimumSize(null);
        this.scrollLabel.setPreferredSize(null);
        this.scrollComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Disabled", "Absolute crosshairs", "Offset crosshairs", "Window"}));
        this.scrollComboBox.setFocusable(false);
        this.scrollComboBox.setMaximumSize(null);
        this.scrollComboBox.setMinimumSize(null);
        this.scrollComboBox.setName("");
        this.scrollComboBox.setPreferredSize(null);
        this.scrollComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NametablesFrame.this.scrollComboBoxActionPerformed(evt);
            }
        });
        this.sprite0CheckBox.setText("Update on sprite 0 hit");
        this.sprite0CheckBox.setFocusPainted(false);
        this.sprite0CheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NametablesFrame.this.sprite0CheckBoxActionPerformed(evt);
            }
        });
        this.closeButton.setMnemonic('C');
        this.closeButton.setText(" Close ");
        this.closeButton.setFocusPainted(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NametablesFrame.this.closeButtonActionPerformed(evt);
            }
        });
        this.showTileGridCheckBox.setText("Show tile grid");
        this.showTileGridCheckBox.setFocusPainted(false);
        this.showTileGridCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NametablesFrame.this.showTileGridCheckBoxActionPerformed(evt);
            }
        });
        this.showAttributeGridCheckBox.setText("Show attribute grid");
        this.showAttributeGridCheckBox.setFocusPainted(false);
        this.showAttributeGridCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NametablesFrame.this.showAttributeGridCheckBoxActionPerformed(evt);
            }
        });
        this.selectionNameLabel.setText("Selection:");
        this.selectionLabel.setText("-");
        this.copyButton.setMnemonic('C');
        this.copyButton.setText("Copy");
        this.copyButton.setFocusPainted(false);
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NametablesFrame.this.copyButtonActionPerformed(evt);
            }
        });
        this.searchButton.setMnemonic('S');
        this.searchButton.setText("Search");
        this.searchButton.setFocusPainted(false);
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NametablesFrame.this.searchButtonActionPerformed(evt);
            }
        });
        this.copySpacedButton.setMnemonic('d');
        this.copySpacedButton.setText("Copy Spaced");
        this.copySpacedButton.setFocusPainted(false);
        this.copySpacedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NametablesFrame.this.copySpacedButtonActionPerformed(evt);
            }
        });
        this.defaultsButton.setMnemonic('D');
        this.defaultsButton.setText("Defaults");
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NametablesFrame.this.defaultsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addressNameLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addressLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.tileNameLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tileLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.selectionNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectionLabel)).addGroup(layout.createSequentialGroup().addComponent(this.scrollLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollComboBox, -2, -1, -2).addGap(19, 19, 19).addComponent(this.showTileGridCheckBox).addGap(18, 18, 18).addComponent(this.showAttributeGridCheckBox)).addGroup(layout.createSequentialGroup().addComponent(this.framesPerUpdateLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.framesPerUpdateComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.sprite0CheckBox).addGap(15, 15, 15).addComponent(this.scanlineLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanlineTextField, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.nametablesPanel, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.defaultsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copySpacedButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resizeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.nametablesPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addressNameLabel, -2, -1, -2).addComponent(this.addressLabel, -2, -1, -2).addComponent(this.tileNameLabel, -2, -1, -2).addComponent(this.tileLabel, -2, -1, -2).addComponent(this.selectionNameLabel).addComponent(this.selectionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.scrollLabel, -2, -1, -2).addComponent(this.scrollComboBox, -2, -1, -2).addComponent(this.showTileGridCheckBox).addComponent(this.showAttributeGridCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.framesPerUpdateLabel, -2, -1, -2).addComponent(this.framesPerUpdateComboBox, -2, -1, -2).addComponent(this.scanlineLabel, -2, -1, -2).addComponent(this.scanlineTextField, -2, -1, -2).addComponent(this.sprite0CheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resizeButton).addComponent(this.closeButton).addComponent(this.copyButton).addComponent(this.searchButton).addComponent(this.copySpacedButton).addComponent(this.defaultsButton)).addContainerGap()));
        layout.linkSize(1, this.closeButton, this.copyButton, this.copySpacedButton, this.resizeButton, this.searchButton);
    }

    private void resizeButtonActionPerformed(ActionEvent evt) {
        this.pack();
    }

    private void framesPerUpdateComboBoxActionPerformed(ActionEvent evt) {
        Object item = this.framesPerUpdateComboBox.getSelectedItem();
        if (item != null) {
            try {
                this.framesPerUpdate = Integer.parseInt(item.toString().trim());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void scanlineTextFieldActionPerformed(ActionEvent evt) {
        this.requestFocusInWindow();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void scrollComboBoxActionPerformed(ActionEvent evt) {
        this.scrollType = this.scrollComboBox.getSelectedIndex();
        this.render();
    }

    private void sprite0CheckBoxActionPerformed(ActionEvent evt) {
        this.updateOnSprite0Hit = this.sprite0CheckBox.isSelected();
        this.updateScanlineComponents();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.closeFrame();
    }

    private void showTileGridCheckBoxActionPerformed(ActionEvent evt) {
        this.showTileGrid = this.showTileGridCheckBox.isSelected();
        this.render();
    }

    private void showAttributeGridCheckBoxActionPerformed(ActionEvent evt) {
        this.showAttributeGrid = this.showAttributeGridCheckBox.isSelected();
        this.render();
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        App.createHexEditorFrame();
        HexEditorFrame frame = App.getHexEditorFrame();
        frame.setDataSource(2);
        frame.getHexEditorView().showSearchDialog(false, this.createCopyString(true));
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        GuiUtil.setClipboardString(this.createCopyString(false));
    }

    private void copySpacedButtonActionPerformed(ActionEvent evt) {
        GuiUtil.setClipboardString(this.createCopyString(true));
    }

    private void defaultsButtonActionPerformed(ActionEvent evt) {
        this.loadFields(new NametablesPrefs());
    }

    public static interface ScrollType {
        public static final int Disabled = 0;
        public static final int AbsoluteCrosshairs = 1;
        public static final int OffsetCrosshairs = 2;
        public static final int Window = 3;
    }
}

