/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.netplay.client;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentListener;
import nintaco.App;
import nintaco.gui.netplay.client.ClientStatus;
import nintaco.gui.netplay.client.NetplayClientPrefs;
import nintaco.palettes.PalettePPU;
import nintaco.palettes.PaletteUtil;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class NetplayClientFrame
extends JFrame {
    private static final Color GREEN = new Color(32768);
    private static final Color YELLOW = new Color(0x808000);
    private DocumentListener hostListener;
    private DocumentListener portListener;
    private DocumentListener passwordListener;
    private char[] password;
    private JLabel activityLabel;
    private JScrollPane activityScrollPane;
    private JTextArea activityTextArea;
    private JButton clearActivityButton;
    private JToggleButton connectButton;
    private JComboBox controllerComboBox;
    private JLabel controllerLabel;
    private JButton hideWindowButton;
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JCheckBox passwordCheckBox;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JComboBox playerComboBox;
    private JLabel playerLabel;
    private JLabel portLabel;
    private JTextField portTextField;
    private JLabel statusLabel;

    public NetplayClientFrame() {
        this.initComponents();
        this.initTextFields();
        this.loadFields();
        this.setClientStatus(ClientStatus.OFFLINE);
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    private void initTextFields() {
        GuiUtil.addLoseFocusListener((Window)this, this.hostTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.portTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.passwordField);
        this.hostListener = GuiUtil.createDocumentListener(this::enableComponents);
        this.hostTextField.getDocument().addDocumentListener(this.hostListener);
        this.portListener = GuiUtil.createDocumentListener(this::enableComponents);
        this.portTextField.getDocument().addDocumentListener(this.portListener);
        this.passwordListener = GuiUtil.createDocumentListener(() -> {
            this.password = this.passwordField.getPassword();
        });
        this.passwordField.getDocument().addDocumentListener(this.passwordListener);
        GuiUtil.makeMonospaced(this.activityTextArea);
        this.activityTextArea.setCursor(new Cursor(2));
        GuiUtil.enableAutoscroll(this.activityTextArea);
    }

    public void setPassword(char[] password) {
        this.password = Arrays.copyOf(password, password.length);
        this.setPassword(password.length);
    }

    private void setPassword(int passwordLength) {
        StringBuilder sb = new StringBuilder();
        for (int i = passwordLength - 1; i >= 0; --i) {
            sb.append('*');
        }
        this.setPassword(sb.toString());
    }

    private void setPassword(String password) {
        this.passwordField.getDocument().removeDocumentListener(this.passwordListener);
        this.passwordField.setText(password);
        this.passwordField.getDocument().addDocumentListener(this.passwordListener);
    }

    private void setPort(int port) {
        this.setPort(Integer.toString(port));
    }

    private void setPort(String port) {
        this.portTextField.getDocument().removeDocumentListener(this.portListener);
        this.portTextField.setText(port);
        this.portTextField.getDocument().addDocumentListener(this.portListener);
    }

    private void setHost(String host) {
        this.hostTextField.getDocument().removeDocumentListener(this.hostListener);
        this.hostTextField.setText(host);
        this.hostTextField.getDocument().addDocumentListener(this.hostListener);
    }

    public void destroy() {
        App.stopClient();
        this.saveFields();
        if (PaletteUtil.setPalettePPU(PalettePPU._2C02)) {
            App.getImageFrame().createPaletteMenu();
        }
        this.dispose();
    }

    private void closeFrame() {
        if (this.connectButton.isSelected()) {
            this.setVisible(false);
        } else {
            App.destroyNetplayClientFrame();
        }
    }

    public void loadFields() {
        NetplayClientPrefs prefs = AppPrefs.getInstance().getNetplayClientPrefs();
        this.setHost(prefs.getHost());
        this.controllerComboBox.setSelectedIndex(prefs.getInputDevice());
        this.passwordCheckBox.setSelected(prefs.isRememberPassword());
        if (prefs.isRememberPassword()) {
            this.setPassword(prefs.getPasswordLength());
        }
        this.playerComboBox.setSelectedIndex(prefs.getPlayer());
        this.setPort(prefs.getPort());
    }

    private void saveFields() {
        NetplayClientPrefs prefs = AppPrefs.getInstance().getNetplayClientPrefs();
        prefs.setHost(this.hostTextField.getText());
        prefs.setInputDevice(Integer.max(0, this.controllerComboBox.getSelectedIndex()));
        prefs.setPlayer(Integer.max(0, this.playerComboBox.getSelectedIndex()));
        prefs.setPort(StringUtil.parseInt(this.portTextField.getText(), 8888));
        prefs.setRememberPassword(this.passwordCheckBox.isSelected());
        if (this.password != null) {
            prefs.setPasswordLength(this.passwordCheckBox.isSelected() ? this.password.length : 0);
        }
        AppPrefs.save();
    }

    private void enableComponents() {
        boolean clientDown = !this.connectButton.isSelected();
        this.hostLabel.setEnabled(clientDown);
        this.hostTextField.setEnabled(clientDown);
        this.portLabel.setEnabled(clientDown);
        this.portTextField.setEnabled(clientDown);
        this.passwordLabel.setEnabled(clientDown);
        this.passwordField.setEnabled(clientDown);
        this.passwordCheckBox.setEnabled(clientDown);
        this.playerLabel.setEnabled(clientDown);
        this.playerComboBox.setEnabled(clientDown);
        boolean controllerEnabled = clientDown && this.playerComboBox.getSelectedIndex() != 4;
        this.controllerLabel.setEnabled(controllerEnabled);
        this.controllerComboBox.setEnabled(controllerEnabled);
        this.connectButton.setEnabled(!clientDown || !StringUtil.isBlank(this.hostTextField.getText()) && StringUtil.parseInt(this.portTextField.getText(), -1) >= 0);
        this.connectButton.setText(clientDown ? "Connect" : "Stop");
    }

    public void addActivity(String activity, Object ... params) {
        if (EventQueue.isDispatchThread()) {
            this.activityTextArea.append(String.format(activity, params) + "\n");
        } else {
            EventQueue.invokeLater(() -> this.addActivity(activity, params));
        }
    }

    public void setClientStatus(ClientStatus status) {
        if (EventQueue.isDispatchThread()) {
            this.connectButton.setSelected(status != ClientStatus.OFFLINE);
            switch (status) {
                case OFFLINE: {
                    this.statusLabel.setBackground(Color.RED);
                    this.statusLabel.setText("<html><b>OFFLINE</b></html>");
                    break;
                }
                case CONNECTING: {
                    this.statusLabel.setBackground(YELLOW);
                    this.statusLabel.setText("<html><b>CONNECTING</b></html>");
                    break;
                }
                case ONLINE: {
                    this.statusLabel.setBackground(GREEN);
                    this.statusLabel.setText("<html><b>ONLINE</b></html>");
                }
            }
            this.enableComponents();
        } else {
            EventQueue.invokeLater(() -> this.setClientStatus(status));
        }
    }

    private void initComponents() {
        this.hostLabel = new JLabel();
        this.hostTextField = new JTextField();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.playerLabel = new JLabel();
        this.playerComboBox = new JComboBox();
        this.controllerLabel = new JLabel();
        this.controllerComboBox = new JComboBox();
        this.activityLabel = new JLabel();
        this.connectButton = new JToggleButton();
        this.clearActivityButton = new JButton();
        this.hideWindowButton = new JButton();
        this.passwordLabel = new JLabel();
        this.passwordCheckBox = new JCheckBox();
        this.passwordField = new JPasswordField();
        this.activityScrollPane = new JScrollPane();
        this.activityTextArea = new JTextArea();
        this.statusLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("Connect to Server");
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NetplayClientFrame.this.formWindowClosing(evt);
            }
        });
        this.hostLabel.setText("Host:");
        this.hostLabel.setMaximumSize(null);
        this.hostLabel.setMinimumSize(null);
        this.hostLabel.setPreferredSize(null);
        this.hostTextField.setColumns(50);
        this.hostTextField.setMaximumSize(null);
        this.hostTextField.setMinimumSize(null);
        this.portLabel.setText("Port:");
        this.portLabel.setMaximumSize(null);
        this.portLabel.setMinimumSize(null);
        this.portLabel.setPreferredSize(null);
        this.portTextField.setColumns(6);
        this.portTextField.setMaximumSize(null);
        this.portTextField.setMinimumSize(null);
        this.portTextField.setPreferredSize(null);
        this.playerLabel.setText("Player:");
        this.playerLabel.setMaximumSize(null);
        this.playerLabel.setMinimumSize(null);
        this.playerLabel.setPreferredSize(null);
        this.playerComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "Spectator"}));
        this.playerComboBox.setFocusable(false);
        this.playerComboBox.setMaximumSize(null);
        this.playerComboBox.setMinimumSize(null);
        this.playerComboBox.setPreferredSize(null);
        this.playerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetplayClientFrame.this.playerComboBoxActionPerformed(evt);
            }
        });
        this.controllerLabel.setText("Controller:");
        this.controllerLabel.setMaximumSize(null);
        this.controllerLabel.setMinimumSize(null);
        this.controllerLabel.setPreferredSize(null);
        this.controllerComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Gamepad 1", "Gamepad 2", "Gamepad 3", "Gamepad 4"}));
        this.controllerComboBox.setFocusable(false);
        this.controllerComboBox.setMaximumSize(null);
        this.controllerComboBox.setMinimumSize(null);
        this.controllerComboBox.setPreferredSize(null);
        this.activityLabel.setText("Activity");
        this.activityLabel.setMaximumSize(null);
        this.activityLabel.setMinimumSize(null);
        this.activityLabel.setPreferredSize(null);
        this.connectButton.setMnemonic('C');
        this.connectButton.setText("Connect");
        this.connectButton.setFocusPainted(false);
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetplayClientFrame.this.connectButtonActionPerformed(evt);
            }
        });
        this.clearActivityButton.setMnemonic('A');
        this.clearActivityButton.setText("Clear Activity");
        this.clearActivityButton.setFocusPainted(false);
        this.clearActivityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetplayClientFrame.this.clearActivityButtonActionPerformed(evt);
            }
        });
        this.hideWindowButton.setMnemonic('H');
        this.hideWindowButton.setText("Hide Window");
        this.hideWindowButton.setFocusPainted(false);
        this.hideWindowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetplayClientFrame.this.hideWindowButtonActionPerformed(evt);
            }
        });
        this.passwordLabel.setText("Password (optional):");
        this.passwordCheckBox.setText("Remember password");
        this.passwordCheckBox.setFocusPainted(false);
        this.passwordField.setColumns(16);
        this.passwordField.setMaximumSize(null);
        this.passwordField.setMinimumSize(null);
        this.activityScrollPane.setVerticalScrollBarPolicy(22);
        this.activityScrollPane.setMaximumSize(null);
        this.activityScrollPane.setMinimumSize(null);
        this.activityScrollPane.setPreferredSize(null);
        this.activityTextArea.setEditable(false);
        this.activityTextArea.setColumns(60);
        this.activityTextArea.setRows(8);
        this.activityTextArea.setMaximumSize(null);
        this.activityTextArea.setMinimumSize(null);
        this.activityTextArea.setPreferredSize(null);
        this.activityScrollPane.setViewportView(this.activityTextArea);
        this.statusLabel.setForeground(Color.white);
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setText(" ");
        this.statusLabel.setBorder(new SoftBevelBorder(1));
        this.statusLabel.setHorizontalTextPosition(0);
        this.statusLabel.setOpaque(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.statusLabel).addGap(18, 18, Short.MAX_VALUE).addComponent(this.connectButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearActivityButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideWindowButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostLabel, -2, -1, -2).addComponent(this.portLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostTextField, -1, -1, Short.MAX_VALUE).addComponent(this.portTextField, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.playerLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.playerComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.controllerLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.controllerComboBox, -2, -1, -2)).addComponent(this.activityLabel, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.passwordLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordField, -2, -1, -2).addGap(9, 9, 9).addComponent(this.passwordCheckBox)).addComponent(this.activityScrollPane, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.clearActivityButton, this.connectButton, this.hideWindowButton, this.statusLabel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostLabel, -2, -1, -2).addComponent(this.hostTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portLabel, -2, -1, -2).addComponent(this.portTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordCheckBox).addComponent(this.passwordField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.playerLabel, -2, -1, -2).addComponent(this.playerComboBox, -2, -1, -2).addComponent(this.controllerLabel, -2, -1, -2).addComponent(this.controllerComboBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.activityLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.activityScrollPane, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.connectButton).addComponent(this.clearActivityButton).addComponent(this.hideWindowButton).addComponent(this.statusLabel)).addContainerGap()));
        layout.linkSize(1, this.clearActivityButton, this.connectButton, this.hideWindowButton, this.statusLabel);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void connectButtonActionPerformed(ActionEvent evt) {
        if (this.connectButton.isSelected()) {
            this.saveFields();
            App.startClient(this.password);
            if (!this.passwordCheckBox.isSelected()) {
                this.setPassword("");
                this.password = null;
            }
            this.setTitle("Netplay Client Controls");
        } else {
            App.stopClient();
            this.setTitle("Connect to Server");
        }
        this.enableComponents();
    }

    private void clearActivityButtonActionPerformed(ActionEvent evt) {
        this.activityTextArea.setText("");
    }

    private void hideWindowButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void playerComboBoxActionPerformed(ActionEvent evt) {
        this.enableComponents();
    }
}

