/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.ramwatch;

import java.io.Serializable;
import nintaco.gui.ramsearch.RamSearchTableRow;

public class RamWatchRow
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int address;
    private int wordSizeIndex;
    private int valueFormat;
    private String description = " ";
    private boolean separator;
    private transient int value;
    private transient String addressStr;
    private transient String valueStr;

    public RamWatchRow() {
    }

    public RamWatchRow(RamWatchRow row) {
        this.set(row);
    }

    public final void set(RamWatchRow row) {
        this.address = row.address;
        this.value = row.value;
        this.description = row.description;
        this.separator = row.separator;
        this.addressStr = row.addressStr;
        this.valueStr = row.valueStr;
        this.wordSizeIndex = row.wordSizeIndex;
        this.valueFormat = row.valueFormat;
    }

    public boolean isSeparator() {
        return this.separator;
    }

    public void setSeparator(boolean separator) {
        this.separator = separator;
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
        this.addressStr = null;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.valueStr = null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAddressStr() {
        if (this.addressStr == null) {
            this.addressStr = String.format("%04X", this.address);
        }
        return this.addressStr;
    }

    public String getValueStr() {
        if (this.valueStr == null) {
            this.valueStr = RamSearchTableRow.formatValue(this.value, this.valueFormat, this.wordSizeIndex, RamSearchTableRow.HEX_FORMATS[this.wordSizeIndex]);
        }
        return this.valueStr;
    }

    public int getValueFormat() {
        return this.valueFormat;
    }

    public void setValueFormat(int valueFormat) {
        this.valueFormat = valueFormat;
        this.valueStr = null;
    }

    public final void setWordSizeIndex(int wordSizeIndex) {
        this.wordSizeIndex = wordSizeIndex;
        this.valueStr = null;
    }

    public int getWordSizeIndex() {
        return this.wordSizeIndex;
    }
}

