/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.rob;

import nintaco.gui.rob.RobController;
import nintaco.mappers.Mapper;

public class GyromiteController
extends RobController {
    private static final long serialVersionUID = 0L;
    private static final int VERTICAL_STEPS = 12;
    private static final int HORIZONTAL_STEPS = 16;
    private static final int GRASP_STEPS = 8;
    private static final float ACCELERATION = 0.1f;
    private static final float VERTICAL_DELTA = 0.16666667f;
    private static final float HORIZONTAL_DELTA = 0.0625f;
    private static final float GRASP_DELTA = 0.125f;
    private int heldGyro = -1;
    private float fallingVelocity;

    public GyromiteController() {
        this.state.game = 1;
        this.state.reset();
    }

    @Override
    public int pollButtons(int buttons, Mapper mapper) {
        if (this.state.aButtonY == 4.0f) {
            buttons |= 0x100;
        }
        if (this.state.bButtonY == 4.0f) {
            buttons |= 0x200;
        }
        return buttons;
    }

    @Override
    protected void initMoveUp() {
        if (this.state.handsY == 0.0f) {
            this.executingCommand = null;
        } else {
            this.counter = 12;
        }
    }

    @Override
    protected void initMoveDown() {
        if (this.state.handsY == 4.0f || this.state.handsX == 2.0f && this.state.handsY == 2.0f) {
            this.executingCommand = null;
            return;
        }
        if (this.state.handsOpen == 1.0f) {
            this.counter = 12;
            return;
        }
        boolean unheldGyro = this.containsUnheldGyro(this.state.handsX);
        if (!unheldGyro) {
            this.counter = 12;
            return;
        }
        if (this.heldGyro >= 0 || this.state.handsY == 2.0f || this.state.handsX == 2.0f && this.state.handsY == 0.0f) {
            this.executingCommand = null;
            return;
        }
        this.counter = 12;
    }

    @Override
    protected void initMoveLeft() {
        if (this.state.handsX == -2.0f || this.containsUnheldGyro(this.state.handsX - 1.0f) && (this.heldGyro >= 0 && this.state.handsY >= 2.0f || this.state.handsY == 4.0f && this.state.handsX < 2.0f) || (this.state.handsY == 4.0f || this.state.handsX == 2.0f && this.state.handsY == 2.0f) && (this.heldGyro >= 0 || this.state.handsOpen == 1.0f && this.containsUnheldGyro(this.state.handsX))) {
            this.executingCommand = null;
            return;
        }
        this.counter = 16;
    }

    @Override
    protected void initMoveRight() {
        if (this.state.handsX == 2.0f) {
            this.executingCommand = null;
            return;
        }
        int sourceGyro = this.getUnheldGyro(this.state.handsX);
        if (sourceGyro >= 0 && this.state.handsOpen == 1.0f && this.state.handsY == this.state.pieces[sourceGyro][1]) {
            this.executingCommand = null;
            return;
        }
        int targetGyro = this.getUnheldGyro(this.state.handsX + 1.0f);
        if (targetGyro >= 0) {
            if (this.heldGyro >= 0) {
                if (this.state.pieces[this.heldGyro][1] >= this.state.pieces[targetGyro][1] - 2.0f) {
                    this.executingCommand = null;
                    return;
                }
            } else if (this.state.handsY >= this.state.pieces[targetGyro][1]) {
                this.executingCommand = null;
                return;
            }
        } else if (this.heldGyro >= 0) {
            if (this.state.handsY == 4.0f || this.state.handsX == 1.0f && this.state.handsY != 0.0f) {
                this.executingCommand = null;
                return;
            }
        } else if (this.state.handsX == 1.0f && this.state.handsY == 4.0f) {
            this.executingCommand = null;
            return;
        }
        this.counter = 16;
    }

    @Override
    protected void initOpenHands() {
        if (this.state.handsOpen == 1.0f || this.heldGyro >= 0 && this.containsUnheldGyro(this.state.handsX)) {
            this.executingCommand = null;
        } else {
            this.counter = 8;
        }
    }

    @Override
    protected void initCloseHands() {
        if (this.state.handsOpen == 0.0f) {
            this.executingCommand = null;
        } else {
            this.counter = 8;
        }
    }

    @Override
    protected void executeMoveUp() {
        this.state.handsY -= 0.16666667f;
        if (--this.counter == 0) {
            this.state.handsY = Math.round(this.state.handsY);
            this.executingCommand = null;
        }
        if (this.heldGyro >= 0) {
            this.state.pieces[this.heldGyro][1] = this.state.handsY;
            if (this.state.handsX == 0.0f) {
                this.state.aButtonY = Math.max(3.0f, Math.min(this.state.aButtonY, this.state.handsY));
            } else if (this.state.handsX == 1.0f) {
                this.state.bButtonY = Math.max(3.0f, Math.min(this.state.bButtonY, this.state.handsY));
            }
        }
    }

    @Override
    protected void executeMoveDown() {
        this.state.handsY += 0.16666667f;
        if (--this.counter == 0) {
            this.state.handsY = Math.round(this.state.handsY);
            this.executingCommand = null;
        }
        if (this.heldGyro >= 0) {
            this.state.pieces[this.heldGyro][1] = this.state.handsY;
            if (this.state.handsX == 0.0f) {
                this.state.aButtonY = Math.min(4.0f, Math.max(this.state.aButtonY, this.state.handsY));
            } else if (this.state.handsX == 1.0f) {
                this.state.bButtonY = Math.min(4.0f, Math.max(this.state.bButtonY, this.state.handsY));
            }
        }
    }

    @Override
    protected void executeMoveLeft() {
        this.state.handsX -= 0.0625f;
        if (--this.counter == 0) {
            this.state.handsX = Math.round(this.state.handsX);
            this.executingCommand = null;
        }
        if (this.heldGyro >= 0) {
            this.state.pieces[this.heldGyro][0] = this.state.handsX;
        }
    }

    @Override
    protected void executeMoveRight() {
        this.state.handsX += 0.0625f;
        if (--this.counter == 0) {
            this.state.handsX = Math.round(this.state.handsX);
            this.executingCommand = null;
        }
        if (this.heldGyro >= 0) {
            this.state.pieces[this.heldGyro][0] = this.state.handsX;
        }
    }

    @Override
    protected void executeOpenHands() {
        if (this.heldGyro >= 0) {
            float ground;
            this.fallingVelocity += 0.1f;
            float[] fArray = this.state.pieces[this.heldGyro];
            fArray[1] = fArray[1] + this.fallingVelocity;
            float f = ground = this.state.handsX < 2.0f ? 4.0f : 2.0f;
            if (this.state.pieces[this.heldGyro][1] >= ground) {
                this.state.pieces[this.heldGyro][1] = ground;
            }
            if (this.state.handsX == 0.0f && this.state.pieces[this.heldGyro][1] > this.state.aButtonY) {
                this.state.aButtonY = this.state.pieces[this.heldGyro][1];
            }
            if (this.state.handsX == 1.0f && this.state.pieces[this.heldGyro][1] > this.state.bButtonY) {
                this.state.bButtonY = this.state.pieces[this.heldGyro][1];
            }
            if (this.state.pieces[this.heldGyro][1] >= ground) {
                this.heldGyro = -1;
            }
        }
        if (this.counter > 0) {
            this.state.handsOpen += 0.125f;
            --this.counter;
        } else if (this.heldGyro < 0) {
            this.fallingVelocity = 0.0f;
            this.state.handsOpen = 1.0f;
            this.executingCommand = null;
        }
    }

    @Override
    protected void executeCloseHands() {
        this.state.handsOpen -= 0.125f;
        if (--this.counter == 0) {
            this.state.handsOpen = 0.0f;
            int index = this.getUnheldGyro(this.state.handsX);
            if (index >= 0 && this.state.pieces[index][1] == this.state.handsY) {
                this.heldGyro = index;
            }
            this.executingCommand = null;
        }
    }

    public int getUnheldGyro(float x) {
        for (int i = 2; i >= 0; --i) {
            if (i == this.heldGyro || this.state.pieces[i][0] != x) continue;
            return i;
        }
        return -1;
    }

    private boolean containsUnheldGyro(float x) {
        return this.getUnheldGyro(x) >= 0;
    }
}

