/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.spritesaver;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import nintaco.App;
import nintaco.Machine;
import nintaco.PPU;
import nintaco.files.FileUtil;
import nintaco.gui.spritesaver.SpriteSaverAppPrefs;
import nintaco.gui.spritesaver.SpriteSaverGamePrefs;
import nintaco.gui.spritesaver.SpriteSearcher;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.tv.TVSystem;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class SpriteSaverFrame
extends JFrame {
    private final SpriteSearcher spriteSearcher = new SpriteSearcher();
    private int totalSpritesFound;
    private int fileIndex;
    private String fileFormat;
    private String outputDir;
    private String filePrefix;
    private int sprite0Hits;
    private volatile Machine machine;
    private volatile PPU ppu;
    private volatile boolean running;
    private volatile int updateScanline;
    private volatile int minOccurrences;
    private volatile int withinSeconds;
    private volatile int edgeMargin;
    private volatile int imageScale;
    private volatile boolean updateOnSprite0Hit;
    private volatile boolean saving;
    private JButton browseButton;
    private JButton defaultsButton;
    private JLabel edgeMarginLabel;
    private JTextField edgeMarginTextField;
    private JComboBox fileFormatComboBox;
    private JLabel fileFormatLabel;
    private JLabel filePrefixLabel;
    private JTextField filePrefixTextField;
    private JLabel imageScaleLabel;
    private JTextField imageScaleTextField;
    private JLabel minOccurrencesLabel;
    private JTextField minOccurrencesTextField;
    private JLabel outputDirLabel;
    private JTextField outputDirTextField;
    private JLabel scanlineLabel;
    private JTextField scanlineTextField;
    private JCheckBox sprite0CheckBox;
    private JLabel startIndexLabel;
    private JTextField startIndexTextField;
    private JToggleButton startToggleButton;
    private JLabel statusLabel;
    private JLabel withinSecondsLabel;
    private JTextField withinSecondsTextField;

    public SpriteSaverFrame(Machine machine) {
        this.initComponents();
        this.initFileFormatComboBox();
        this.initLoseFocusListeners();
        this.loadFields();
        this.setMachine(machine);
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    private void initFileFormatComboBox() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String format : GuiUtil.getWritableImageFileFormats()) {
            model.addElement(format);
        }
        this.fileFormatComboBox.setModel(model);
    }

    private void initLoseFocusListeners() {
        this.outputDirTextField.addActionListener(e -> {
            this.updateStartIndex();
            this.requestFocusInWindow();
        });
        this.filePrefixTextField.addActionListener(e -> {
            this.updateStartIndex();
            this.requestFocusInWindow();
        });
        GuiUtil.addLoseFocusListener((Window)this, this.startIndexTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.minOccurrencesTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.scanlineTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.withinSecondsTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.edgeMarginTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.imageScaleTextField);
    }

    public void destroy() {
        this.saveFields();
        this.dispose();
    }

    private void closeFrame() {
        App.destroySpriteSaverFrame();
    }

    private void loadFields() {
        this.loadFields(AppPrefs.getInstance().getSpriteSaverAppPrefs());
    }

    private void loadFields(SpriteSaverAppPrefs prefs) {
        this.outputDir = AppPrefs.getInstance().getPaths().getSpritesDir();
        this.fileFormat = prefs.getFileFormat();
        this.imageScale = prefs.getImageScale();
        this.outputDirTextField.setText(this.outputDir);
        this.fileFormatComboBox.setSelectedItem(this.fileFormat);
        this.imageScaleTextField.setText(Integer.toString(this.imageScale));
        this.updateStartIndex();
    }

    private void saveFields() {
        if (this.running) {
            this.setRunning(false);
            this.flush();
        }
        GuiUtil.invokeAndWait(this::captureFields);
        this.saveGamePrefs();
        SpriteSaverAppPrefs prefs = AppPrefs.getInstance().getSpriteSaverAppPrefs();
        AppPrefs.getInstance().getPaths().setSpritesDir(this.outputDir);
        prefs.setFileFormat(this.fileFormat);
        prefs.setImageScale(this.imageScale);
        AppPrefs.save();
    }

    private void loadGamePrefs() {
        this.loadGamePrefs(GamePrefs.getInstance().getSpriteSaverGamePrefs());
    }

    private void loadGamePrefs(SpriteSaverGamePrefs prefs) {
        this.filePrefix = StringUtil.isBlank(prefs.getFilePrefix()) ? FileUtil.getFileNameWithoutExtension(App.getEntryFileName()) : prefs.getFilePrefix();
        this.updateScanline = prefs.getUpdateScanline();
        this.updateOnSprite0Hit = prefs.isUpdateOnSprite0Hit();
        this.edgeMargin = prefs.getEdgeMargin();
        this.minOccurrences = prefs.getMinOccurrences();
        this.withinSeconds = prefs.getWithinSeconds();
        EventQueue.invokeLater(() -> {
            this.filePrefixTextField.setText(this.filePrefix);
            this.scanlineTextField.setText(Integer.toString(this.updateScanline));
            this.sprite0CheckBox.setSelected(this.updateOnSprite0Hit);
            this.edgeMarginTextField.setText(Integer.toString(this.edgeMargin));
            this.minOccurrencesTextField.setText(Integer.toString(this.minOccurrences));
            this.withinSecondsTextField.setText(Integer.toString(this.withinSeconds));
            this.updateScanlineComponents();
            this.updateStartIndex();
        });
    }

    private void saveGamePrefs() {
        SpriteSaverGamePrefs prefs = GamePrefs.getInstance().getSpriteSaverGamePrefs();
        prefs.setFilePrefix(this.filePrefix);
        prefs.setUpdateScanline(this.updateScanline);
        prefs.setUpdateOnSprite0Hit(this.updateOnSprite0Hit);
        prefs.setEdgeMargin(this.edgeMargin);
        prefs.setMinOccurrences(this.minOccurrences);
        prefs.setWithinSeconds(this.withinSeconds);
        GamePrefs.save();
    }

    private void enableComponents() {
        this.enableComponents(this.ppu, this.saving);
    }

    private void enableComponents(PPU ppu, boolean saving) {
        boolean run = ppu != null && this.running;
        this.startToggleButton.setEnabled(ppu != null && !saving);
        this.startToggleButton.setSelected(run);
        this.startToggleButton.setText(run ? "Stop" : "Start");
        boolean enabled = ppu != null && !run;
        this.outputDirLabel.setEnabled(enabled);
        this.outputDirTextField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        this.filePrefixLabel.setEnabled(enabled);
        this.filePrefixTextField.setEnabled(enabled);
        this.startIndexLabel.setEnabled(enabled);
        this.startIndexTextField.setEnabled(enabled);
        this.fileFormatLabel.setEnabled(enabled);
        this.fileFormatComboBox.setEnabled(enabled);
        this.minOccurrencesLabel.setEnabled(enabled);
        this.minOccurrencesTextField.setEnabled(enabled);
        this.withinSecondsLabel.setEnabled(enabled);
        this.withinSecondsTextField.setEnabled(enabled);
        this.edgeMarginLabel.setEnabled(enabled);
        this.edgeMarginTextField.setEnabled(enabled);
        this.imageScaleLabel.setEnabled(enabled);
        this.imageScaleTextField.setEnabled(enabled);
        this.sprite0CheckBox.setEnabled(enabled);
        this.scanlineLabel.setEnabled(enabled);
        this.scanlineTextField.setEnabled(enabled);
        this.defaultsButton.setEnabled(enabled);
        this.statusLabel.setText(" ");
        if (ppu == null) {
            this.filePrefixTextField.setText("");
        }
    }

    private void setRunning(boolean running) {
        if (EventQueue.isDispatchThread()) {
            this.running = running;
            this.enableComponents();
        } else {
            EventQueue.invokeLater(() -> this.setRunning(running));
        }
    }

    private void updateScanlineComponents() {
        boolean enabled = !this.sprite0CheckBox.isSelected();
        this.scanlineLabel.setEnabled(enabled);
        this.scanlineTextField.setEnabled(enabled);
    }

    public final void setMachine(Machine machine) {
        if (this.running) {
            this.flush();
        }
        this.setRunning(false);
        this.machine = machine;
        if (machine == null) {
            this.ppu = null;
        } else {
            this.ppu = machine.getPPU();
            this.loadGamePrefs();
        }
        EventQueue.invokeLater(() -> {
            this.enableComponents();
            this.totalSpritesFound = 0;
        });
    }

    public void update(int scanline) {
        int spritesFound;
        if (!this.running) {
            return;
        }
        PPU pp = this.ppu;
        if (pp == null) {
            return;
        }
        if (this.updateOnSprite0Hit) {
            if (!pp.isSprite0Hit()) {
                this.sprite0Hits = 0;
                return;
            }
            if (++this.sprite0Hits != 2) {
                return;
            }
        } else if (scanline != this.updateScanline) {
            return;
        }
        if ((spritesFound = this.spriteSearcher.search(pp)) > 0) {
            this.handleSpritesFound(spritesFound, false);
        }
    }

    private void handleSpritesFound(int spritesFound, boolean total) {
        if (EventQueue.isDispatchThread()) {
            if (total) {
                this.totalSpritesFound = spritesFound;
                this.statusLabel.setText(String.format("Saved %d sprite%s.", this.totalSpritesFound, this.totalSpritesFound == 1 ? "" : "s"));
            } else {
                this.totalSpritesFound += spritesFound;
                this.statusLabel.setText(String.format("Sprites found: %d", this.totalSpritesFound));
            }
        } else {
            EventQueue.invokeLater(() -> this.handleSpritesFound(spritesFound, total));
        }
    }

    private void updateStartIndex() {
        if (EventQueue.isDispatchThread()) {
            this.filePrefix = this.filePrefixTextField.getText().trim();
            this.outputDir = this.outputDirTextField.getText().trim();
            String prefix = this.filePrefix;
            String outDir = this.outputDir;
            if (!StringUtil.isBlank(prefix) && !StringUtil.isBlank(outDir)) {
                new Thread(() -> {
                    int index = FileUtil.getSuggestedStartIndex(prefix, outDir);
                    EventQueue.invokeLater(() -> {
                        this.fileIndex = index;
                        this.startIndexTextField.setText(Integer.toString(this.fileIndex));
                    });
                }).start();
            }
        } else {
            EventQueue.invokeLater(this::updateStartIndex);
        }
    }

    private void captureFields() {
        this.outputDir = this.outputDirTextField.getText().trim();
        this.filePrefix = this.filePrefixTextField.getText().trim();
        this.fileIndex = GuiUtil.parseTextField(this.startIndexTextField, 0, 0, 999);
        Object format = this.fileFormatComboBox.getSelectedItem();
        this.fileFormat = format == null ? "png" : format.toString();
        this.updateOnSprite0Hit = this.sprite0CheckBox.isSelected();
        Machine m = this.machine;
        this.updateScanline = GuiUtil.parseTextField(this.scanlineTextField, 0, -1, (m == null ? TVSystem.PAL.getScanlineCount() : m.getMapper().getTVSystem().getScanlineCount()) - 1);
        this.minOccurrences = GuiUtil.parseTextField(this.minOccurrencesTextField, 3, 1, 999);
        this.withinSeconds = GuiUtil.parseTextField(this.withinSecondsTextField, 10, 1, 300);
        this.edgeMargin = GuiUtil.parseTextField(this.edgeMarginTextField, 16, 0, 119);
        this.imageScale = GuiUtil.parseTextField(this.imageScaleTextField, 1, 1, 16);
    }

    private synchronized void flush() {
        Machine m = this.machine;
        PPU pp = this.ppu;
        String outDir = this.outputDir;
        String prefix = this.filePrefix;
        String format = this.fileFormat;
        int scale = this.imageScale;
        int startIndex = this.fileIndex;
        if (m == null || pp == null) {
            return;
        }
        this.saving = true;
        EventQueue.invokeLater(() -> this.statusLabel.setText("Saving sprites..."));
        this.enableComponents(pp, this.saving);
        new Thread(() -> {
            this.handleSpritesFound(this.spriteSearcher.save(m, outDir, prefix, format, scale, startIndex), true);
            this.saving = false;
            this.updateStartIndex();
            this.enableComponents(pp, this.saving);
        }).start();
    }

    private void initComponents() {
        this.outputDirLabel = new JLabel();
        this.outputDirTextField = new JTextField();
        this.browseButton = new JButton();
        this.filePrefixLabel = new JLabel();
        this.filePrefixTextField = new JTextField();
        this.startIndexLabel = new JLabel();
        this.startIndexTextField = new JTextField();
        this.fileFormatLabel = new JLabel();
        this.fileFormatComboBox = new JComboBox();
        this.sprite0CheckBox = new JCheckBox();
        this.scanlineLabel = new JLabel();
        this.scanlineTextField = new JTextField();
        this.edgeMarginLabel = new JLabel();
        this.edgeMarginTextField = new JTextField();
        this.minOccurrencesLabel = new JLabel();
        this.minOccurrencesTextField = new JTextField();
        this.withinSecondsLabel = new JLabel();
        this.withinSecondsTextField = new JTextField();
        this.startToggleButton = new JToggleButton();
        this.imageScaleLabel = new JLabel();
        this.imageScaleTextField = new JTextField();
        this.statusLabel = new JLabel();
        this.defaultsButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Sprite Saver");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SpriteSaverFrame.this.formWindowClosing(evt);
            }
        });
        this.outputDirLabel.setText("Output directory:");
        this.outputDirLabel.setMaximumSize(null);
        this.outputDirLabel.setMinimumSize(null);
        this.outputDirLabel.setPreferredSize(null);
        this.outputDirTextField.setMaximumSize(null);
        this.outputDirTextField.setMinimumSize(null);
        this.outputDirTextField.setPreferredSize(null);
        this.browseButton.setMnemonic('B');
        this.browseButton.setText("Browse");
        this.browseButton.setFocusPainted(false);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpriteSaverFrame.this.browseButtonActionPerformed(evt);
            }
        });
        this.filePrefixLabel.setText("File prefix:");
        this.filePrefixTextField.setMaximumSize(null);
        this.filePrefixTextField.setMinimumSize(null);
        this.filePrefixTextField.setPreferredSize(null);
        this.startIndexLabel.setText("Start index:");
        this.startIndexLabel.setMaximumSize(null);
        this.startIndexLabel.setMinimumSize(null);
        this.startIndexLabel.setPreferredSize(null);
        this.startIndexTextField.setColumns(5);
        this.startIndexTextField.setText("0");
        this.startIndexTextField.setMaximumSize(null);
        this.startIndexTextField.setMinimumSize(null);
        this.fileFormatLabel.setText("File format:");
        this.fileFormatLabel.setMaximumSize(null);
        this.fileFormatLabel.setMinimumSize(null);
        this.fileFormatLabel.setPreferredSize(null);
        this.fileFormatComboBox.setFocusable(false);
        this.fileFormatComboBox.setMaximumSize(null);
        this.fileFormatComboBox.setMinimumSize(null);
        this.fileFormatComboBox.setPreferredSize(null);
        this.sprite0CheckBox.setText("Update on sprite 0 hit");
        this.sprite0CheckBox.setFocusPainted(false);
        this.sprite0CheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpriteSaverFrame.this.sprite0CheckBoxActionPerformed(evt);
            }
        });
        this.scanlineLabel.setText("Update on scanline:");
        this.scanlineLabel.setMaximumSize(null);
        this.scanlineLabel.setMinimumSize(null);
        this.scanlineLabel.setPreferredSize(null);
        this.scanlineTextField.setColumns(4);
        this.scanlineTextField.setText("0");
        this.scanlineTextField.setMaximumSize(null);
        this.scanlineTextField.setMinimumSize(null);
        this.scanlineTextField.setPreferredSize(null);
        this.edgeMarginLabel.setText("Edge margin:");
        this.edgeMarginLabel.setMaximumSize(null);
        this.edgeMarginLabel.setMinimumSize(null);
        this.edgeMarginLabel.setPreferredSize(null);
        this.edgeMarginTextField.setColumns(4);
        this.edgeMarginTextField.setText("16");
        this.edgeMarginTextField.setToolTipText("Sprites around the edges of the frame are ignored.");
        this.edgeMarginTextField.setMaximumSize(null);
        this.edgeMarginTextField.setMinimumSize(null);
        this.edgeMarginTextField.setPreferredSize(null);
        this.minOccurrencesLabel.setText("Min occurrences:");
        this.minOccurrencesLabel.setMaximumSize(null);
        this.minOccurrencesLabel.setMinimumSize(null);
        this.minOccurrencesLabel.setPreferredSize(null);
        this.minOccurrencesTextField.setColumns(4);
        this.minOccurrencesTextField.setText("3");
        this.minOccurrencesTextField.setToolTipText("The meta-sprite must appear at least this many times and within the specified number of seconds before it is saved.");
        this.minOccurrencesTextField.setMaximumSize(null);
        this.minOccurrencesTextField.setMinimumSize(null);
        this.minOccurrencesTextField.setPreferredSize(null);
        this.withinSecondsLabel.setText("Within seconds:");
        this.withinSecondsLabel.setMaximumSize(null);
        this.withinSecondsLabel.setMinimumSize(null);
        this.withinSecondsLabel.setPreferredSize(null);
        this.withinSecondsTextField.setColumns(4);
        this.withinSecondsTextField.setText("10");
        this.withinSecondsTextField.setToolTipText("Within this time window, the meta-sprite must appear for the specified minimum number of occurances before it is saved.");
        this.withinSecondsTextField.setMaximumSize(null);
        this.withinSecondsTextField.setMinimumSize(null);
        this.withinSecondsTextField.setPreferredSize(null);
        this.startToggleButton.setText("Start");
        this.startToggleButton.setEnabled(false);
        this.startToggleButton.setFocusPainted(false);
        this.startToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpriteSaverFrame.this.startToggleButtonActionPerformed(evt);
            }
        });
        this.imageScaleLabel.setText("Image scale:");
        this.imageScaleTextField.setColumns(4);
        this.imageScaleTextField.setText("1");
        this.statusLabel.setText(" ");
        this.defaultsButton.setMnemonic('D');
        this.defaultsButton.setText("Defaults");
        this.defaultsButton.setFocusPainted(false);
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpriteSaverFrame.this.defaultsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.outputDirLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputDirTextField, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.filePrefixLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filePrefixTextField, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.startIndexLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startIndexTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.fileFormatLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileFormatComboBox, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.statusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.defaultsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startToggleButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sprite0CheckBox).addGap(18, 18, 18).addComponent(this.scanlineLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanlineTextField, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.minOccurrencesLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minOccurrencesTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.withinSecondsLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.withinSecondsTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.edgeMarginLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.edgeMarginTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.imageScaleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.imageScaleTextField, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.browseButton, this.startToggleButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputDirLabel, -2, -1, -2).addComponent(this.outputDirTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filePrefixLabel).addComponent(this.filePrefixTextField, -2, -1, -2).addComponent(this.startIndexLabel, -2, -1, -2).addComponent(this.startIndexTextField, -2, -1, -2).addComponent(this.fileFormatLabel, -2, -1, -2).addComponent(this.fileFormatComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.edgeMarginLabel, -2, -1, -2).addComponent(this.edgeMarginTextField, -2, -1, -2).addComponent(this.minOccurrencesLabel, -2, -1, -2).addComponent(this.minOccurrencesTextField, -2, -1, -2).addComponent(this.withinSecondsLabel, -2, -1, -2).addComponent(this.withinSecondsTextField, -2, -1, -2).addComponent(this.imageScaleLabel).addComponent(this.imageScaleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sprite0CheckBox).addComponent(this.scanlineLabel, -2, -1, -2).addComponent(this.scanlineTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startToggleButton).addComponent(this.statusLabel).addComponent(this.defaultsButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void startToggleButtonActionPerformed(ActionEvent evt) {
        if (this.startToggleButton.isSelected()) {
            this.statusLabel.setText(" ");
            this.totalSpritesFound = 0;
            this.saveFields();
            this.spriteSearcher.setMinOccurrences(this.minOccurrences);
            this.spriteSearcher.setSweepSeconds(this.withinSeconds);
            this.spriteSearcher.setEdgeMargin(this.edgeMargin);
            this.setRunning(true);
        } else {
            this.flush();
            this.setRunning(false);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File file;
        File dir;
        String outDir = this.outputDirTextField.getText().trim();
        if (StringUtil.isBlank(outDir)) {
            outDir = this.outputDir;
        }
        if ((dir = FileUtil.findExistingParent(outDir)) == null) {
            dir = new File(".");
        }
        JFileChooser chooser = GuiUtil.createFileChooser("Choose Output Directory", dir, new FileFilter[0]);
        chooser.setFileSelectionMode(1);
        if (GuiUtil.showOpenDialog(this, chooser) == 0 && (file = chooser.getSelectedFile()) != null) {
            this.outputDir = file.getPath();
            this.outputDirTextField.setText(this.outputDir);
            this.updateStartIndex();
        }
    }

    private void sprite0CheckBoxActionPerformed(ActionEvent evt) {
        this.updateOnSprite0Hit = this.sprite0CheckBox.isSelected();
        this.updateScanlineComponents();
    }

    private void defaultsButtonActionPerformed(ActionEvent evt) {
        this.loadFields(new SpriteSaverAppPrefs());
        this.loadGamePrefs(new SpriteSaverGamePrefs());
    }
}

