/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.table;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import nintaco.gui.ToolTipsTable;
import nintaco.util.GuiUtil;

public class TableDialog
extends JDialog {
    protected JButton cancelButton;
    protected JButton clearButton;
    protected JButton deleteButton;
    protected JButton editButton;
    protected JButton exportButton;
    protected JButton importButton;
    protected JButton newButton;
    protected JButton okButton;
    protected JScrollPane scrollPane;
    protected JTable table;

    public TableDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.table.getSelectionModel().addListSelectionListener(e -> this.selectionChanged());
        this.initialize();
        this.selectionChanged();
        this.updateClearButton();
        this.getRootPane().setDefaultButton(this.okButton);
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    protected void closeDialog() {
        this.dispose();
    }

    protected void initialize() {
    }

    protected void updateClearButton() {
        this.clearButton.setEnabled(this.table.getModel().getRowCount() > 0);
    }

    protected void setSelectedRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.table.getModel().getRowCount()) {
            int index = this.table.convertRowIndexToView(rowIndex);
            this.table.setRowSelectionInterval(index, index);
        }
    }

    protected int getSelectedRowIndex() {
        int index = this.table.getSelectedRow();
        return index >= 0 && index < this.table.getModel().getRowCount() ? this.table.convertRowIndexToModel(index) : index;
    }

    protected void selectionChanged() {
        int index = this.getSelectedRowIndex();
        boolean enabled = index >= 0 && index < this.table.getModel().getRowCount();
        this.editButton.setEnabled(enabled);
        this.deleteButton.setEnabled(enabled);
    }

    protected void newButtonPressed() {
    }

    protected void editButtonPressed(int index) {
    }

    protected void deleteButtonPressed(int index) {
    }

    protected void importButtonPressed() {
    }

    protected void exportButtonPressed() {
    }

    protected void clearButtonPressed() {
    }

    protected void cancelButtonPressed() {
    }

    protected void okButtonPressed() {
    }

    protected void handleShown() {
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.table = new ToolTipsTable();
        this.newButton = new JButton();
        this.editButton = new JButton();
        this.deleteButton = new JButton();
        this.importButton = new JButton();
        this.exportButton = new JButton();
        this.clearButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                TableDialog.this.formComponentShown(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TableDialog.this.formWindowClosing(evt);
            }
        });
        this.scrollPane.setMaximumSize(null);
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.table.setAutoResizeMode(3);
        this.table.setSelectionMode(0);
        this.scrollPane.setViewportView(this.table);
        this.newButton.setMnemonic('N');
        this.newButton.setText("New...");
        this.newButton.setFocusPainted(false);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableDialog.this.newButtonActionPerformed(evt);
            }
        });
        this.editButton.setMnemonic('E');
        this.editButton.setText("Edit...");
        this.editButton.setFocusPainted(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableDialog.this.editButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setMnemonic('D');
        this.deleteButton.setText("Delete");
        this.deleteButton.setFocusPainted(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        this.importButton.setMnemonic('I');
        this.importButton.setText("Import...");
        this.importButton.setFocusPainted(false);
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableDialog.this.importButtonActionPerformed(evt);
            }
        });
        this.exportButton.setMnemonic('x');
        this.exportButton.setText("Export...");
        this.exportButton.setFocusPainted(false);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableDialog.this.exportButtonActionPerformed(evt);
            }
        });
        this.clearButton.setMnemonic('r');
        this.clearButton.setText("Clear");
        this.clearButton.setFocusPainted(false);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableDialog.this.clearButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.newButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.clearButton, this.deleteButton, this.editButton, this.exportButton, this.importButton, this.newButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newButton).addComponent(this.editButton).addComponent(this.deleteButton).addComponent(this.importButton).addComponent(this.exportButton).addComponent(this.clearButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        this.newButtonPressed();
        this.updateClearButton();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        int index = this.getSelectedRowIndex();
        if (index >= 0 && index < this.table.getModel().getRowCount()) {
            this.editButtonPressed(index);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int index = this.getSelectedRowIndex();
        if (index >= 0 && index < this.table.getModel().getRowCount()) {
            this.deleteButtonPressed(index);
        }
        this.updateClearButton();
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        this.importButtonPressed();
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        this.exportButtonPressed();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.clearButtonPressed();
        this.updateClearButton();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancelButtonPressed();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.okButtonPressed();
    }

    private void formComponentShown(ComponentEvent evt) {
        this.handleShown();
    }
}

