/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input;

import java.io.Serializable;
import nintaco.input.ButtonID;
import nintaco.input.DeviceDescriptor;
import nintaco.util.CollectionsUtil;

public class ButtonMapping
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected final int inputDevice;
    protected final int buttonIndex;
    protected final ButtonID[] buttonIds;
    protected transient String buttonName;
    protected transient String description;

    public ButtonMapping(ButtonMapping buttonMapping) {
        this(buttonMapping.getInputDevice(), buttonMapping.getButtonIndex(), buttonMapping.getButtonIds());
    }

    public ButtonMapping(int inputDevice, int buttonIndex) {
        this(inputDevice, buttonIndex, new ButtonID[]{new ButtonID()});
    }

    public ButtonMapping(int inputDevice, int buttonIndex, ButtonID[] buttonIds) {
        this.inputDevice = inputDevice;
        this.buttonIndex = buttonIndex;
        this.buttonIds = buttonIds;
    }

    public ButtonMapping copy() {
        return new ButtonMapping(this);
    }

    public int getInputDevice() {
        return this.inputDevice;
    }

    public String getButtonName() {
        if (this.buttonName == null) {
            this.buttonName = DeviceDescriptor.getDescriptor(this.inputDevice).getButtonName(this.buttonIndex);
        }
        return this.buttonName;
    }

    public int getButtonIndex() {
        return this.buttonIndex;
    }

    public ButtonID[] getButtonIds() {
        return this.buttonIds;
    }

    public String getDescription() {
        if (this.description == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.buttonIds.length; ++i) {
                if (i > 0) {
                    sb.append(" + ");
                }
                sb.append(this.buttonIds[i]);
            }
            this.description = sb.toString();
        }
        return this.description;
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object obj) {
        ButtonMapping b = (ButtonMapping)obj;
        return b.buttonIndex == this.buttonIndex && CollectionsUtil.compareArrays(this.buttonIds, b.buttonIds);
    }
}

