/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nintaco.App;
import nintaco.PPU;
import nintaco.cartdb.Cart;
import nintaco.cartdb.CartDB;
import nintaco.files.CartFile;
import nintaco.gui.glasses.GlassesFrame;
import nintaco.gui.image.ImagePane;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceConfig;
import nintaco.input.InputDevices;
import nintaco.input.Ports;
import nintaco.input.other.SetPorts;
import nintaco.preferences.AppPrefs;

public class Inputs
implements Serializable {
    private static final long serialVersionUID = 0L;
    private Ports ports;
    private List<DeviceConfig> deviceConfigs;
    private Boolean autoConfigure;
    private Integer autofireRate;
    private Integer highSpeedRate;
    private Boolean allowImpossibleInput;
    private Boolean showZapperCrosshairs;
    private Boolean hideMouseCursor;
    private Boolean hideInactiveMouse;
    private Boolean hideFullscreenMouse;
    private Boolean exchangeGlasses;
    private Boolean disableKeyboardRewindTime;
    private Integer zapperLightDetectionMargin;

    public Inputs() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (this.deviceConfigs == null) {
                this.deviceConfigs = new ArrayList<DeviceConfig>();
            }
            while (this.deviceConfigs.size() < 36) {
                this.deviceConfigs.add(null);
            }
            for (int i = 35; i >= 0; --i) {
                if (this.deviceConfigs.get(i) != null) continue;
                this.deviceConfigs.set(i, InputDevices.newDeviceConfig(i));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAutofireRate() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (this.autofireRate == null) {
                this.autofireRate = 4;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.autofireRate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutofireRate(int autofireRate) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            this.autofireRate = autofireRate;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHighSpeedRate() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (this.highSpeedRate == null) {
                this.highSpeedRate = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.highSpeedRate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighSpeedRate(int highSpeedRate) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            this.highSpeedRate = highSpeedRate;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAutoConfigure() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (this.autoConfigure == null) {
                this.autoConfigure = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.autoConfigure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoConfigure(boolean autoConfigure) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            this.autoConfigure = autoConfigure;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllowImpossibleInput() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (this.allowImpossibleInput == null) {
                this.allowImpossibleInput = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.allowImpossibleInput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowImpossibleInput(boolean allowImpossibleInput) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            this.allowImpossibleInput = allowImpossibleInput;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShowZapperCrosshairs() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (this.showZapperCrosshairs == null) {
                this.showZapperCrosshairs = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.showZapperCrosshairs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowZapperCrosshairs(boolean showZapperCrosshairs) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            this.showZapperCrosshairs = showZapperCrosshairs;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHideMouseCursor() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (this.hideMouseCursor == null) {
                this.hideMouseCursor = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.hideMouseCursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHideMouseCursor(boolean hideMouseCursor) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            this.hideMouseCursor = hideMouseCursor;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHideInactiveMouse() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (this.hideInactiveMouse == null) {
                this.hideInactiveMouse = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.hideInactiveMouse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHideInactiveMouse(boolean hideInactiveMouse) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            this.hideInactiveMouse = hideInactiveMouse;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHideFullscreenMouse() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (this.hideFullscreenMouse == null) {
                this.hideFullscreenMouse = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.hideFullscreenMouse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHideFullscreenMouse(boolean hideFullscreenMouse) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            this.hideFullscreenMouse = hideFullscreenMouse;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExchangeGlasses() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (this.exchangeGlasses == null) {
                this.exchangeGlasses = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.exchangeGlasses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExchangeGlasses(boolean exchangeGlasses) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            this.exchangeGlasses = exchangeGlasses;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisableKeyboardRewindTime() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (this.disableKeyboardRewindTime == null) {
                this.disableKeyboardRewindTime = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disableKeyboardRewindTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisableKeyboardRewindTime(boolean disableKeyboardRewindTime) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            this.disableKeyboardRewindTime = disableKeyboardRewindTime;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getZapperLightDetectionMargin() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (this.zapperLightDetectionMargin == null) {
                this.zapperLightDetectionMargin = 3;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.zapperLightDetectionMargin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZapperLightDetectionMargin(int zapperLightDetectionMargin) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            this.zapperLightDetectionMargin = zapperLightDetectionMargin;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceConfigs(List<DeviceConfig> deviceConfigs) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            this.deviceConfigs = deviceConfigs;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public List<DeviceConfig> getDeviceConfigs() {
        return this.deviceConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ports getPorts() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (this.ports == null) {
                this.ports = Ports.DEFAULTS;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPorts(Ports ports) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            this.ports = ports;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyButtonMapping(int inputDevice, int button, List<DeviceConfig> configs) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            configs.get(inputDevice).getButtonMappings().set(button, this.getButtonMapping(inputDevice, button).copy());
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyDeviceConfig(int inputDevice, List<DeviceConfig> configs) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            configs.set(inputDevice, this.deviceConfigs.get(inputDevice).copy());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceConfig> copyDeviceConfigs() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            ArrayList<DeviceConfig> configs = new ArrayList<DeviceConfig>();
            for (DeviceConfig config : this.deviceConfigs) {
                configs.add(config.copy());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return configs;
        }
    }

    public void autoConfigure() {
        this.autoConfigure(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoConfigure(CartFile cartFile) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (this.isAutoConfigure()) {
                Object portDevices;
                int consoleType = 0;
                boolean multitap = false;
                if (cartFile != null && cartFile.isVsDualSystem()) {
                    consoleType = 2;
                    portDevices = this.setPortDevices(0, 1, 2, 3);
                } else {
                    Cart cart = cartFile != null && CartDB.isEnabled() ? cartFile.getCart() : null;
                    switch (cart == null ? -1 : cart.getDevice()) {
                        case 14: {
                            multitap = true;
                            portDevices = this.setPortDevices(0, 1, 2, 3);
                            break;
                        }
                        case 32: {
                            portDevices = this.setPortDevices(0, 4);
                            break;
                        }
                        case 1: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(16);
                            break;
                        }
                        case 3: {
                            portDevices = this.setPortDevices(0, 5);
                            break;
                        }
                        case 4: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(6);
                            break;
                        }
                        case 5: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(7);
                            break;
                        }
                        case 6: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(8);
                            break;
                        }
                        case 7: {
                            consoleType = 1;
                            portDevices = new int[][]{{0, 9}, {1, 10}, {4, -1}};
                            break;
                        }
                        case 8: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(11);
                            break;
                        }
                        case 9: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(12);
                            break;
                        }
                        case 10: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(14);
                            break;
                        }
                        case 12: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(18);
                            break;
                        }
                        case 13: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(15);
                            break;
                        }
                        case 15: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(19);
                            break;
                        }
                        case 16: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(20);
                            break;
                        }
                        case 17: {
                            portDevices = this.setPortDevices(21, 0);
                            break;
                        }
                        case 18: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(22);
                            break;
                        }
                        case 19: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(23);
                            break;
                        }
                        case 20: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(24);
                            break;
                        }
                        case 21: {
                            portDevices = this.setPortDevices(25, 1);
                            break;
                        }
                        case 22: {
                            portDevices = this.setPortDevices(0, 26);
                            break;
                        }
                        case 23: {
                            portDevices = this.setPortDevices(27, 28);
                            break;
                        }
                        case 26: {
                            portDevices = this.setPortDevices(0, 30);
                            break;
                        }
                        case 27: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(31);
                            break;
                        }
                        case 28: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(32);
                            break;
                        }
                        case 30: {
                            consoleType = 1;
                            portDevices = this.setExpansionPortDevice(34);
                            break;
                        }
                        case 29: {
                            portDevices = this.setPortDevices(0, 33);
                            break;
                        }
                        case 31: {
                            portDevices = this.setPortDevices(35, -1);
                            break;
                        }
                        default: {
                            portDevices = this.setPortDevices(0, 1);
                        }
                    }
                }
                new SetPorts(new Ports((int[][])portDevices, multitap, consoleType)).run(null);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private int[][] setExpansionPortDevice(int device) {
        return new int[][]{{0, 0}, {1, 1}, {4, device}};
    }

    private int[][] setPortDevices(int ... devices) {
        int[][] portDevices = new int[devices.length][2];
        for (int i = 0; i < devices.length; ++i) {
            portDevices[i][0] = i;
            portDevices[i][1] = devices[i];
        }
        return portDevices;
    }

    public static void clearAllDeviceConfigs(List<DeviceConfig> configs) {
        for (int i = 0; i < 36; ++i) {
            Inputs.clearDeviceConfig(i, configs);
        }
    }

    public static void clearDeviceConfig(int inputDevice, List<DeviceConfig> configs) {
        configs.get(inputDevice).clear();
    }

    public static void clearButtonMapping(int inputDevice, int button, List<DeviceConfig> configs) {
        DeviceConfig config = configs.get(inputDevice);
        config.getButtonMappings().set(button, config.getDeviceDescriptor().getNoButtonMapping(button));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ButtonMapping getButtonMapping(int inputDevice, int button) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Inputs.getButtonMapping(inputDevice, button, this.deviceConfigs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetDeviceConfigs(int inputDevice) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            Inputs.resetDeviceConfigs(inputDevice, this.deviceConfigs);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static ButtonMapping getButtonMapping(int inputDevice, int button, List<DeviceConfig> configs) {
        return configs.get(inputDevice).getButtonMappings().get(button);
    }

    public static void resetDeviceConfig(int inputDevice, int button, List<DeviceConfig> configs) {
        DeviceConfig config = configs.get(inputDevice);
        if (config == null) {
            configs.set(inputDevice, InputDevices.newDeviceConfig(inputDevice));
        } else {
            config.getButtonMappings().set(button, config.getDeviceDescriptor().getDefaultButtonMapping(button));
        }
    }

    public static void resetDeviceConfigs(int inputDevice, List<DeviceConfig> configs) {
        configs.set(inputDevice, InputDevices.newDeviceConfig(inputDevice));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            ImagePane imagePane = App.getImageFrame().getImagePane();
            imagePane.setHideInactiveMouseCursor(this.isHideInactiveMouse());
            imagePane.setHideFullscreenMouseCursor(this.isHideFullscreenMouse());
            GlassesFrame glassesFrame = App.getGlassesFrame();
            if (glassesFrame != null) {
                glassesFrame.setExchange(this.isExchangeGlasses());
            }
            PPU.setZapperLightDetectionMargin(this.getZapperLightDetectionMargin());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

