/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input;

import java.io.Serializable;

public class Ports
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int Port1 = 0;
    public static final int Port2 = 1;
    public static final int Tap1 = 0;
    public static final int Tap2 = 1;
    public static final int Tap3 = 2;
    public static final int Tap4 = 3;
    public static final int Main1 = 0;
    public static final int Main2 = 1;
    public static final int Sub1 = 2;
    public static final int Sub2 = 3;
    public static final int ExpansionPort = 4;
    public static final Ports DEFAULTS = new Ports(new int[][]{{0, 0}, {1, 1}}, false, 0);
    private final int[][] portDevices;
    private final boolean multitap;
    private final int consoleType;

    public static boolean hasDevice(int[][] portDevices, int device) {
        for (int i = portDevices.length - 1; i >= 0; --i) {
            if (portDevices[i][1] != device) continue;
            return true;
        }
        return false;
    }

    public Ports(int[][] portDevices, boolean multitap, int consoleType) {
        this.portDevices = portDevices;
        this.multitap = multitap;
        this.consoleType = consoleType;
    }

    public int[][] getPortDevices() {
        return this.portDevices;
    }

    public boolean isMultitap() {
        return this.multitap;
    }

    public int getConsoleType() {
        return this.consoleType;
    }

    public boolean hasDevice(int device) {
        return Ports.hasDevice(this.portDevices, device);
    }

    public Integer getDevice(int port) {
        for (int i = this.portDevices.length - 1; i >= 0; --i) {
            if (this.portDevices[i][0] != port) continue;
            return this.portDevices[i][1];
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Ports ports = (Ports)obj;
        if (this.portDevices.length != ports.portDevices.length || this.multitap != ports.multitap || this.consoleType != ports.consoleType) {
            return false;
        }
        for (int i = this.portDevices.length - 1; i >= 0; --i) {
            if (this.portDevices[i][0] == ports.portDevices[i][0] && this.portDevices[i][1] == ports.portDevices[i][1]) continue;
            return false;
        }
        return true;
    }
}

