/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.arkanoid;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;

public class ArkanoidDescriptor
extends DeviceDescriptor {
    public static final int Fire = 0;
    public static final int RewindTime = 1;
    private static final Component.Identifier.Button[] DEFAULTS = new Component.Identifier.Button[]{Component.Identifier.Button.LEFT, Component.Identifier.Button.RIGHT};

    public ArkanoidDescriptor() {
        super(5);
    }

    @Override
    public String getDeviceName() {
        return "Arkanoid Vaus";
    }

    @Override
    public int getButtonCount() {
        return 2;
    }

    @Override
    public int getRewindTimeButton() {
        return 1;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "Fire";
            }
            case 1: {
                return "Rewind Time";
            }
        }
        return "Unknown";
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultMouse(), buttonIndex, (Component.Identifier[])DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.updateRewindTime(pressedValues[1] != 0, portIndex);
        int mouseCoordinates = InputUtil.getMouseCoordinates();
        int buttons = 0;
        if (mouseCoordinates != 65535 && pressedValues[0] != 0) {
            buttons |= 4;
        }
        return bits | InputUtil.getMouseCoordinates() << 16 | (portIndex == 0 ? buttons : buttons << 8);
    }
}

