/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.barcodebattler;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.InputUtil;

public class BarcodeBattlerMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String data;
    private int dataIndex;
    private int bitIndex;

    @Override
    public int getInputDevice() {
        return 7;
    }

    @Override
    public void update(int buttons) {
        String barcode;
        if (this.data == null && (barcode = InputUtil.getBarcode()) != null) {
            if (barcode.length() == 8) {
                this.data = "     " + barcode + "SUNSOFT";
                this.dataIndex = -1;
            } else if (barcode.length() == 13) {
                this.data = barcode + "SUNSOFT";
                this.dataIndex = -1;
            }
        }
    }

    @Override
    public void writePort(int value) {
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 1 && this.data != null) {
            if (this.dataIndex == -1) {
                this.dataIndex = 0;
                this.bitIndex = -1;
                return 4;
            }
            if (this.bitIndex == -1) {
                this.bitIndex = 0;
                return 4;
            }
            if (this.bitIndex == 8) {
                this.bitIndex = -1;
                if (++this.dataIndex == this.data.length()) {
                    this.data = null;
                }
                return 0;
            }
            int value = (~this.data.charAt(this.dataIndex) >> this.bitIndex & 1) << 2;
            ++this.bitIndex;
            return value;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        if (portIndex == 1 && this.data != null) {
            if (this.dataIndex == -1 || this.bitIndex == -1) {
                return 4;
            }
            if (this.bitIndex == 8) {
                return 0;
            }
            String d = this.data;
            int index = this.dataIndex;
            if (d != null && index < this.data.length()) {
                return (~d.charAt(index) >> this.bitIndex & 1) << 2;
            }
            return 0;
        }
        return 0;
    }
}

