/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.doremikkokeyboard;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;

public class DoremikkoKeyboardDescriptor
extends DeviceDescriptor {
    public static final int KeyF2 = 0;
    public static final int KeyFs2 = 1;
    public static final int KeyG2 = 2;
    public static final int KeyGs2 = 3;
    public static final int KeyA2 = 4;
    public static final int KeyAs2 = 5;
    public static final int KeyB2 = 6;
    public static final int KeyC3 = 7;
    public static final int KeyCs3 = 8;
    public static final int KeyD3 = 9;
    public static final int KeyDs3 = 10;
    public static final int KeyE3 = 11;
    public static final int KeyF3 = 12;
    public static final int KeyFs3 = 13;
    public static final int KeyG3 = 14;
    public static final int KeyGs3 = 15;
    public static final int KeyA3 = 16;
    public static final int KeyAs3 = 17;
    public static final int KeyB3 = 18;
    public static final int KeyC4 = 19;
    public static final int KeyCs4 = 20;
    public static final int KeyD4 = 21;
    public static final int KeyDs4 = 22;
    public static final int KeyE4 = 23;
    public static final int KeyF4 = 24;
    public static final int KeyFs4 = 25;
    public static final int KeyG4 = 26;
    public static final int KeyGs4 = 27;
    public static final int KeyA4 = 28;
    public static final int KeyAs4 = 29;
    public static final int KeyB4 = 30;
    public static final int KeyC5 = 31;
    public static final int KeyCs5 = 32;
    public static final int KeyD5 = 33;
    public static final int KeyDs5 = 34;
    public static final int KeyE5 = 35;
    public static final int RewindTime = 36;
    public static final String[] NAMES = new String[]{"F2", "F#2", "G2", "G#2", "A2", "A#2", "B2", "C3", "C#3", "D3", "D#3", "E3", "F3", "F#3", "G3", "G#3", "A3", "A#3", "B3", "C4", "C#4", "D4", "D#4", "E4", "F4", "F#4", "G4", "G#4", "A4", "A#4", "B4", "C5", "C#5", "D5", "D#5", "E5", "Rewind Time"};
    private static final Component.Identifier.Key[] DEFAULTS = new Component.Identifier.Key[]{Component.Identifier.Key.Z, Component.Identifier.Key.S, Component.Identifier.Key.X, Component.Identifier.Key.D, Component.Identifier.Key.C, Component.Identifier.Key.F, Component.Identifier.Key.V, Component.Identifier.Key.B, Component.Identifier.Key.H, Component.Identifier.Key.N, Component.Identifier.Key.J, Component.Identifier.Key.M, Component.Identifier.Key.COMMA, Component.Identifier.Key.L, Component.Identifier.Key.PERIOD, Component.Identifier.Key.SEMICOLON, Component.Identifier.Key.SLASH, Component.Identifier.Key.APOSTROPHE, Component.Identifier.Key.RSHIFT, Component.Identifier.Key.Q, Component.Identifier.Key._2, Component.Identifier.Key.W, Component.Identifier.Key._3, Component.Identifier.Key.E, Component.Identifier.Key.R, Component.Identifier.Key._5, Component.Identifier.Key.T, Component.Identifier.Key._6, Component.Identifier.Key.Y, Component.Identifier.Key._7, Component.Identifier.Key.U, Component.Identifier.Key.I, Component.Identifier.Key._9, Component.Identifier.Key.O, Component.Identifier.Key._0, Component.Identifier.Key.P, Component.Identifier.Key.EQUALS};
    private boolean upperKeys;

    public DoremikkoKeyboardDescriptor() {
        super(13);
    }

    @Override
    public String getDeviceName() {
        return "Doremikko Keyboard";
    }

    @Override
    public int getButtonCount() {
        return 37;
    }

    @Override
    public int getRewindTimeButton() {
        return 36;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        return NAMES[buttonIndex];
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultKeyboard(), buttonIndex, (Component.Identifier[])DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.updateRewindTime(pressedValues[36] != 0, portIndex);
        int value = 0;
        int offset = this.upperKeys ? 18 : 0;
        if (pressedValues[offset] != 0) {
            value |= 0x400;
        }
        if (pressedValues[1 + offset] != 0) {
            value |= 0x800;
        }
        int i = 2;
        int j = 65536;
        while (i < 18) {
            if (pressedValues[i + offset] != 0) {
                value |= j;
            }
            ++i;
            j <<= 1;
        }
        if (this.upperKeys) {
            this.upperKeys = false;
            return ~value & 0xFFFF0C00 | bits;
        }
        this.upperKeys = true;
        return value | bits;
    }
}

