/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.excitingboxing;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;

public class ExcitingBoxingDescriptor
extends DeviceDescriptor {
    public static final int LeftHook = 0;
    public static final int RightHook = 1;
    public static final int LeftJab = 2;
    public static final int RightJab = 3;
    public static final int Straight = 4;
    public static final int Body = 5;
    public static final int MoveLeft = 6;
    public static final int MoveRight = 7;
    public static final int RewindTime = 8;
    private static final Component.Identifier.Key[] DEFAULTS = new Component.Identifier.Key[]{Component.Identifier.Key.R, Component.Identifier.Key.Y, Component.Identifier.Key.F, Component.Identifier.Key.H, Component.Identifier.Key.T, Component.Identifier.Key.G, Component.Identifier.Key.LEFT, Component.Identifier.Key.RIGHT, Component.Identifier.Key.SPACE};

    public ExcitingBoxingDescriptor() {
        super(14);
    }

    @Override
    public String getDeviceName() {
        return "Exciting Boxing";
    }

    @Override
    public int getButtonCount() {
        return 9;
    }

    @Override
    public int getRewindTimeButton() {
        return 8;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "Left Hook";
            }
            case 1: {
                return "Right Hook";
            }
            case 2: {
                return "Left Jab";
            }
            case 3: {
                return "Right Jab";
            }
            case 4: {
                return "Straight";
            }
            case 5: {
                return "Body";
            }
            case 6: {
                return "Move Left";
            }
            case 7: {
                return "Move Right";
            }
            case 8: {
                return "Rewind Time";
            }
        }
        return "Unknown";
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultKeyboard(), buttonIndex, (Component.Identifier[])DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.updateRewindTime(pressedValues[8] != 0, portIndex);
        if (pressedValues[0] != 0) {
            bits |= 0x10000;
        }
        if (pressedValues[1] != 0) {
            bits |= 0x20000;
        }
        if (pressedValues[2] != 0) {
            bits |= 0x40000;
        }
        if (pressedValues[3] != 0) {
            bits |= 0x80000;
        }
        if (pressedValues[4] != 0) {
            bits |= 0x100000;
        }
        if (pressedValues[5] != 0) {
            bits |= 0x200000;
        }
        if (pressedValues[6] != 0) {
            bits |= 0x400000;
        }
        if (pressedValues[7] != 0) {
            bits |= 0x800000;
        }
        return bits;
    }
}

