/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.excitingboxing;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.util.BitUtil;

public class ExcitingBoxingMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int state = 30;
    private int buttons;

    @Override
    public int getInputDevice() {
        return 14;
    }

    @Override
    public void update(int buttons) {
        this.buttons = buttons;
    }

    @Override
    public void writePort(int value) {
        int bits = 0;
        if (BitUtil.getBitBool(value, 1)) {
            if (BitUtil.getBitBool(this.buttons, 20)) {
                bits |= 0x10;
            }
            if (BitUtil.getBitBool(this.buttons, 19)) {
                bits |= 8;
            }
            if (BitUtil.getBitBool(this.buttons, 21)) {
                bits |= 4;
            }
            if (BitUtil.getBitBool(this.buttons, 18)) {
                bits |= 2;
            }
        } else {
            if (BitUtil.getBitBool(this.buttons, 17)) {
                bits |= 0x10;
            }
            if (BitUtil.getBitBool(this.buttons, 23)) {
                bits |= 8;
            }
            if (BitUtil.getBitBool(this.buttons, 22)) {
                bits |= 4;
            }
            if (BitUtil.getBitBool(this.buttons, 16)) {
                bits |= 2;
            }
        }
        this.state = ~bits & 0x1E;
    }

    @Override
    public int readPort(int portIndex) {
        return portIndex == 1 ? this.state : 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return this.readPort(portIndex);
    }

    @Override
    public void render(int[] screen) {
        int x = 176;
        int y = 206;
        InputIcons.ExcitingBoxing.render(screen, 176, 206);
        if (BitUtil.getBitBool(this.buttons, 16)) {
            InputIcons.GamepadAB.render(screen, 184, 208);
        }
        if (BitUtil.getBitBool(this.buttons, 17)) {
            InputIcons.GamepadAB.render(screen, 196, 208);
        }
        if (BitUtil.getBitBool(this.buttons, 18)) {
            InputIcons.GamepadAB.render(screen, 184, 214);
        }
        if (BitUtil.getBitBool(this.buttons, 19)) {
            InputIcons.GamepadAB.render(screen, 196, 214);
        }
        if (BitUtil.getBitBool(this.buttons, 20)) {
            InputIcons.GamepadAB.render(screen, 190, 214);
        }
        if (BitUtil.getBitBool(this.buttons, 21)) {
            InputIcons.GamepadAB.render(screen, 190, 220);
        }
        if (BitUtil.getBitBool(this.buttons, 22)) {
            InputIcons.ExcitingBoxingLeft.render(screen, 178, 213);
        }
        if (BitUtil.getBitBool(this.buttons, 23)) {
            InputIcons.ExcitingBoxingRight.render(screen, 203, 213);
        }
    }
}

