/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.familytrainermat;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.util.BitUtil;

public class FamilyTrainerMatMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int buttons;
    private int output;

    @Override
    public int getInputDevice() {
        return 15;
    }

    @Override
    public void update(int buttons) {
        this.buttons = buttons;
    }

    @Override
    public void writePort(int value) {
        this.output = !BitUtil.getBitBool(value, 2) ? ~this.buttons >> 23 & 0x1E : (!BitUtil.getBitBool(value, 1) ? ~this.buttons >> 19 & 0x1E : (!BitUtil.getBitBool(value, 0) ? ~this.buttons >> 15 & 0x1E : 0));
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 1) {
            return this.output;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return this.readPort(portIndex);
    }

    @Override
    public void render(int[] screen) {
        int x = 180;
        int y = 205;
        InputIcons.PowerPad.render(screen, 180, 205);
        if ((this.buttons & 0x8000000) != 0) {
            InputIcons.GamepadAB.render(screen, 182, 207);
        }
        if ((this.buttons & 0x4000000) != 0) {
            InputIcons.GamepadAB.render(screen, 187, 207);
        }
        if ((this.buttons & 0x2000000) != 0) {
            InputIcons.GamepadAB.render(screen, 193, 207);
        }
        if ((this.buttons & 0x1000000) != 0) {
            InputIcons.GamepadAB.render(screen, 198, 207);
        }
        if ((this.buttons & 0x800000) != 0) {
            InputIcons.GamepadAB.render(screen, 182, 213);
        }
        if ((this.buttons & 0x400000) != 0) {
            InputIcons.GamepadAB.render(screen, 187, 213);
        }
        if ((this.buttons & 0x200000) != 0) {
            InputIcons.GamepadAB.render(screen, 193, 213);
        }
        if ((this.buttons & 0x100000) != 0) {
            InputIcons.GamepadAB.render(screen, 198, 213);
        }
        if ((this.buttons & 0x80000) != 0) {
            InputIcons.GamepadAB.render(screen, 182, 219);
        }
        if ((this.buttons & 0x40000) != 0) {
            InputIcons.GamepadAB.render(screen, 187, 219);
        }
        if ((this.buttons & 0x20000) != 0) {
            InputIcons.GamepadAB.render(screen, 193, 219);
        }
        if ((this.buttons & 0x10000) != 0) {
            InputIcons.GamepadAB.render(screen, 198, 219);
        }
    }
}

