/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.horitrack;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.util.BitUtil;

public class HoriTrackMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int buttons;
    private int shiftRegister;
    private boolean strobe;

    @Override
    public int getInputDevice() {
        return 17;
    }

    @Override
    public void update(int buttons) {
        this.buttons = buttons;
    }

    @Override
    public void writePort(int value) {
        boolean priorStrobe = this.strobe;
        this.strobe = BitUtil.getBitBool(value, 0);
        if (priorStrobe && !this.strobe) {
            this.shiftRegister = 0x100000 | (this.buttons & 0xC00) << 7 | this.buttons >> 15 & 0x1FFFE;
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 0) {
            int value = this.shiftRegister;
            this.shiftRegister >>= 1;
            return value & 2;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return portIndex == 0 ? this.shiftRegister & 2 : 0;
    }

    @Override
    public void render(int[] screen) {
        int x = 172;
        int y = 188;
        InputIcons.HoriTrack.render(screen, 172, 188);
        if ((this.buttons & 0x10000) != 0) {
            InputIcons.GamepadAB.render(screen, 199, 208);
        }
        if ((this.buttons & 0x20000) != 0) {
            InputIcons.GamepadAB.render(screen, 192, 215);
        }
        if ((this.buttons & 0x40000) != 0) {
            InputIcons.GamepadStart.render(screen, 202, 197);
        }
        if ((this.buttons & 0x80000) != 0) {
            InputIcons.GamepadStart.render(screen, 196, 194);
        }
        if ((this.buttons & 0x100000) != 0) {
            InputIcons.GamepadDPad.render(screen, 179, 212);
        }
        if ((this.buttons & 0x200000) != 0) {
            InputIcons.GamepadDPad.render(screen, 179, 218);
        }
        if ((this.buttons & 0x400000) != 0) {
            InputIcons.GamepadDPad.render(screen, 176, 215);
        }
        if ((this.buttons & 0x800000) != 0) {
            InputIcons.GamepadDPad.render(screen, 182, 215);
        }
    }
}

