/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.mahjong;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;

public class MahjongDescriptor
extends DeviceDescriptor {
    public static final int KeyA = 0;
    public static final int KeyB = 1;
    public static final int KeyC = 2;
    public static final int KeyD = 3;
    public static final int KeyE = 4;
    public static final int KeyF = 5;
    public static final int KeyG = 6;
    public static final int KeyH = 7;
    public static final int KeyI = 8;
    public static final int KeyJ = 9;
    public static final int KeyK = 10;
    public static final int KeyL = 11;
    public static final int KeyM = 12;
    public static final int KeyN = 13;
    public static final int KeySelect = 14;
    public static final int KeyStart = 15;
    public static final int KeyKan = 16;
    public static final int KeyPon = 17;
    public static final int KeyChi = 18;
    public static final int KeyReach = 19;
    public static final int KeyRon = 20;
    public static final int RewindTime = 21;
    public static final String[] NAMES = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "Select", "Start", "Kan", "Pon", "Chi", "Reach", "Ron", "Rewind Time"};
    private static final Component.Identifier.Key[] DEFAULTS = new Component.Identifier.Key[]{Component.Identifier.Key.Q, Component.Identifier.Key.W, Component.Identifier.Key.E, Component.Identifier.Key.R, Component.Identifier.Key.T, Component.Identifier.Key.Y, Component.Identifier.Key.U, Component.Identifier.Key.I, Component.Identifier.Key.O, Component.Identifier.Key.P, Component.Identifier.Key.LBRACKET, Component.Identifier.Key.RBRACKET, Component.Identifier.Key.BACKSLASH, Component.Identifier.Key.DELETE, Component.Identifier.Key.APOSTROPHE, Component.Identifier.Key.RETURN, Component.Identifier.Key.G, Component.Identifier.Key.H, Component.Identifier.Key.J, Component.Identifier.Key.K, Component.Identifier.Key.L, Component.Identifier.Key.EQUALS};

    public MahjongDescriptor() {
        super(20);
    }

    @Override
    public String getDeviceName() {
        return "Mahjong";
    }

    @Override
    public int getButtonCount() {
        return 22;
    }

    @Override
    public int getRewindTimeButton() {
        return 21;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        return NAMES[buttonIndex];
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultKeyboard(), buttonIndex, (Component.Identifier[])DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.updateRewindTime(pressedValues[21] != 0, portIndex);
        int presses = 0;
        int value = 65535;
        for (int i = 20; i >= 0; --i) {
            if (pressedValues[i] == 0) continue;
            value = value << 5 | i;
            if (++presses == 3) break;
        }
        return value << 16 | bits;
    }
}

