/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.mahjong;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;

public class MahjongMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int buttons;
    private int shiftRegister;

    @Override
    public int getInputDevice() {
        return 20;
    }

    @Override
    public void update(int buttons) {
        this.buttons = buttons >> 16;
    }

    @Override
    public void writePort(int value) {
        int bits = this.buttons;
        this.shiftRegister = 0;
        switch (value & 6) {
            case 2: {
                int i = 2;
                while (i >= 0) {
                    switch (bits & 0x1F) {
                        case 8: {
                            this.shiftRegister |= 0x100;
                            break;
                        }
                        case 9: {
                            this.shiftRegister |= 0x80;
                            break;
                        }
                        case 10: {
                            this.shiftRegister |= 0x40;
                            break;
                        }
                        case 11: {
                            this.shiftRegister |= 0x20;
                            break;
                        }
                        case 12: {
                            this.shiftRegister |= 0x10;
                            break;
                        }
                        case 13: {
                            this.shiftRegister |= 8;
                            break;
                        }
                        case 31: {
                            return;
                        }
                    }
                    --i;
                    bits >>= 5;
                }
                break;
            }
            case 4: {
                int i = 2;
                while (i >= 0) {
                    switch (bits & 0x1F) {
                        case 0: {
                            this.shiftRegister |= 0x100;
                            break;
                        }
                        case 1: {
                            this.shiftRegister |= 0x80;
                            break;
                        }
                        case 2: {
                            this.shiftRegister |= 0x40;
                            break;
                        }
                        case 3: {
                            this.shiftRegister |= 0x20;
                            break;
                        }
                        case 4: {
                            this.shiftRegister |= 0x10;
                            break;
                        }
                        case 5: {
                            this.shiftRegister |= 8;
                            break;
                        }
                        case 6: {
                            this.shiftRegister |= 4;
                            break;
                        }
                        case 7: {
                            this.shiftRegister |= 2;
                            break;
                        }
                        case 31: {
                            return;
                        }
                    }
                    --i;
                    bits >>>= 5;
                }
                break;
            }
            case 6: {
                int i = 2;
                while (i >= 0) {
                    switch (bits & 0x1F) {
                        case 14: {
                            this.shiftRegister |= 0x100;
                            break;
                        }
                        case 15: {
                            this.shiftRegister |= 0x80;
                            break;
                        }
                        case 16: {
                            this.shiftRegister |= 0x40;
                            break;
                        }
                        case 17: {
                            this.shiftRegister |= 0x20;
                            break;
                        }
                        case 18: {
                            this.shiftRegister |= 0x10;
                            break;
                        }
                        case 19: {
                            this.shiftRegister |= 8;
                            break;
                        }
                        case 20: {
                            this.shiftRegister |= 4;
                            break;
                        }
                        case 31: {
                            return;
                        }
                    }
                    --i;
                    bits >>>= 5;
                }
                break;
            }
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 1) {
            int value = this.shiftRegister & 2;
            this.shiftRegister >>= 1;
            return value;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return portIndex == 1 ? this.shiftRegister & 2 : 0;
    }

    @Override
    public void render(int[] screen) {
        int x = 169;
        int y = 211;
        InputIcons.Mahjong.render(screen, 169, 211);
        int bits = this.buttons;
        int i = 2;
        while (i >= 0) {
            int b = bits & 0x1F;
            if (b == 31) {
                return;
            }
            if (b <= 12) {
                InputIcons.FamilyBasicKeyboardKey.render(screen, 171 + 3 * b, 214);
            } else if (b == 13) {
                InputIcons.GamepadAB.render(screen, 210, 213);
            } else {
                InputIcons.FamilyBasicKeyboardKey.render(screen, 186 + 3 * (b - 14), 217);
            }
            --i;
            bits >>= 5;
        }
    }
}

