/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.multitap;

import java.io.Serializable;
import nintaco.input.gamepad.GamepadMapper;
import nintaco.input.gamepad.LagDeviceMapper;

public class NESFourScoreMapper
extends LagDeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int shift0;
    private final int shift1;
    private final int signature;
    private final int portIndex;
    private int shiftRegister;
    private boolean strobe;

    public NESFourScoreMapper(int portIndex) {
        this.portIndex = portIndex;
        this.shift0 = portIndex << 3;
        this.shift1 = portIndex + 1 << 3;
        this.signature = portIndex == 0 ? 524288 : 262144;
    }

    @Override
    public int getInputDevice() {
        return -2;
    }

    @Override
    public void writePort(int value) {
        boolean bl = this.strobe = (value & 1) == 1;
        if (this.strobe) {
            this.updateButtons();
            this.shiftRegister = this.signature | this.buttons >> this.shift1 & 0xFF00 | this.buttons >> this.shift0 & 0xFF;
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (this.portIndex == portIndex) {
            int value = this.shiftRegister & 1;
            if (!this.strobe) {
                this.shiftRegister >>= 1;
            }
            return value;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return this.portIndex == portIndex ? this.shiftRegister & 1 : 0;
    }

    @Override
    public void render(int[] screen) {
        NESFourScoreMapper.render(screen, this.buttons);
    }

    public static void render(int[] screen, int buttons) {
        GamepadMapper.render(screen, 0, buttons & 0xFF);
        GamepadMapper.render(screen, 1, buttons >> 8 & 0xFF);
        GamepadMapper.render(screen, 2, buttons >> 16 & 0xFF);
        GamepadMapper.render(screen, 3, buttons >> 24 & 0xFF);
    }
}

