/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.oekakids;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.util.BitUtil;

public class OekaKidsMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int[] XS = new int[256];
    private static final int[] YS = new int[256];
    private int buttons;
    private int shiftRegister;
    private boolean readMode;
    private boolean shift;

    @Override
    public int getInputDevice() {
        return 22;
    }

    @Override
    public void update(int buttons) {
        this.buttons = buttons;
    }

    @Override
    public void writePort(int value) {
        boolean nextReadMode = BitUtil.getBitBool(value, 0);
        boolean nextShift = BitUtil.getBitBool(value, 1);
        if (nextReadMode) {
            if (!this.shift && nextShift) {
                this.shiftRegister <<= 1;
            }
        } else {
            this.shiftRegister = ~(XS[this.buttons >> 16 & 0xFF] | YS[this.buttons >> 24 & 0xFF] | this.buttons >> 10 & 3);
        }
        this.readMode = nextReadMode;
        this.shift = nextShift;
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 1) {
            if (this.readMode) {
                if (this.shift) {
                    return this.shiftRegister >> 15 & 8;
                }
                return 4;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return this.readPort(portIndex);
    }

    static {
        for (int i = XS.length - 1; i >= 0; --i) {
            OekaKidsMapper.XS[i] = (i * 240 >> 8) + 8 << 10;
            OekaKidsMapper.YS[i] = (i << 8) / 240 - 14 << 2;
        }
    }
}

