/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.pachinko;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;
import nintaco.input.Inputs;

public class PachinkoDescriptor
extends DeviceDescriptor {
    public static final int A = 0;
    public static final int B = 1;
    public static final int Select = 2;
    public static final int Start = 3;
    public static final int Up = 4;
    public static final int Down = 5;
    public static final int Left = 6;
    public static final int Right = 7;
    public static final int RewindTime = 8;
    private static final Component.Identifier.Key[] DEFAULTS = new Component.Identifier.Key[]{Component.Identifier.Key.X, Component.Identifier.Key.Z, Component.Identifier.Key.APOSTROPHE, Component.Identifier.Key.RETURN, Component.Identifier.Key.UP, Component.Identifier.Key.DOWN, Component.Identifier.Key.LEFT, Component.Identifier.Key.RIGHT, Component.Identifier.Key.EQUALS};
    private volatile boolean allowImpossibleInput;

    public PachinkoDescriptor() {
        super(23);
    }

    @Override
    public void handleSettingsChange(Inputs inputs) {
        super.handleSettingsChange(inputs);
        this.allowImpossibleInput = inputs.isAllowImpossibleInput();
    }

    @Override
    public String getDeviceName() {
        return "Pachinko";
    }

    @Override
    public int getButtonCount() {
        return 9;
    }

    @Override
    public int getRewindTimeButton() {
        return 8;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "A";
            }
            case 1: {
                return "B";
            }
            case 2: {
                return "Select";
            }
            case 3: {
                return "Start";
            }
            case 4: {
                return "Up";
            }
            case 5: {
                return "Down";
            }
            case 6: {
                return "Left";
            }
            case 7: {
                return "Right";
            }
            case 8: {
                return "Rewind Time";
            }
        }
        return "Unknown";
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultKeyboard(), buttonIndex, (Component.Identifier[])DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.updateRewindTime(pressedValues[8] != 0, portIndex);
        int buttons = 0;
        float wheel = InputUtil.getMouseDeltaWheel();
        if (wheel < 0.0f) {
            buttons |= 0x200;
        } else if (wheel > 0.0f) {
            buttons |= 0x100;
        }
        if (this.allowImpossibleInput) {
            if (pressedValues[7] != 0) {
                buttons |= 0x80;
            }
            if (pressedValues[6] != 0) {
                buttons |= 0x40;
            }
            if (pressedValues[5] != 0) {
                buttons |= 0x20;
            }
            if (pressedValues[4] != 0) {
                buttons |= 0x10;
            }
        } else {
            if (pressedValues[7] > pressedValues[6]) {
                buttons |= 0x80;
            }
            if (pressedValues[6] > pressedValues[7]) {
                buttons |= 0x40;
            }
            if (pressedValues[5] > pressedValues[4]) {
                buttons |= 0x20;
            }
            if (pressedValues[4] > pressedValues[5]) {
                buttons |= 0x10;
            }
        }
        if (consoleType != 1 || portIndex != 1) {
            if (pressedValues[3] != 0) {
                buttons |= 8;
            }
            if (pressedValues[2] != 0) {
                buttons |= 4;
            }
        }
        if (pressedValues[1] != 0) {
            buttons |= 2;
        }
        if (pressedValues[0] != 0) {
            buttons |= 1;
        }
        return buttons << 16 | bits;
    }
}

