/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.pachinko;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.util.BitUtil;

public class PachinkoMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int throttle = 255;
    private int throttleDirection;
    private int buttons;
    private int shiftRegister = 0xFF0000;
    private boolean strobe;

    @Override
    public int getInputDevice() {
        return 23;
    }

    @Override
    public void update(int buttons) {
        this.throttleDirection = 0;
        if (BitUtil.getBitBool(buttons, 25) && this.throttle > 159) {
            this.throttleDirection = -1;
            this.throttle -= 4;
        }
        if (BitUtil.getBitBool(buttons, 24) && this.throttle < 255) {
            this.throttleDirection = 1;
            this.throttle += 4;
        }
        this.buttons = buttons >> 16 & 0xFF;
    }

    @Override
    public void writePort(int value) {
        boolean prior = this.strobe;
        this.strobe = BitUtil.getBitBool(value, 0);
        if (prior && !this.strobe) {
            int t = this.throttle >> 7 & 1 | this.throttle >> 5 & 2 | this.throttle >> 3 & 4 | this.throttle >> 1 & 8 | this.throttle << 1 & 0x10 | this.throttle << 3 & 0x20 | this.throttle << 5 & 0x40 | this.throttle << 7 & 0x80;
            this.shiftRegister = 0xFF0000 | t << 8 | this.buttons;
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 0) {
            int value = (this.shiftRegister & 1) << 1;
            this.shiftRegister >>= 1;
            return value;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return portIndex == 0 ? (this.shiftRegister & 1) << 1 : 0;
    }

    @Override
    public void render(int[] screen) {
        int x = 172;
        int y = 196;
        InputIcons.Pachinko.render(screen, 172, 196);
        if (BitUtil.getBitBool(this.buttons, 0)) {
            InputIcons.GamepadAB.render(screen, 203, 210);
        }
        if (BitUtil.getBitBool(this.buttons, 1)) {
            InputIcons.GamepadAB.render(screen, 198, 210);
        }
        if (BitUtil.getBitBool(this.buttons, 2)) {
            InputIcons.GamepadStart.render(screen, 176, 220);
        }
        if (BitUtil.getBitBool(this.buttons, 3)) {
            InputIcons.GamepadStart.render(screen, 181, 220);
        }
        if (BitUtil.getBitBool(this.buttons, 4)) {
            InputIcons.GamepadDPad.render(screen, 178, 206);
        }
        if (BitUtil.getBitBool(this.buttons, 5)) {
            InputIcons.GamepadDPad.render(screen, 178, 212);
        }
        if (BitUtil.getBitBool(this.buttons, 6)) {
            InputIcons.GamepadDPad.render(screen, 175, 209);
        }
        if (BitUtil.getBitBool(this.buttons, 7)) {
            InputIcons.GamepadDPad.render(screen, 181, 209);
        }
        if (this.throttleDirection < 0) {
            InputIcons.PachinkoDown.render(screen, 188, 203);
        }
        if (this.throttleDirection > 0) {
            InputIcons.PachinkoUp.render(screen, 195, 197);
        }
    }
}

