/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.snesmouse;

import java.io.Serializable;
import nintaco.input.DeviceMapper;

public class SnesMouseMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int shift;
    private final int portIndex;
    private int buttons;
    private int shiftRegister;
    private int sensitivity;
    private boolean strobe;

    public SnesMouseMapper(int portIndex) {
        this.shift = portIndex << 3;
        this.portIndex = portIndex;
    }

    @Override
    public int getInputDevice() {
        return 29;
    }

    @Override
    public void update(int buttons) {
        this.buttons = buttons;
    }

    @Override
    public void writePort(int value) {
        boolean bl = this.strobe = (value & 1) == 1;
        if (this.strobe) {
            this.shiftRegister = (this.buttons >> this.shift & 0xFF | this.sensitivity << 4 | 1) << 16;
            int deltaY = (byte)(this.buttons >> 24) << this.sensitivity;
            int deltaX = (byte)(this.buttons >> 16) << this.sensitivity;
            this.shiftRegister = deltaY >= 0 ? (this.shiftRegister |= (deltaY & 0x7F) << 8) : (this.shiftRegister |= (0x80 | -deltaY & 0x7F) << 8);
            this.shiftRegister = deltaX >= 0 ? (this.shiftRegister |= deltaX & 0x7F) : (this.shiftRegister |= 0x80 | -deltaX & 0x7F);
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (this.portIndex == portIndex) {
            int value = this.shiftRegister >> 31 & 1;
            if (this.strobe) {
                this.sensitivity = this.sensitivity == 2 ? 0 : ++this.sensitivity;
            } else {
                this.shiftRegister <<= 1;
            }
            return value;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return this.portIndex == portIndex ? this.shiftRegister >> 31 & 1 : 0;
    }
}

