/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.subor;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.input.subor.SuborDescriptor;
import nintaco.util.BitUtil;

public class SuborMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int[][][] KEYS = new int[][][]{new int[][]{{14, 6, 0}, {58, 12, 0}}, new int[][]{{19, 12, 0}}, new int[][]{{16, 12, 0}}, new int[][]{{14, 15, 0}}, new int[][]{{10, 2, 0}}, new int[][]{{12, 9, 0}}, new int[][]{{17, 6, 0}, {61, 12, 0}}, new int[][]{{17, 15, 0}}, new int[][]{{8, 6, 0}, {61, 15, 0}}, new int[][]{{13, 12, 0}}, new int[][]{{10, 12, 0}}, new int[][]{{51, 9, 0}}, new int[][]{{7, 2, 0}}, new int[][]{{9, 9, 0}}, new int[][]{{11, 6, 0}, {64, 15, 0}}, new int[][]{{11, 15, 0}}, new int[][]{{48, 6, 0}}, new int[][]{{44, 6, 0}}, new int[][]{{54, 9, 0}}, new int[][]{{54, 18, 0}}, new int[][]{{30, 2, 0}}, new int[][]{{54, 6, 0}}, new int[][]{{48, 9, 0}, {64, 18, 0}}, new int[][]{{51, 6, 0}}, new int[][]{{29, 6, 0}, {64, 9, 0}}, new int[][]{{27, 9, 0}}, new int[][]{{31, 12, 0}}, new int[][]{{29, 15, 0}}, new int[][]{{21, 2, 0}}, new int[][]{{30, 9, 0}}, new int[][]{{32, 6, 0}, {58, 18, 5}}, new int[][]{{32, 15, 0}}, new int[][]{{39, 9, 0}}, new int[][]{{40, 9, 1}, {67, 15, 6}}, new int[][]{{51, 15, 0}}, new int[][]{{48, 18, 0}}, new int[][]{{27, 2, 0}}, new int[][]{{36, 9, 0}}, new int[][]{{41, 6, 0}}, new int[][]{{51, 18, 0}}, new int[][]{{6, 9, 0}}, new int[][]{{2, 12, 4}}, new int[][]{{8, 15, 0}}, new int[][]{{2, 9, 3}}, new int[][]{{2, 2, 0}}, new int[][]{{7, 12, 0}}, new int[][]{{5, 6, 0}, {58, 15, 0}}, new int[][]{{2, 18, 3}, {43, 18, 3}}, new int[][]{{23, 6, 0}, {58, 9, 0}}, new int[][]{{21, 9, 0}}, new int[][]{{28, 12, 0}}, new int[][]{{26, 15, 0}}, new int[][]{{16, 2, 0}}, new int[][]{{24, 9, 0}}, new int[][]{{26, 6, 0}, {61, 9, 0}}, new int[][]{{25, 12, 0}}, new int[][]{{35, 6, 0}, {67, 6, 0}}, new int[][]{{34, 12, 0}}, new int[][]{{37, 12, 0}}, new int[][]{{35, 15, 0}, {61, 6, 0}}, new int[][]{{24, 2, 0}}, new int[][]{{33, 9, 0}}, new int[][]{{38, 6, 0}}, new int[][]{{2, 15, 5}, {41, 15, 5}}, new int[][]{{18, 9, 0}}, new int[][]{{22, 12, 0}}, new int[][]{{23, 15, 0}}, new int[][]{{14, 18, 2}}, new int[][]{{13, 2, 0}}, new int[][]{{15, 9, 0}}, new int[][]{{20, 6, 0}, {64, 12, 0}}, new int[][]{{20, 15, 0}}};
    private final int[][] KeyMatrix = new int[10][2];
    private final boolean[] PressedKeys = new boolean[72];
    private int row;
    private int column;
    private boolean enabled;
    private int mouseButtons;
    private int deltaX;
    private int deltaY;
    private int dx;
    private int sx;
    private int dy;
    private int sy;
    private int byteIndex;
    private int shiftRegister;
    private boolean strobe;

    @Override
    public int getInputDevice() {
        return 30;
    }

    @Override
    public void update(int buttons) {
        if ((buttons & 0x100) != 0) {
            this.mouseButtons = (buttons & 0xC00) >> 4;
            this.deltaX += (byte)(buttons >> 16);
            this.deltaY += (byte)(buttons >> 24);
        } else {
            int i;
            for (i = 9; i >= 0; --i) {
                this.KeyMatrix[i][0] = 30;
                this.KeyMatrix[i][1] = 30;
            }
            for (i = 71; i >= 0; --i) {
                this.PressedKeys[i] = false;
            }
            this.setKeyBit(buttons >> 16 & 0x7F);
            this.setKeyBit(buttons >> 23 & 0x7F);
            if ((buttons & Integer.MIN_VALUE) != 0) {
                this.setKeyBit(SuborDescriptor.KEY_MAP[70]);
            }
            if ((buttons & 0x40000000) != 0) {
                this.setKeyBit(SuborDescriptor.KEY_MAP[72]);
            }
        }
    }

    private void setKeyBit(int key) {
        if (key < 72) {
            int[] nArray = this.KeyMatrix[key >> 3];
            int n = key >> 2 & 1;
            nArray[n] = nArray[n] & ~(1 << 1 + (key & 3));
            this.PressedKeys[key] = true;
        }
    }

    @Override
    public void writePort(int value) {
        this.enabled = BitUtil.getBitBool(value, 2);
        if (this.enabled) {
            int col = BitUtil.getBit(value, 1);
            if (this.column == 1 && col == 0 && ++this.row == 10) {
                this.row = 0;
            }
            this.column = col;
            if (BitUtil.getBitBool(value, 0)) {
                this.row = 0;
            }
        }
        if (this.strobe) {
            if ((value & 6) != 0) {
                this.strobe = false;
                switch (this.byteIndex) {
                    case 0: {
                        this.dx = 0;
                        this.sx = 0;
                        if (this.deltaX != 0) {
                            if (this.deltaX > 0) {
                                this.dx = Math.min(31, this.deltaX);
                                this.deltaX -= this.dx;
                            } else {
                                this.dx = Math.min(31, -this.deltaX);
                                this.deltaX += this.dx;
                                this.sx = 32;
                            }
                        }
                        this.dy = 0;
                        this.sy = 0;
                        if (this.deltaY != 0) {
                            if (this.deltaY > 0) {
                                this.dy = Math.min(31, this.deltaY);
                                this.deltaY -= this.dy;
                            } else {
                                this.dy = Math.min(31, -this.deltaY);
                                this.deltaY += this.dy;
                                this.sy = 8;
                            }
                        }
                        if (this.dx <= 1 && this.dy <= 1) {
                            this.shiftRegister = this.mouseButtons | this.sx | this.dx << 4 | this.sy | this.dy << 2;
                            break;
                        }
                        this.shiftRegister = 1 | this.mouseButtons | this.sx | this.dx & 0x10 | this.sy | (this.dy & 0x10) >> 2;
                        this.byteIndex = 1;
                        break;
                    }
                    case 1: {
                        this.shiftRegister = 2 | this.mouseButtons | (this.dx & 0xF) << 2;
                        this.byteIndex = 2;
                        break;
                    }
                    case 2: {
                        this.shiftRegister = 3 | this.mouseButtons | (this.dy & 0xF) << 2;
                        this.byteIndex = 0;
                    }
                }
            }
        } else {
            this.strobe = BitUtil.getBitBool(value, 0);
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 1) {
            int value = 0;
            value = this.enabled ? this.KeyMatrix[this.row][this.column] : 30;
            this.shiftRegister <<= 1;
            return value |= BitUtil.getBit(this.shiftRegister, 7);
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        if (portIndex == 1) {
            int value = this.enabled ? this.KeyMatrix[this.row][this.column] : 30;
            return value |= BitUtil.getBit(this.shiftRegister, 7);
        }
        return 0;
    }

    private void render(int[] screen, int x, int y, int[] K) {
        InputIcons icon;
        switch (K[2]) {
            case 1: {
                icon = InputIcons.SuborKeyboardEnter;
                break;
            }
            case 2: {
                icon = InputIcons.SuborKeyboardSpace;
                break;
            }
            case 3: {
                icon = InputIcons.SuborKeyboard3;
                break;
            }
            case 4: {
                icon = InputIcons.FamilyBasicKeyboardShift;
                break;
            }
            case 5: {
                icon = InputIcons.SuborKeyboard5;
                break;
            }
            case 6: {
                icon = InputIcons.SuborKeyboardVertical;
                break;
            }
            default: {
                icon = InputIcons.FamilyBasicKeyboardKey;
            }
        }
        icon.render(screen, x + K[0], y + K[1]);
    }

    @Override
    public void render(int[] screen) {
        int x = 157;
        int y = 205;
        InputIcons.SuborKeyboard.render(screen, 157, 205);
        for (int i = 71; i >= 0; --i) {
            if (!this.PressedKeys[i]) continue;
            int[][] K = KEYS[i];
            if (K.length == 2) {
                this.render(screen, 157, 205, K[1]);
            }
            this.render(screen, 157, 205, K[0]);
        }
    }
}

