/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.topriderbike;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;
import nintaco.input.Inputs;

public class TopRiderBikeDescriptor
extends DeviceDescriptor {
    public static final int Accelerate = 0;
    public static final int Brake = 1;
    public static final int Select = 2;
    public static final int Start = 3;
    public static final int ShiftGear = 4;
    public static final int Wheelie = 5;
    public static final int SteerLeft = 6;
    public static final int SteerRight = 7;
    public static final int RewindTime = 8;
    private static final Component.Identifier.Key[] DEFAULTS = new Component.Identifier.Key[]{Component.Identifier.Key.X, Component.Identifier.Key.Z, Component.Identifier.Key.APOSTROPHE, Component.Identifier.Key.RETURN, Component.Identifier.Key.UP, Component.Identifier.Key.DOWN, Component.Identifier.Key.LEFT, Component.Identifier.Key.RIGHT, Component.Identifier.Key.EQUALS};
    private volatile boolean allowImpossibleInput;

    public TopRiderBikeDescriptor() {
        super(32);
    }

    @Override
    public void handleSettingsChange(Inputs inputs) {
        super.handleSettingsChange(inputs);
        this.allowImpossibleInput = inputs.isAllowImpossibleInput();
    }

    @Override
    public String getDeviceName() {
        return "Top-Rider Bike";
    }

    @Override
    public int getButtonCount() {
        return 9;
    }

    @Override
    public int getRewindTimeButton() {
        return 8;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "Accelerate";
            }
            case 1: {
                return "Brake";
            }
            case 2: {
                return "Select";
            }
            case 3: {
                return "Start";
            }
            case 4: {
                return "Shift Gear";
            }
            case 5: {
                return "Wheelie";
            }
            case 6: {
                return "Steer Left";
            }
            case 7: {
                return "Steer Right";
            }
            case 8: {
                return "Rewind Time";
            }
        }
        return "Unknown";
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultKeyboard(), buttonIndex, (Component.Identifier[])DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.updateRewindTime(pressedValues[8] != 0, portIndex);
        int buttons = 0;
        if (this.allowImpossibleInput) {
            if (pressedValues[7] != 0) {
                buttons |= 0x800000;
            }
            if (pressedValues[6] != 0) {
                buttons |= 0x400000;
            }
        } else {
            if (pressedValues[7] > pressedValues[6]) {
                buttons |= 0x800000;
            }
            if (pressedValues[6] > pressedValues[7]) {
                buttons |= 0x400000;
            }
        }
        if (pressedValues[5] != 0) {
            buttons |= 0x200000;
        }
        if (pressedValues[4] != 0) {
            buttons |= 0x100000;
        }
        if (pressedValues[3] != 0) {
            buttons |= 0x80000;
        }
        if (pressedValues[2] != 0) {
            buttons |= 0x40000;
        }
        if (pressedValues[1] != 0) {
            buttons |= 0x20000;
        }
        if (pressedValues[0] != 0) {
            buttons |= 0x10000;
        }
        return buttons | bits;
    }
}

